/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.propertiespanel.editors;

import exenne.components.propertiespanel.IEditorChangeListener;
import exenne.components.propertiespanel.IPropertiesEditor;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * Construiesc un panou ce tine si afiseaza un combobox
 * @author iulian
 */
public class JSliderPropertiesEditor extends JPanel 
        implements IPropertiesEditor, ChangeListener {
    //Variabile de clasa
    private Collection backingValues;
    
    //Componente
    private JSlider slider;
    private Vector<IEditorChangeListener> editorChangeListeners;

    public JSliderPropertiesEditor(Collection values) {
        super();

        //Pastrez variabilele de clasa
        backingValues = values;
        
        //Creez componenta de editare
        slider = new JSlider(JSlider.HORIZONTAL, 0, backingValues.size() - 1, 0);
        slider.setMajorTickSpacing(1);
        slider.setPaintTicks(true);
        Hashtable labelTable = new Hashtable();
        int counter = 0;
        for (Object backingValue : backingValues) {
            labelTable.put( counter, new JLabel(backingValue.toString()));
            counter ++;
        }
        slider.setLabelTable( labelTable );
        slider.setPaintLabels(true);
        slider.setSnapToTicks(true);

        //initializez
        initialize();
    }

    /**
     * Functie de initializare
     */
    private void initialize() {
        //Fac layout-ul
        this.setLayout(new BorderLayout());
        this.add(slider, BorderLayout.CENTER);

        //Inregistrez ascultatorii
        editorChangeListeners = new Vector<IEditorChangeListener>();
        slider.addChangeListener(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        slider.setEnabled(enabled);
    }


    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Se implementeaza interfata IPropertiesEditor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin containerul global al editorului
     * @return
     */
    public JComponent getContainerComponent() {
        return this;
    }

    /**
     * Obtine componenta care realizeaza editarea propriu-zisa
     * @return
     */
    public JComponent getEditorComponent() {
        return slider;
    }

    /**
     * Seteaza numele componentei
     * @param name
     */
    @Override
    public void setEditorName(String name) {
        this.setName(name);
        slider.setName(name);
    }

    /**
    * Se seteaza valoarea ce se editeaza
    * @param objectClass
    * @param renderedObject
    */
    public void setValue(Class objectClass, Object renderedObject) {
        if (backingValues.contains(renderedObject)) {
            int counter = 0;
            int foundPosition = 0;
            for (Object object : backingValues) {
                if (object.equals(renderedObject)) {
                    foundPosition = counter;
                }
                counter ++;
            }
            
            //Setez sliderul la pozitia respectiva
            slider.setValue(foundPosition);
        }
    }

    /**
     * Se obtione valoarea din textfield cu cast la clasa specificata
     * @param objectClass
     * @return
     */
    public Object getValue(Class objectClass) {
        int value = slider.getValue();
        return backingValues.toArray()[value];
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *   Managementul actiunilor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Aici primesc evenimente de la slider
     * @param e
     */
    public void stateChanged(ChangeEvent e) {
        Iterator<IEditorChangeListener> iterator = editorChangeListeners.iterator();
        while (iterator.hasNext()) {
            IEditorChangeListener iEditorChangeListener = iterator.next();
            iEditorChangeListener.fireValueChanged();
        }
    }
    
    /**
     * Adaug un ascultator pentru schimbare valori
     * @param listener
     */
    public void addEditorChangeListener(IEditorChangeListener listener) {
        editorChangeListeners.add(listener);
    }

    /**
     * Deinregistrez un ascultator pentru schimbare valori
     * @param listener
     */
    public void removeEditorChangeListener(IEditorChangeListener listener) {
        editorChangeListeners.remove(listener);
    }
}
