/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.undosystem;

/**
 *
 * @author iulian
 */
import java.awt.Component;
import java.awt.Container;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.event.*;
import javax.swing.undo.*;
import java.util.Vector;

// An extension of UndoManager that provides two additional features:
// (1) The ability to add & remove listeners and (2) the ability to gain more
// extensive access to the edits being managed.
public class GlobalUndoManager extends UndoManager
          implements UndoableEditListener {
      //Undo State listeners
     private Vector<UndoStateListener> undoStateListeners;

     /**
      * Constructorul default
      */
    public GlobalUndoManager() {
        this(10);
    }


     /**
      * Constructies un manager de undo
      */
    public GlobalUndoManager(int capacity) {
        super();
        this.setLimit(capacity);

        undoStateListeners = new Vector<UndoStateListener>();
    }


      /**
       *  Return the complete list of edits in an array.
       */
      public synchronized UndoableEdit[] getEdits() {
        UndoableEdit[] array = new UndoableEdit[edits.size()];
        edits.copyInto(array);
        return array;
      }


      /**
       * Return all currently significant undoable edits. The first edit will be the
       */ 
      public synchronized UndoableEdit[] getUndoableEdits() {
      int size = edits.size();
      Vector v = new Vector(size);
      for (int i=size-1;i>=0;i--) {
        UndoableEdit u = (UndoableEdit)edits.elementAt(i);
        if (u.canUndo() && u.isSignificant())
          v.addElement(u);
      }
      UndoableEdit[] array = new UndoableEdit[v.size()];
      v.copyInto(array);
      return array;
    }


    /**
     * Return all currently significant redoable edits. The first edit will be the
     */ 
    public synchronized UndoableEdit[] getRedoableEdits() {
      int size = edits.size();
      Vector v = new Vector(size);
      for (int i=0; i<size; i++) {
        UndoableEdit u = (UndoableEdit)edits.elementAt(i);
        if (u.canRedo() && u.isSignificant())
          v.addElement(u);
      }
      UndoableEdit[] array = new UndoableEdit[v.size()];
      v.copyInto(array);
      return array;
    }


    /**
     * Add an edit and notify our listeners.
     */ 
    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
      boolean b = super.addEdit(anEdit);
      notifyStateListeners();
      return b;
    }


    /**
     * When an edit is sent to us, call addEdit() to notify any of our listeners.
     */ 
    @Override
    public synchronized void undoableEditHappened(UndoableEditEvent ev) {
      UndoableEdit undoableEdit;
      Object source = ev.getSource();

      //Daca sursa este ICanBeVisible atunci o folosesc pentru afisare
      if (source  instanceof ICanBeVisible && ev.getEdit().isSignificant()) {
          ICanBeVisible visibleComponent = (ICanBeVisible) source;
          undoableEdit = new EnsureComponentVisibleEdit(visibleComponent, ev.getEdit());
      } else {
          undoableEdit = ev.getEdit();
      }

      //Adaug modificarea
      addEdit(undoableEdit);
    }


    /**
     * undo
     * @throws CannotUndoException
     */
    @Override
    public synchronized void undo() throws CannotUndoException {
        super.undo();

        //Notific ascultatorii
        notifyStateListeners();
    }

    /**
     * redo
     * @throws CannotUndoException
     */
    @Override
    public synchronized void redo() throws CannotUndoException {
        super.redo();

        //Notific ascultatorii
        notifyStateListeners();
    }
    

    /**
     * undo or redo
     * @throws CannotRedoException
     * @throws CannotUndoException
     */
    @Override
    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        super.undoOrRedo();

        //Notific ascultatorii
        notifyStateListeners();
    }


    /**
     * Find the next edit to be undone
     * @return
     */
    @Override
    protected UndoableEdit editToBeUndone() {
        return super.editToBeUndone();
    }

    /**
     * Find the next edit to be redone
     * @return
     */
    @Override
    protected UndoableEdit editToBeRedone() {
        UndoableEdit suggestedEdit = super.editToBeRedone();
        int suggestedEditIndex = edits.indexOf(suggestedEdit);

        //We will redo including the insignificant edits
        UndoableEdit nextInsignificantEdit = null;
        int count = edits.size();
        int i = suggestedEditIndex + 1;
        while ( i < count ) {
            UndoableEdit edit = (UndoableEdit)edits.elementAt(i++);
            if (!edit.isSignificant())
                nextInsignificantEdit = edit;
            else
                break;
        }

        //If we have an insignificant edit we return it
        if (nextInsignificantEdit != null)
            return nextInsignificantEdit;
        else return suggestedEdit;
    }



    /**
     * Undo many actions
     * @param edit
     * @throws CannotUndoException
     */
    @Override
    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        super.undoTo(edit);

        //Notific ascultatorii
        notifyStateListeners();
    }

    /**
     * redo many actions
     * @param edit
     * @throws CannotRedoException
     */
    @Override
    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        super.redoTo(edit);

        //Notific ascultatorii
        notifyStateListeners();
    }

    /**
     * Flush the undo manager
     */
    @Override
    public synchronized void discardAllEdits() {
        super.discardAllEdits();

        //Notific ascultatorii
        notifyStateListeners();
    }

    /**
     * Discard all edits related to a specific component
     * @param c
     */
    public synchronized void discardEditsRelatedTo(Container c) {
        Enumeration cursor = edits.elements();
        while (cursor.hasMoreElements()) {
            UndoableEdit e = (UndoableEdit)cursor.nextElement();
            if (e instanceof EnsureComponentVisibleEdit) {
                EnsureComponentVisibleEdit ensureEdit = (EnsureComponentVisibleEdit) e;
                ICanBeVisible editSource = ensureEdit.getComponent();

                //Daca s-a inchis un parinte atunci anulez editarile
                if (editSource instanceof Component) {
                    Component editComponent = (Component) editSource;
                    if (c.isAncestorOf(editComponent))
                        ensureEdit.die();
                }
            }
        }

        //Notific ascultatorii
        notifyStateListeners();
    }


     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Managementul acultatorilor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/


    /**
     * Add a listener to be notified each time an edit is added to this manager.
     */ 
    public synchronized void addUndoStateListener(UndoStateListener l) {
        undoStateListeners.add(l);
    }


    /**
     * Remove a listener from this manager.
     */ 
    public synchronized void removeUndoStateListener(UndoStateListener l) {
        undoStateListeners.remove(l);
    }

    /**
     * Notific ascultatorii
     */
    private void notifyStateListeners() {
        Iterator<UndoStateListener> iterator = undoStateListeners.iterator();
        while (iterator.hasNext()) {
            UndoStateListener undoStateListener = iterator.next();
            undoStateListener.undoStateChanged();
        }
    }
}


