/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.checktree.test;

import exenne.components.checktree.CheckTreeManager;
import exenne.components.tree.expansion.JTreeExpandableComponentAdapter;
import exenne.components.tree.expansion.TreeNodesUtils;
import exenne.components.utils.RandomDataGenerator;
import exenne.components.utils.WindowUtilities;
import java.awt.BorderLayout;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/**
 *
 * @author iulian
 */
public class JTestCheckTree extends JPanel {
    private CheckTreeManager checkTreeManager;
        private JTree tree;
            private DefaultMutableTreeNode rootNode;
            private DefaultTreeModel treeModel;

     //Renderers
    private JTestCheckTreeRenderer myCheckTreeRenderer;

    /*
     * Constructorul pentru check tree
     */
    public JTestCheckTree(DefaultMutableTreeNode rootNode) {
        super();
        this.setLayout(new BorderLayout());

        this.add(new JLabel("test panel"),
                BorderLayout.NORTH);

        // <editor-fold defaultstate="collapsed" desc="Setez CheckTree-ul">
        this.rootNode = rootNode;
        if (rootNode != null) {
            treeModel = new DefaultTreeModel(rootNode);
            tree = new JTree(treeModel);
            tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
            tree.setShowsRootHandles(false);
            tree.setRootVisible(true);
            tree.setEditable(false);
            tree.setToggleClickCount(-1);
            myCheckTreeRenderer = new JTestCheckTreeRenderer();
            tree.setCellRenderer(myCheckTreeRenderer);
            checkTreeManager = new CheckTreeManager(tree);


            //Extind initial pana la Devize
            this.initialExpand();
            this.add(new JScrollPane(tree));
        } 
        // </editor-fold>
    }


    /*
     * Deschid arborele pana la Devize
     */
    private void initialExpand() {
        JTreeExpandableComponentAdapter expandableComponent = 
                new JTreeExpandableComponentAdapter(tree);
        TreeNodesUtils.expandAll(expandableComponent);
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Metode publice
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    public TreePath[] getCheckedPaths() {
        //Obtin caile selectate
        TreePath checkedPaths[] = checkTreeManager.getSelectionModel().getSelectionPaths();

        return checkedPaths;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Metode statice pentru rularea clasei
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Fac un arbore random
     * @return
     */
    private static DefaultMutableTreeNode generateRandomNode(int depth) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(
                "node_"+RandomDataGenerator.getRandomString(3));

        if (depth > 0) {
            int childs = RandomDataGenerator.getRandomInt(3);
            for (int i = 0; i < childs; i++) {
                DefaultMutableTreeNode child = generateRandomNode(depth-1);
                node.add(child);
            }
        }

        return node;
    }

    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Init look and feel
        WindowUtilities.initLookAndFeel();

        //Create and set up the window.
        JFrame frame = new JFrame("TableSelectionDemo");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //testez clasa
        JTestCheckTree testClass = new JTestCheckTree(generateRandomNode(3));
        frame.add(testClass);

        //Display the window.
        frame.setSize(500, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    /**
     * Metoda main
     * @param args
     */
    public static void main(String[] args) {
        //Initializez limba
        Locale.setDefault(new Locale("ro", "RO"));

        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
}
