/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.icons;

import java.awt.*;
import javax.swing.*;

/**
 * Icon pentru TreeTable
 *
 * @author iulian
 */
public class JNoIcon implements Icon {
    //Constante statice pentu cele mai folosite cazuri
    public static final JNoIcon ICON16 = new JNoIcon(16);
    public static final JNoIcon ICON24 = new JNoIcon(24);
    
    //Variabile de clasa
    private int width;
    private int height;

    /**
     * Contruiesc iconul default
     */
    public JNoIcon() {
        this(16);
    }

    /**
     * Construiesc un icon la dimensiunile presetate
     * @param size 
     */
    public JNoIcon(int size) {
        this.width = size;
        this.height = size;
    }

    //Pentru desenare
    private BasicStroke stroke = new BasicStroke(2);

    /**
     * Fac desenarea iconului
     * @param c
     * @param g
     * @param x
     * @param y 
     */
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D) g.create();

        g2d.setColor(Color.RED);
        g2d.setStroke(stroke);

        g2d.drawLine(x, y, x + width, y + height);
        g2d.drawLine(x, y + height, x + width, y);

        g2d.dispose();
    }

    /**
     * Obtine dimensiunea iconului
     * @return 
     */
    public int getIconWidth() {
        return width;
    }

    /**
     * Obtine dimensiunea iconului
     * @return 
     */
    public int getIconHeight() {
        return height;
    }
}