package exenne.components.jdatepicker;

import java.beans.PropertyChangeListener;

import javax.swing.event.ChangeListener;

/**
 * Created 18 April 2010
 * Updated 26 April 2010
 * 
 * @author Juan Heyns
 *
 * @param <T>
 */
public interface DateModel<T> {

	/**
	 * Adds a ChangeListener. ChangeListeners will be notified when the internal
	 * state of the control changes. This means that as a user scrolls through
	 * dates the internal model changes, which fires a ChangeEvent each time it
	 * changes.
	 * 
	 * @param changeListener
	 */
	public void addChangeListener(ChangeListener changeListener);

	/**
	 * Removes the specified ChangeListener. ChangeListeners will be notified
	 * when the selected date is changed.
	 * 
	 * @param arg
	 */
	public void removeChangeListener(ChangeListener changeListener);

	/**
	 * Getters and setters which represent a gregorian date.
	 * 
	 * @return
	 */
	public int getYear();
	
	/**
	 * Getters and setters which represent a gregorian date.
	 * 
	 * @return
	 */
	public void setYear(int year);
	
	/**
	 * Getters and setters which represent a gregorian date.
	 * 
	 * @return
	 */
	public int getMonth();
	
	/**
	 * Getters and setters which represent a gregorian date.
	 * 
	 * @return
	 */
	public void setMonth(int month);
	
	/**
	 * Getters and setters which represent a gregorian date.
	 * 
	 * @return
	 */
	public int getDay();
	
	/**
	 * Getters and setters which represent a gregorian date.
	 * 
	 * @return
	 */
	public void setDay(int day);
	
	/**
	 * Getters and setters which represent a gregorian date.
	 * 
	 * @return
	 */
	public void setDate(int year, int month, int day);
	
	/**
	 * Add or substract number of years.
	 * 
	 * @param add
	 */
	public void addYear(int add);
	
	/**
	 * Add or substract number of months.
	 * 
	 * @param add
	 */
	public void addMonth(int add);
	
	/**
	 * Add or substract number of day.
	 * 
	 * @param add
	 */
	public void addDay(int add);

	/**
	 * Get the value this model represents.
	 * 
	 * @return
	 */
	public T getValue();

	/**
	 * Set the value this model represents.
	 * 
	 * @param value
	 */
	public void setValue(T value);
	
	/**
	 * Is the value selected or is it not.
	 * 
	 * @return
	 */
	public boolean isSelected();
	
	/**
	 * Set the value as selected.
	 * 
	 * @param selected
	 */
	public void setSelected(boolean selected);
	
    /**
     * Adds a PropertyChangeListener to the list of bean listeners.
     * The listener is registered for all bound properties of the target bean.
     *
     * @param listener      the PropertyChangeListener to be added
     *
     * @see #removePropertyChangeListener(PropertyChangeListener)
     */
    public void addPropertyChangeListener(PropertyChangeListener listener);


    /**
     * Removes a PropertyChangeListener from the list of bean listeners.
     * This method should be used to remove PropertyChangeListeners that
     * were registered for all bound properties of the target bean.
     * 
     * @param listener      the PropertyChangeListener to be removed
     *
     * @see #addPropertyChangeListener(PropertyChangeListener)
     */
    public void removePropertyChangeListener(PropertyChangeListener listener);

}
