/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.jtable.rowheader;

import java.util.HashMap;
import javax.swing.AbstractListModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/**
 * Un model de lista ce se conecteaza cu un table model.
 * Acest model poate fi vazut ca o extensie a table modelului
 * @author iulian
 */
public abstract class RowHeaderModel extends AbstractListModel implements TableModelListener {
    private TableModel tabelModel;

    //Un cache temporar pentru a mentine setarile pentru ciclare noduri
    private HashMap<Integer, RowHeaderCellData> nodeCache;
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *       Constructor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Constructorul principal
     * @param tabelModel 
     */
    public RowHeaderModel(TableModel tabelModel) {
        this.tabelModel = tabelModel;
        tabelModel.addTableModelListener(this);
        
        //Initializez cache-ul de noduri
        nodeCache = new HashMap<Integer, RowHeaderCellData>();
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *   Implementare AbstractListModel
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Obtin marimea de la tabel
     * @return 
     */
    @Override
    public int getSize() {
        return tabelModel.getRowCount();
    }

    /**
     * Obtin elementul din tabel
     * @param i
     * @return 
     */
    @Override
    public Object getElementAt(int i) {
        RowHeaderCellData value;
        
        //Incerc obtinerea din cache
        value = nodeCache.get(i);
        if (value != null) {
            return value;
        }
        
        //Preiau din model
        return getListCellData(tabelModel.getValueAt(i, 0));
    }

    /**
     * Metoda ce se suprascrie pentru a oferi componenta proprie spre desenare
     * @param tableObject
     * @return 
     */
    public abstract RowHeaderCellData getListCellData(Object tableObject);

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *   Implementare TableModelListener
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Propag modificarile din tabel in lista
     * @param tme 
     */
    public void tableChanged(TableModelEvent tme) {
        int type = tme.getType();
        switch (type) {
            case TableModelEvent.INSERT:
                nodeCache.clear();
                this.fireIntervalAdded(tme.getSource(), 
                        tme.getFirstRow(), tme.getLastRow());
                break;
            case TableModelEvent.DELETE:
                nodeCache.clear();
                this.fireIntervalRemoved(tme.getSource(), 
                        tme.getFirstRow(), tme.getLastRow());
                break;
            case TableModelEvent.UPDATE:
                nodeCache.clear();
                this.fireContentsChanged(tme.getSource(), 
                        tme.getFirstRow(), tme.getLastRow());
                break;
            default:
                break;                
        }
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *          Actiuni publice
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Cicleaza anotatiile de la un anumit rand
     * @param row 
     */
    public void cycleAnnotations(int row) {
        RowHeaderCellData cellData = (RowHeaderCellData) getElementAt(row);
        if (cellData.cycleAnnotations()) {
            //Memorez nodul
            nodeCache.put(row, cellData);
            
            //Lansez evenimentul
            this.fireContentsChanged(this, row, row);
        }
    }

}
