/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.miscellaneous.labellines;

import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Clasa reprezinta o linie cu un buton de link
 * @author iulian
 */
public class JLinkLine extends JPanel {

    //Structura panoului
    JLinkButton linkButton;
    JLabel descriptionLabel;
    
    /**
     * Contructor secundar
     * @param actionCommand
     * @param linkText
     * @param actionListener 
     */
    public JLinkLine(String actionCommand,
            String linkText, ActionListener actionListener) {
        this(actionCommand, linkText, null, actionListener);
    }
    
    /**
     * Construiesc o linie formata dintr-un buton 
     * @param actionCommand
     * @param linkText
     * @param linkDescription
     * @param actionListener 
     */
    public JLinkLine(String actionCommand,
            String linkText, String linkDescription,
            ActionListener actionListener) {
        super();
        this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));

        //Creez butonul de link
        linkButton = new JLinkButton();
            linkButton.setText(linkText);
            linkButton.setActionCommand(actionCommand);
            linkButton.addActionListener(actionListener);
        this.add(linkButton);
        
        //Creez labelul de descriere
        if (linkDescription != null) {
            descriptionLabel = new JLabel("  - "+linkDescription);
            this.add(descriptionLabel);
        }
        
        //Padding
        this.add(Box.createHorizontalGlue());
    }
    
}
