/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.toolbar;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;

/**
 * Un buton ce simuleaza un buton nativ de toolbar
 * @author iulian
 */
public class JSimulatedToolbarButton extends JButton {

    /**
     * Constructor cu string
     * @param text
     */
    public JSimulatedToolbarButton(String text) {
        super(text);
        initButton();
    }

    /**
     * Constructor default
     */
    public JSimulatedToolbarButton() {
        initButton();
    }

    /**
     * Initializarea butonului
     */
    private void initButton() {
        //Il fac transparent
        this.setContentAreaFilled(false);

        //Nu are nevoie de focus
        setFocusable(false);
        setFocusPainted(false);
        setRequestFocusEnabled(false);

        //Pun un border manual
        setBorder(BorderFactory.createEtchedBorder());
        setBorderPainted(false);

        //Facem efectul de mouse-over manual
        addMouseListener(buttonMouseListener);
        setRolloverEnabled(true);
    }

    /**
     * Clasa ce implementeaza efectul de mouse-over asociat butonului
     */
    private final static MouseListener buttonMouseListener = new MouseAdapter() {
        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton) component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton) component;
                button.setBorderPainted(false);
            }
        }
    };

}
