/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.tree.search;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Clasa folosita pentru a cauta intr-un arbore
 * @author iulian
 */
public class TreeNodeSearcher {
    private DefaultMutableTreeNode startNode;
    private INodeSearchCriteria searchCriteria;
    
    
    /**
     * Construiesc o clasa pentru cautare in arbore
     * @param rootNode
     * @param nodeCriteria 
     */
    public TreeNodeSearcher(DefaultMutableTreeNode startNode,
            INodeSearchCriteria nodeCriteria) {
        this.startNode = startNode;
        this.searchCriteria = nodeCriteria;
    }
    
    /**
     * Obtin urmatorul nod ce corespunde creiteriului de cautare
     * @param searchString
     * @return null daca nu exista
     */
    public DefaultMutableTreeNode getNextNode() {
        Enumeration<DefaultMutableTreeNode> forwardEnumeration 
                = new ForwardNodeTraversal(startNode);
        while (forwardEnumeration.hasMoreElements()) {
            DefaultMutableTreeNode nodeItem = forwardEnumeration.nextElement();
            if (searchCriteria.validateNode(nodeItem))
                return nodeItem;
        }
        
        //Valaorea default
        return null;
    }
    
    /**
     * Obtin urmatorul nod ce corespunde criteriului de cautare
     * @param searchString
     * @return null daca nu exista
     */
    public DefaultMutableTreeNode getPreviousNode() {
        Enumeration<DefaultMutableTreeNode> backwardEnumeration 
                = new BackwardNodeTraversal(startNode);
        while (backwardEnumeration.hasMoreElements()) {
            DefaultMutableTreeNode nodeItem = backwardEnumeration.nextElement();
            if (searchCriteria.validateNode(nodeItem))
                return nodeItem;
        }
        
        //Valaorea default
        return null;
    }
}
