/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.test;

import exenne.components.textfield.utils.SincronizationDocumentListener;
import exenne.components.textfield.validator.IValidateString;
import exenne.components.textfield.validator.JValidatorTextfield;
import exenne.components.treetable.SelfManagedComponent;
import exenne.components.treetable.Treetable;
import exenne.components.utils.NumberUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 *
 * @author iulian
 */
public class DoubleValueCellEditor extends AbstractCellEditor
        implements TableCellEditor {
    private MaterialFrahtPanel editingComp;
    protected int clickCountToStart = 1;

    /**
     * Construiesc editorul custom
     */
    public DoubleValueCellEditor() {
        editingComp = new MaterialFrahtPanel();
        editingComp.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    /**
     * Metoda apelata de tabel care intreaba componenta daca se poate opri editarea
     * @return
     */
    @Override
    public boolean stopCellEditing() {
        if (editingComp.isValidValue()) {
            return super.stopCellEditing();
        } else {
            return false;
        }
    }

    /**
     * Obtin valoarea editata
     * @return
     */
    public Object getCellEditorValue(){
        return editingComp.getValue();
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Etapa de pornire editare
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin numarul de clickuri pentru a afisa panoul
     * @return
     */
    public int getClickCountToStart(){
        return clickCountToStart;
    }

    /**
     * Setez numarul de clickuri
     * @param clickCountToStart
     */
    public void setClickCountToStart(int clickCountToStart){
        this.clickCountToStart = clickCountToStart;
    }

    /**
     * Preiau evenimentul de mouse si detectez daca este cazul sa pornesc editarea
     * @param e
     * @return
     */
    @Override
    public boolean isCellEditable(EventObject e){
        return !(e instanceof MouseEvent)
                || ((MouseEvent)e).getClickCount()>=clickCountToStart;
    }

    /*---------------------------[ TableCellEditor ]------------------------*/

    /**
     * Metoda apelata de tabel pentru a obtine editorul
     * @param table
     * @param value
     * @param isSelected
     * @param row
     * @param column
     * @return
     */
    public Component getTableCellEditorComponent(JTable table, Object value
            , boolean isSelected, int row, int column){
        Treetable treetable = (Treetable) table;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) treetable.getValueAt(row, 0);

        editingComp.setValue((BigDecimal)value,BigDecimal.TEN);
        editingComp.prepareForDisplay();
        return editingComp;
    }

    /**
     * Editor in caz ca are frraht
     */
    private static class MaterialFrahtPanel extends JPanel
            implements SelfManagedComponent, IValidateString {
        public static final String UPDATE_BOUNDS = "UpdateBounds";

        private BigDecimal value = BigDecimal.ZERO;
        private BigDecimal fraht = BigDecimal.ZERO;
        private final Color bgColor = new Color(235, 235, 255);

        JPanel panel1;
            private JExposedValidatorTextfield fieldPu;  private JLabel textPu;
        JPanel panel2;
            private JValidatorTextfield fieldMat;  private JLabel textMat;
        JPanel panel3;
            private JLabel valFraht;  private JLabel textFraht;

        //Document listener 2
        DocumentListener documentListener1;
        DocumentListener documentListener2;
        
        public MaterialFrahtPanel() {
            setLayout(new GridLayout(3, 1, 0, 0));
            this.setBackground(bgColor);
            setFocusable(true);

            //Configure documents
            documentListener1 = new SincronizationDocumentListener() {
                    public void sinc(String value) {
                        BigDecimal big = BigDecimal.ZERO;
                        try {
                            big = new BigDecimal(value);
                            big = big.add(fraht.negate());
                        } catch (Exception e) {
                        }
                        fieldMat.getDocument().removeDocumentListener(documentListener2);
                        fieldMat.setText(big.stripTrailingZeros().toPlainString());
                        fieldMat.setCaretPosition(0);
                        fieldMat.getDocument().addDocumentListener(documentListener2);
                    }
                };
            documentListener2 = new SincronizationDocumentListener() {
                    public void sinc(String value) {
                        BigDecimal big = BigDecimal.ZERO;
                        try {
                            big = new BigDecimal(value);
                            big = big.add(fraht);
                        } catch (Exception e) {
                        }
                        fieldPu.getDocument().removeDocumentListener(documentListener1);
                        fieldPu.setText(big.stripTrailingZeros().toPlainString());
                        fieldPu.setCaretPosition(0);
                        fieldPu.getDocument().addDocumentListener(documentListener1);
                    }
                };

            //Primul rand
            panel1 = new JPanel();
            panel1.setBackground(bgColor);
            panel1.setLayout(new BoxLayout(panel1, BoxLayout.X_AXIS));
                fieldPu = new JExposedValidatorTextfield();
                fieldPu.setHorizontalAlignment(JTextField.RIGHT);
                fieldPu.getDocument().addDocumentListener(documentListener1);
                fieldPu.setValidator(this);
                textPu = new JLabel("(A) =");
                textPu.setBackground(bgColor);
            panel1.add(fieldPu);
            panel1.add(Box.createHorizontalGlue());
            panel1.add(textPu);

            //Al doilea
            panel2 = new JPanel();
            panel2.setBackground(bgColor);
            panel2.setLayout(new BoxLayout(panel2, BoxLayout.X_AXIS));
                fieldMat = new JValidatorTextfield();
                fieldMat.setHorizontalAlignment(JTextField.RIGHT);
                fieldMat.getDocument().addDocumentListener(documentListener2);
                fieldMat.setValidator(this);
                textMat = new JLabel("(B) +");
                textMat.setBackground(bgColor);
            panel2.add(fieldMat);
            panel2.add(Box.createHorizontalGlue());
            panel2.add(textMat);

            //Al treilea
            panel3 = new JPanel();
            panel3.setBackground(bgColor);
            panel3.setLayout(new BoxLayout(panel3, BoxLayout.X_AXIS));
                valFraht = new JLabel("C");
                valFraht.setBackground(bgColor);
                valFraht.setHorizontalAlignment(SwingConstants.RIGHT);
                textFraht = new JLabel("(C).");
                textFraht.setBackground(bgColor);
            panel3.add(valFraht);
            panel3.add(Box.createHorizontalGlue());
            panel3.add(textFraht);

            //add(textField);
            add(panel1);
            add(panel2);
            add(panel3);
            this.setOpaque(true);
        }


        public BigDecimal getValue() {
            return new BigDecimal(fieldPu.getText());
        }

        public void setValue(BigDecimal value,BigDecimal fraht) {
            this.fraht = fraht;
            this.value = value;

            valFraht.setText(fraht.stripTrailingZeros().toPlainString());
            fieldPu.setText(value.stripTrailingZeros().toPlainString());
            fieldPu.setCaretPosition(0);
        }

        @Override
        public void setBounds(int x, int y, int width, int height){
            if(Boolean.TRUE.equals(getClientProperty(UPDATE_BOUNDS)))
                super.setBounds(x, y, width, height);
        }

        /**
         * Called by the table when opening cell editor
         * @param cellRect
         */
        public void updateBounds(Rectangle cellRect) {
            panel1.setPreferredSize(new Dimension(2*cellRect.width, cellRect.height));
                fieldPu.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
                textPu.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
            panel2.setPreferredSize(new Dimension(2*cellRect.width, cellRect.height));
                fieldMat.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
                textMat.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
            panel3.setPreferredSize(new Dimension(2*cellRect.width, cellRect.height));
                valFraht.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
                textFraht.setPreferredSize(new Dimension(cellRect.width, cellRect.height));
            this.setPreferredSize(new Dimension(2*cellRect.width, 3*cellRect.height+8));

            putClientProperty(UPDATE_BOUNDS, Boolean.TRUE);
            setBounds(cellRect.x-2, cellRect.y-2
                    , 2*cellRect.width+4
                    , 3*cellRect.height+8);
            putClientProperty(UPDATE_BOUNDS, Boolean.FALSE);
            validate();
        }

        /**
         * Intorc daca valorile introduse sunt valide
         * @return
         */
        public boolean isValidValue() {
            return fieldPu.isValidValue() && fieldMat.isValidValue();
        }

         /**
         * Metoda chemata pentru a valida stringul introdus
         * @param text
         * @return
         */
        public boolean validate(String text) {
            return NumberUtils.isValidNumber(text);
        }

        /**
         * Metoda apelata inainte de folosirea componentei
         */
        public void prepareForDisplay() {
            fieldPu.setCaretPosition(0);
            fieldPu.selectAll();
            fieldPu.requestFocusInWindow();
        }

        /*---------------------------[ Forwardare key event ]------------------------*/
        
        /**
         * Forwardez evenimentele catre 
         * @param ks
         * @param e
         * @param condition
         * @param pressed
         * @return 
         */
        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            return fieldPu.processKeyBinding(ks, e, condition, pressed);
        }
        
        /**
         * Clasa care expune o metoda protected din JValidatorTextfield. 
         * Aceasta metoda aste folosita pentru a forwarda evenimentele de mouse
         */
        private static class JExposedValidatorTextfield extends JValidatorTextfield {

            /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
             *      Constructorii
             *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
            
            /**
             * Forwardez apelul de constructor
             * @param validator
             * @param originalBorder 
             */
            public JExposedValidatorTextfield(IValidateString validator, Border originalBorder) {
                super(validator, originalBorder);
            }

            /**
             * Forwardez apelul de constructor
             * @param validator
             * @param originalBorder 
             */
            public JExposedValidatorTextfield(Border originalBorder) {
                super(originalBorder);
            }

            /**
             * Forwardez apelul de constructor
             * @param validator
             * @param originalBorder 
             */
            public JExposedValidatorTextfield() {
            }
            
            /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
             *      Expunerea metodelor
             *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
            
            /**
             * Metoda protected din JValidatorTextfield
             * @param ks
             * @param e
             * @param condition
             * @param pressed
             * @return 
             */
            @Override
            public boolean processKeyBinding(KeyStroke ks, KeyEvent e, 
                int condition, boolean pressed) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        }
    }
}
