/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.undosystem.tutorial;

import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
// Sample undoable toggle button class. Supports only a single listener to
// simplify the code.
public class UndoableJToggleButton extends JToggleButton {
  // For this example, we'll just provide one constructor . . .
  public UndoableJToggleButton(String txt) {
    super(txt);
  }
  // Set the UndoableEditListener
  public void addUndoableEditListener(UndoableEditListener l) {
    listener = l; // should ideally throw an exception if listener != null
  }
  // Remove the UndoableEditListener
  public void removeUndoableEditListener(UndoableEditListener l) {
    listener = null;
  }
  // We override this method to call the super implementation first (to fire the
  // action event) and then fire a new UndoableEditEvent to our listener.
    @Override
  protected void fireActionPerformed(ActionEvent ev) {
    // Fire the ActionEvent as usual
    super.fireActionPerformed(ev);
    if (listener != null) {
      listener.undoableEditHappened(new UndoableEditEvent(this,
        new UndoableToggleEdit(this)));
    }
  }
  private UndoableEditListener listener;
}
