/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.utils;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;

/**
 * Clasa reprezinta un ascultator de MouseEvent al carei scop este 
 * sa forwardeze evenimentele catre o anumita componenta destinatie
 * @author Iulian
 */
public class MouseEventForwarder implements MouseListener, MouseWheelListener, MouseMotionListener {
    private Component destinationComponent;
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Constructor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Construiesc un forwarder
     * @param destinationComponent 
     */
    public MouseEventForwarder(Component destinationComponent) {
        this.destinationComponent = destinationComponent;
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Interfetele standard
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Event
     */
    public void mouseClicked(MouseEvent e) {
        forwardEvent(e);
    }

    /**
     * Event
     */
    public void mousePressed(MouseEvent e) {
        forwardEvent(e);
    }

    /**
     * Event
     */
    public void mouseReleased(MouseEvent e) {
        forwardEvent(e);
    }

    /**
     * Event
     */
    public void mouseEntered(MouseEvent e) {
        forwardEvent(e);
    }

    /**
     * Event
     */
    public void mouseExited(MouseEvent e) {
        forwardEvent(e);
    }

    /**
     * Event
     */
    public void mouseWheelMoved(MouseWheelEvent e) {
        forwardEvent(e);
    }

    /**
     * Event
     */
    public void mouseDragged(MouseEvent e) {
        forwardEvent(e);
    }

    /**
     * Event
     */
    public void mouseMoved(MouseEvent e) {
        forwardEvent(e);
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *   Metoda de prelucrare
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Forwardeaza evenimentul
     * @param e 
     */
    private void forwardEvent(MouseEvent e) {
        Point translatedPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), destinationComponent);
        MouseEvent translatedMouseEvent = new MouseEvent(
                destinationComponent, e.getID(), e.getWhen(), e.getModifiers(), 
                translatedPoint.x, translatedPoint.y, e.getXOnScreen(),e.getYOnScreen(), 
                e.getClickCount(), e.isPopupTrigger(), e.getButton());
        destinationComponent.dispatchEvent(translatedMouseEvent);
    }
    
    /**
     * Forwardeaza evenimentul
     * @param e 
     */
    private void forwardEvent(MouseWheelEvent e) {
        Point translatedPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), destinationComponent);
        MouseWheelEvent translatedMouseEvent = new MouseWheelEvent(
                destinationComponent, e.getID(), e.getWhen(), e.getModifiers(), 
                translatedPoint.x, translatedPoint.y, e.getXOnScreen(),e.getYOnScreen(), 
                e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), 
                e.getScrollAmount(), e.getWheelRotation());
        destinationComponent.dispatchEvent(translatedMouseEvent);
    }
    
}
