
package exenne.components.jdatepicker.impl;

import exenne.components.jdatepicker.AbstractDateModel;
import java.util.Calendar;
import java.util.Date;


public class UtilDateModel extends AbstractDateModel<java.util.Date> {

	public UtilDateModel() {
		this(null);
	}
	
	public UtilDateModel(Date value) {
		super();
		setValue(value);
	}

	@Override
	protected Date fromCalendar(Calendar from) {
		return new Date(from.getTimeInMillis());
	}

	@Override
	protected Calendar toCalendar(Date from) {
		Calendar to = Calendar.getInstance();
		to.setTime(from);
		return to;
	}

}
