/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.jtable.rowheader;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JTable;

/**
 * O lista ce va servi drept Row Header pentru un tabel
 * @author iulian
 */
public class JTableRowHeader extends JList {
    private static final int RIGHT_PADDING = 2;
    private static final int LEFT_PADDING = 2;
    private static final int NR_OF_CHARS = 4;
    
    //Varibile de clase
    private JTable jtable;
    
    
    /**
     * Constructor auxiliar
     * @param jtable
     * @param listModel 
     */
    public JTableRowHeader(JTable jtable, 
            RowHeaderModel listModel) {
        this(jtable,listModel,NR_OF_CHARS);
    }
    
    /**
     * Construiesc lista
     * @param jtable
     * @param listModel 
     */
    public JTableRowHeader(JTable jtable, 
            RowHeaderModel listModel, int cols) {
        super();
        
        //Pastrez variabilele
        this.jtable = jtable;
        
        //Anulez selectia
        this.setSelectionModel(new PhonyListSelectionModel());
        
        //Setez inaltimea celulei
        this.setFixedCellHeight(jtable.getRowHeight());
        jtable.addComponentListener(new ComponentListener() {
            /**
             * Hack pentru a prinde evenimentul care schimba inaltimea celulei
             */
            @Override
            public void componentResized(ComponentEvent e) {
                checkForHeightChange();
            }

            public void componentMoved(ComponentEvent e) {
                checkForHeightChange();
            }

            public void componentShown(ComponentEvent e) {
                checkForHeightChange();
            }

            public void componentHidden(ComponentEvent e) {
                //Do nothing
            }
        });

        //Setez lungimea celulei
        int charSize = this.getFontMetrics(getFont()).charWidth('0');
        this.setFixedCellWidth(charSize*cols);
        
        //Setez modelul primit
        this.setModel(listModel);
        
        //Setez cell renderul default
        this.setCellRenderer(new JRowHeaderCellRenderer());
        
        //Pun un border pentru padding
        this.setBorder(BorderFactory.createEmptyBorder(0, LEFT_PADDING, 0, RIGHT_PADDING));
    }
    
    /**
     * Metoda ce verifica schimbarea dimensiunii
     */
    private void checkForHeightChange() {
        int rowHeight = jtable.getRowHeight();
        if (rowHeight != JTableRowHeader.this.getFixedCellHeight())
            JTableRowHeader.this.setFixedCellHeight(rowHeight);
    }

    /**
     * Suprascriu paint pentru a verifica tot timpul daca 
     * s-a schimbat dimensiunea randului la tablelul corespondend
     * @param g 
     */
    @Override
    public void paint(Graphics g) {
        checkForHeightChange();
        super.paint(g);
    }
}
