package exenne.components.tabbedpane;

import exenne.components.headerrenderer.JHeaderSorterIcons;
import exenne.components.treetable.test.TreetableTestClass;
import java.awt.BorderLayout;
import java.util.Locale;
import javax.swing.*;

public class TabbedPaneTestClass extends JPanel {

    public TabbedPaneTestClass(boolean isFirst) {
        super();
        this.setLayout(new BorderLayout());
        
        //Test icons
        JHeaderSorterIcons iconProvider = new JHeaderSorterIcons();
        iconProvider.loadIcons();

        //Create and set up the content pane.
        TreetableTestClass treetableTestClass;
        TabSpecifications specifications;
        JDragableTabbedPane dragableTabbedPane = new JDragableTabbedPane();
            specifications = new TabSpecifications();
            specifications.title = "Instalatii";
            specifications.shouldBeBold = true;
            specifications.icon = iconProvider.getIcon(JHeaderSorterIcons.ASC);
        if (isFirst) {
            TabbedPaneTestClass tabbedPaneTestClass = new TabbedPaneTestClass(false);
            dragableTabbedPane.add(specifications, tabbedPaneTestClass);
        } else {
            treetableTestClass = new TreetableTestClass();
            dragableTabbedPane.add(specifications, treetableTestClass);
        }
            specifications = new TabSpecifications();
            specifications.title = "Sapatura";
            specifications.shouldBeBold = false;
            specifications.icon = iconProvider.getIcon(JHeaderSorterIcons.DESC);
        treetableTestClass = new TreetableTestClass();
        dragableTabbedPane.add(specifications, treetableTestClass);
            specifications = new TabSpecifications();
            specifications.title = "Deviz";
            specifications.shouldBeBold = false;
            specifications.icon = iconProvider.getIcon(JHeaderSorterIcons.DESC);
        treetableTestClass = new TreetableTestClass();
        dragableTabbedPane.add(specifications, treetableTestClass);
            specifications = new TabSpecifications();
            specifications.title = "Obiect";
            specifications.shouldBeBold = false;
            specifications.icon = iconProvider.getIcon(JHeaderSorterIcons.DESC);
        treetableTestClass = new TreetableTestClass();
        dragableTabbedPane.add(specifications, treetableTestClass);
            specifications = new TabSpecifications();
            specifications.title = "Investitie";
            specifications.shouldBeBold = false;
            specifications.icon = iconProvider.getIcon(JHeaderSorterIcons.DESC);
        treetableTestClass = new TreetableTestClass();
        dragableTabbedPane.add(specifications, treetableTestClass);
            specifications = new TabSpecifications();
            specifications.title = "Echipamente";
            specifications.shouldBeBold = false;
            specifications.icon = iconProvider.getIcon(JHeaderSorterIcons.DESC);
        treetableTestClass = new TreetableTestClass();
        dragableTabbedPane.add(specifications, treetableTestClass);
        
        
        this.add(dragableTabbedPane,BorderLayout.CENTER);
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Metode statice pentru rularea clasei
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Init look and feel
        initLookAndFeel();

        //Create and set up the window.
        JFrame frame = new JFrame("TabbedPaneTestClass");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //testez clasa
        TabbedPaneTestClass testClass = new TabbedPaneTestClass(true);
        frame.add(testClass);

        //Display the window.
        frame.setSize(700, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

     /**
     *  <p style="margin-top: 0">
     *         Initializeaza Look and Feel. Default este cel al sistemului.
     *      </p>
     * @param titlu Titlul ferestrei
     * @author iulian
     */
    public static void initLookAndFeel() {
        String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * Metoda main
     * @param args
     */
    public static void main(String[] args) {
        //Initializez limba
        Locale.setDefault(new Locale("ro", "RO"));

        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
}
