/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.dnd;

import exenne.components.transfer.PackObjects;
import exenne.components.treetable.Treetable;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 *
 * @author iulian
 */
public interface TransferDataProvider {

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Constructia Data Providerului
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Reprezinta treetable-ul pe care se fac toate operatiuniile
     * @return Treetable-ul ce sta la baza Datelor
     */
    public Treetable getTreetable();

    /**
     * Obtine actiuniile care se pot face
     * pentru acest treetable
     *  Valorile posibile sunt:
     *       TransferHandler.NONE
     *       TransferHandler.COPY
     *       TransferHandler.MOVE
     *       TransferHandler.COPY_OR_MOVE
     * @return Constanta pentru actiune
     */
    public int getSourceActions();

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Creeare pachet
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin dataFlavor-ul care identifica acest pachet
     * @return
     */
    public String getFlavourName();    

    /**
     * Creeaza un pachet cu obiectele care se doresc a fi transferate
     * @return Un obiect de tip PackObject
     */
    public PackObjects createPack();

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Etapa de EXPORT
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Controleaza actiunea metodei de export Pack
     * @return true daca nu se va folosi metoda export
     */
    public boolean isInhibitExport();

    /**
     * Creeaza un pachet cu obiectele care se doresc a fi transferate
     * @return Un obiect de tip PackObject
     */
    public void exportDone(PackObjects packObjects);

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Etapa de CAN IMPORT
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Specifica daca pachetul este de uz global sau local
     * @return
     */
    public boolean isGlobalPack();    
    
    /**
     * Verifica daca un pachet poate fi introdus la locatia specifiata
     * Conditia de adaugare a unui obiect la sine nu trebuie luata in calcul
     * @param packObjects   Pachetul de importat
     * @param parentNode    Nodul Parinte
     * @return true daca se poate, false in caz contrar
     */
    public boolean canImport(PackObjects packObjects,
            DefaultMutableTreeNode parentNode);

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Etapa de IMPORT
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Metoda ce ofera informatii despre cum trebuie tratat
     * actiunea de drop on. Varianta default (false) esta ca la drop on
     * sa se adauge elementele ca si copii ai nodului peste care s-a facut drop
     * Cealalta posibilitate este ca la drop on sa se comporte ca si cum s-ar fi tras langa.
     * @return true se considera ca s-a tras langa, false se considera ca s-a tras peste
     */
    public boolean isTreatDropOnAsNear(PackObjects packObjects,
            DefaultMutableTreeNode targetNode);

    /**
     * Metoda ofera informatii despre cum ar trebui tratata operatiunea de Paste.
     * Comportamentul default (false) este ca elementele sa se adauge ca si vecini nodului
     * selectat. Celalata posibilitate este ca elementele sa se adauge ca si copii la nodul selectat
     * @param packObjects Packetul cu obiecte ce se adauga
     * @param targetNode Nodul in jurul caruia se adauga
     * @return true daca se vor adauga ca si copii, false faca se vor adauga ca si vecini
     */
    public boolean isTreatPasteAsDropOn(PackObjects packObjects,
            DefaultMutableTreeNode targetNode);

    /**
     * Fac actiunea de importare date in parintele specificat
     * In aceasta functie trebuie doar sa se importe datele, 
     * operatile de ajustare selectie si reincarcare model sunt facute in spate.
     * @param packObjects   Pachetul de importat
     * @param parentNode    Nodul Parinte
     * @param dropNode      Nodul corespunzator locatiei de drop (null daca e dropOn)
     * @param dropNodeImdex Indexul nodului in care se insereaza in parinte
     * @return true daca s-a reusit operatia
     */
    public boolean importData(PackObjects packObjects,
            DefaultMutableTreeNode parentNode, 
            DefaultMutableTreeNode dropNode, 
            int dropNodeIndex,
            boolean isMove);
}
