package exenne.components.tabbedpane;

import exenne.components.headerrenderer.JHeaderSorterIcons;
import javax.swing.*;

public class TabbedPaneTestClass {
    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Init look and feel
        initLookAndFeel();

        //Create and set up the window.
        JFrame frame = new JFrame("TableSelectionDemo");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //Test icons
        JHeaderSorterIcons iconProvider = new JHeaderSorterIcons();
        iconProvider.loadIcons();

        //Create and set up the content pane.
        JDragableTabbedPane dragableTabbedPane = new JDragableTabbedPane();
            TabSpecifications specifications1 = new TabSpecifications();
            specifications1.title = "Instalatii";
            specifications1.shouldBeBold = true;
            specifications1.icon = iconProvider.getIcon(JHeaderSorterIcons.ASC);
        dragableTabbedPane.add(specifications1, new JLabel("test"));
            TabSpecifications specifications2 = new TabSpecifications();
            specifications2.title = "Sapatura";
            specifications2.shouldBeBold = false;
            specifications2.icon = iconProvider.getIcon(JHeaderSorterIcons.DESC);
        dragableTabbedPane.add(specifications2, new JLabel("ole"));

        frame.add(dragableTabbedPane);

        //Display the window.
        frame.setSize(500, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

     /**
     *  <p style="margin-top: 0">
     *         Initializeaza Look and Feel. Default este cel al sistemului.
     *      </p>
     * @param titlu Titlul ferestrei
     * @author iulian
     */
    public static void initLookAndFeel() {
        String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
}
