/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.test;

import exenne.components.utils.RandomDataGenerator;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @author iulian
 */
public class ControllerNode implements Serializable {
    private int type;
    private String cod;
    private String name;
    private BigDecimal value;
    private Double anotherValue;

    //Constants for type
    public static final int TYPE_0 = 0;
    public static final int TYPE_1 = 1;
    public static final int TYPE_2 = 2;

    public ControllerNode() {
        this.type = RandomDataGenerator.getRandomInt(3);
        this.cod = "cod_"+RandomDataGenerator.getRandomString(2);
        this.name = "name_"+RandomDataGenerator.getRandomString(3)+"_test";
        this.value = RandomDataGenerator.getRandomBigDecimal();
        this.anotherValue = Double.valueOf(10000-RandomDataGenerator.getRandomInt(20000));
    }

    public int getType() {
        return type;
    }

    public String getCod() {
        return cod;
    }

    public String getName() {
        return name;
    }

    public BigDecimal getValue() {
        return value;
    }

    public Double getAnotherValue() {
        return anotherValue;
    }

    public ControllerNode cloneaza() {
        ControllerNode newNode = new ControllerNode();
        newNode.type = this.type;
        newNode.cod = this.cod;
        newNode.name = this.name;
        newNode.value = this.value;
        newNode.anotherValue = this.anotherValue;
        return newNode;
    }
}