/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.test;

import exenne.components.headerrenderer.MultilineHeaderRenderer;
import exenne.components.treetable.DefaultTreetableModel;
import exenne.components.treetable.RenderDataProvider;
import exenne.components.treetable.RowModel;
import exenne.components.treetable.Treetable;
import exenne.components.treetable.TreetableListSelectionHandler;
import exenne.components.treetable.TreetableModel;
import exenne.components.treetable.cellrenderers.DefaultTreetableCellRenderer;
import exenne.components.transfer.PackObjects;
import exenne.components.treetable.dnd.TransferDataProvider;
import exenne.components.treetable.dnd.TreetableTransferHandler;
import exenne.components.treetable.undosupport.InsertNodeToParentStandardUndoableEdit;
import exenne.components.treetable.undosupport.RemoveNodeFromParentStandardUndoableEdit;
import exenne.components.treetable.warningrowbar.JWarningRowBar;
import exenne.components.treetable.warningrowbar.RunnableSuggestion;
import exenne.components.treetable.warningrowbar.WarningBarCellData;
import exenne.components.treetable.warningrowbar.WarningRowBarModel;
import exenne.components.utils.RandomDataGenerator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/**
 *
 * @author iulian
 */
public class TreetableTestClass extends JPanel implements ActionListener {
    //Componente din treetable
    private Treetable treetable;
    private TreeModel treeMdl;
    private TableModel tableMdl;
    private TableColumnModel columns;
    private NodeRowModel rowModel;
    private TreetableModel mdl;

    //Selection listner
    TreetableListSelectionHandler selectionHandler;

    //Renderer pentru headere
    MultilineHeaderRenderer multirenderer;

    //Constante pentru butoane
    private static final String ACTION_ADD = "add_node";
    private static final String ACTION_DELETE = "del_node";

    //Butoanele din meniu
    JToolBar toolBar;
        JButton buttonAdd;
        JButton buttonDelete;

    public TreetableTestClass() {
        super();
        this.setLayout(new BorderLayout());

        // <editor-fold defaultstate="collapsed" desc="Set the treetable">
        rowModel = new NodeRowModel();
        mdl = DefaultTreetableModel.createOutlineModel(rowModel);
        treetable = new Treetable(new DefaultTreetableCellRenderer());
        treeMdl = mdl.getTreeModel();

        treetable.setRootVisible(false);
        //Numele primei coloane
        mdl.setNodeColumnName("Cod \n (String)");
        treetable.setModel(mdl);
        tableMdl = treetable.getModel();

        //Controlul selectiei
        selectionHandler = new TreetableListSelectionHandler(treetable);
        treetable.getSelectionModel().addListSelectionListener(selectionHandler);
        treetable.setRenderDataProvider(new RenderData());
        treetable.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);

        //Setez coloanele
        treetable.getTableHeader().setReorderingAllowed(false);
        columns = treetable.getColumnModel();
        treetable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        treetable.setFillsViewportHeight(true);

        //Setez modul de afisare a celulelor
        treetable.setShowHorizontalLines(true);
        treetable.setShowVerticalLines(true);

        //Setez renderul pentru headere multiline
        multirenderer = new MultilineHeaderRenderer();

        //Setez mecanismul de drag and drop
        treetable.setDragEnabled(true);
        treetable.setDropMode(DropMode.ON_OR_INSERT_ROWS);

        //Transfer Handle-ul pentru DnD si CP
        treetable.setTransferHandler(new TreetableTransferHandler(transferDataProvider));
        // </editor-fold>

        toolBar = createToolBar();
        this.add(toolBar,BorderLayout.NORTH);
        
        this.makeTree();
        this.setPrefferedWidth();
        
        //Adaug bara pentru rand
        WarningRowBarModel listTreetableModel = new RowWarningHeaderData(tableMdl);
        JList rowHeader = new JWarningRowBar(treetable, listTreetableModel);
        JScrollPane scrollPane = new JScrollPane(treetable);
        scrollPane.setRowHeaderView(rowHeader);
        
        
        this.add(scrollPane,BorderLayout.CENTER);
    }

     /**
     *  <p style="margin-top: 0">
     *  Creeaza toolbarul principal
     *  </p>
     * @return Obiectul ce reprezinta toolbarul
     * @author iulian
     */
    private JToolBar createToolBar() {
        JToolBar localToolBar = new JToolBar("Toolbar");

        buttonAdd = new JButton("Add node");
        buttonAdd.setActionCommand(ACTION_ADD);
        buttonAdd.setToolTipText("Add a node");
        buttonAdd.addActionListener(this);
        localToolBar.add(buttonAdd);

        buttonAdd = new JButton("Del node");
        buttonAdd.setActionCommand(ACTION_DELETE);
        buttonAdd.setToolTipText("Delete a node");
        buttonAdd.addActionListener(this);
        localToolBar.add(buttonAdd);

        localToolBar.setFocusable(false); //nu am nevoie de focus aici
        localToolBar.setFloatable(false); //Daca toolbarul pluteste sau nu
        localToolBar.setRollover(false);
        return localToolBar;
    }

    /**
     * Parsez devizul ca sa construiesc arborele
     */
    private void makeTree() {
       DefaultTreeModel model = (DefaultTreeModel) treeMdl;
       DefaultMutableTreeNode root = (DefaultMutableTreeNode) model.getRoot();
       DefaultMutableTreeNode nd;
       DefaultMutableTreeNode auxNd;
       ControllerNode element = new ControllerNode();

       //initializez root-ul
       root.setUserObject(element);

       //Obtin iteratorul
       int count = 30;//+RandomDataGenerator.getRandomInt(3);

       //Iterez prin elemente si le adaug la structura
       for (int i = 0; i < count; i++) {
           element = new ControllerNode();
           nd = new DefaultMutableTreeNode(element);

           //Adaug copii la copii
           int auxCount = RandomDataGenerator.getRandomInt(3);
           for (int j = 0; j < auxCount; j++) {
               element = new ControllerNode();
               auxNd = new DefaultMutableTreeNode(element);
               nd.add(auxNd);
           }

           //Add to root
           root.add(nd);
        }

        //Reincarc modelul
       model.reload(root);
       treetable.expandNode(root);
   }

    /**
     * Setez proportiile coloanelor
     */
    private void setPrefferedWidth() {
        //Incerc sa definesc latimea coloanelor
        TableColumn column; //coloana pe care lucrez
        //Cod
        column = columns.getColumn(0);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(100);
        //Descriere
        column = columns.getColumn(1);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(100);
        //Cantitate
        column = columns.getColumn(2);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(100);
        //Cantitate
        column = columns.getColumn(3);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(100);
    }

     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *   Definirea actiuniilor asupra treetable-ului
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Metoda ce insereaza la o pozitie un material la un nod fraht in Arbore
     * @param parinte nodul la care se adauga
     * @param ingredients ingredientul care se adauga
     * @param position pozitia la care se adauga
     */
    private DefaultMutableTreeNode insertEchipamentToNode_silent(DefaultMutableTreeNode parinte,
            ControllerNode controllerNode,int position){

        //Adaug frahtul in sine
        DefaultMutableTreeNode nd = new DefaultMutableTreeNode(
                    controllerNode, true);
        parinte.insert(nd, position);

        //Intorc nodul nou creeat
        return nd;
    }

    /**
     * Sterg un nod din parintele sau
     * Operatiunea este semiloud - nu se genereaza evenimente dar se genereaza operatii undo
     * Nu se notifica controllerul
     * @param n
     * @return
     */
    private UndoableEdit removeNodeFromParent_semiloud(DefaultMutableTreeNode n) {
        RemoveNodeFromParentStandardUndoableEdit removeAction =
                new RemoveNodeFromParentStandardUndoableEdit(treetable,n);
        removeAction.execute();
        return removeAction;
    }

    /**
     * Actiune pentru stergerea unui nod
     */
    private class InsertMultipleNodesUndoableEdit extends AbstractUndoableEdit {
        //Definesc operatia
        DefaultMutableTreeNode parentNode;
        Vector<ControllerNode> controllerNode;
        int position;

        //Pastrez informatii despre operatie
        UndoableEdit controllerAction;
        Vector<DefaultMutableTreeNode> newNodes;

        //Variabila de tranzitie
        UndoableEdit removeEdit;

        /**
         * Actiune pentru stergerea unui nod
         * @param node
         */
        public InsertMultipleNodesUndoableEdit(DefaultMutableTreeNode parentNode,
                Vector<ControllerNode> controllerNodes,int position) {
            //Configurez operatia
            this.parentNode = parentNode;
            this.controllerNode = controllerNodes;
            this.position = position;

            //Variabile de stare
            this.newNodes = new Vector<DefaultMutableTreeNode>();
            this.removeEdit = null;
        }

        /**
         * Executa actiunea in sine
         */
        public Vector <DefaultMutableTreeNode> execute() {
            //Verific daca se poate adauga
            DefaultTreeModel model = (DefaultTreeModel) treeMdl;

            //Fac adaugarea
            Iterator<ControllerNode> nodesIterator = controllerNode.iterator();
            while (nodesIterator.hasNext()) {
                ControllerNode nodeItem = nodesIterator.next();

                //Adaug in modelul trre-table-ului (fac desenarea)
                DefaultMutableTreeNode newNode =
                        TreetableTestClass.this.insertEchipamentToNode_silent(
                        parentNode, nodeItem, position);
                newNodes.add(newNode);
                model.nodesWereInserted(parentNode,
                        new int[]{position});

                //Incrementez positia
                position ++;
            }


            //Fac extinderea nodului parinte si selectia noilor noduri
            treetable.expandNode(parentNode);
            Iterator <DefaultMutableTreeNode> iterator = newNodes.iterator();
            while (iterator.hasNext()) {
                DefaultMutableTreeNode nodSelectie = iterator.next();
                treetable.selectAndScrollToNode(nodSelectie);
            }

            return newNodes;
        }

        /**
         * Actiunea de anulare a stergerii
         * @throws CannotUndoException
         */
        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }

        /**
         * Actiunea de refacere a
         * @throws CannotRedoException
         */
        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }
    }

    /**
     * Actiune pentru stergerea unui nod
     */
    private class ImportaMultipleNodesUndoableEdit extends AbstractUndoableEdit {
        //Definesc operatia
        DefaultMutableTreeNode parentNode;
        Vector<ControllerNode> controllerNode;
        int position;

        //Pastrez informatii despre operatie
        UndoableEdit controllerAction;
        Vector<DefaultMutableTreeNode> newNodes;

        //Variabila de tranzitie
        UndoableEdit removeEdit;

        /**
         * Actiune pentru stergerea unui nod
         * @param node
         */
        public ImportaMultipleNodesUndoableEdit(DefaultMutableTreeNode parentNode,
                Vector<ControllerNode> controllerNodes,int position) {
            //Configurez operatia
            this.parentNode = parentNode;
            this.controllerNode = controllerNodes;
            this.position = position;

            //Variabile de stare
            this.newNodes = new Vector<DefaultMutableTreeNode>();
            this.removeEdit = null;
        }

        /**
         * Executa actiunea in sine
         */
        public Vector <DefaultMutableTreeNode> execute() {
            //Verific daca se poate adauga
            DefaultTreeModel model = (DefaultTreeModel) treeMdl;

            //Fac adaugarea
            Iterator<ControllerNode> nodesIterator = controllerNode.iterator();
            while (nodesIterator.hasNext()) {
                ControllerNode nodeItem = nodesIterator.next();
                ControllerNode controllerNodNou = nodeItem.cloneaza();

                //Adaug in modelul trre-table-ului (fac desenarea)
                DefaultMutableTreeNode newNode =
                        TreetableTestClass.this.insertEchipamentToNode_silent(
                        parentNode, controllerNodNou, position);
                newNodes.add(newNode);
                model.nodesWereInserted(parentNode,
                        new int[]{position});

                //Incrementez positia
                position ++;
            }


            //Fac extinderea nodului parinte si selectia noilor noduri
            treetable.expandNode(parentNode);
            Iterator <DefaultMutableTreeNode> iterator = newNodes.iterator();
            while (iterator.hasNext()) {
                DefaultMutableTreeNode nodSelectie = iterator.next();
                treetable.selectAndScrollToNode(nodSelectie);
            }

            return newNodes;
        }

        /**
         * Actiunea de anulare a stergerii
         * @throws CannotUndoException
         */
        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }

        /**
         * Actiunea de refacere a
         * @throws CannotRedoException
         */
        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }
    }

    /**
     * Actiunea de stergere a unui set de noduri
     */
    private class RemoveMultipleNodesUndoableEdit extends AbstractUndoableEdit {
        //Definesc operatia
        Vector<DefaultMutableTreeNode> deletedNodes;

        //Pastrez informatii despre operatie
        Vector<UndoableEdit> controllerActions;
        Vector<UndoableEdit> guiActions;
        Hashtable<UndoableEdit,UndoableEdit> obiectNotifications; //notificari
        UndoableEdit frahtAction;

        //Variabila pentru insignificant
        private boolean isSignificant;


        /**
         * Actiune pentru stergerea unui nod
         * @param node
         */
        public RemoveMultipleNodesUndoableEdit(Vector<DefaultMutableTreeNode> deletedNodes) {
            //Configurez operatia
            this.deletedNodes = deletedNodes;

            //Initializez vectorii de actiuni undo
            controllerActions = new Vector<UndoableEdit>();
            guiActions = new Vector<UndoableEdit>();
            obiectNotifications = new Hashtable<UndoableEdit, UndoableEdit>();

            //Variabila pentru significant
            isSignificant = true;
        }

        /**
         * Executa actiunea in sine
         */
        public void execute() {
            DefaultTreeModel model = (DefaultTreeModel) treeMdl;

            Iterator <DefaultMutableTreeNode> iterator = deletedNodes.iterator();
            while (iterator.hasNext()) {
                DefaultMutableTreeNode deleteNode = iterator.next();
                //Actiunea in controller s-a realizat ok, realizez si in gui
                UndoableEdit guiremove = removeNodeFromParent_semiloud(deleteNode);
            }
        }

        /**
         * Actiunea de anulare a stergerii
         * @throws CannotUndoException
         */
        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }

        /**
         * Actiunea de refacere a
         * @throws CannotRedoException
         */
        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Setari pentru semnificatia editului
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        /**
         * Seteaza valoarea pentru isSignificant
         * @param value
         */
        public void setIsSignificant(boolean value) {
            isSignificant = value;
        }

        /**
         * This edit has the option to be insignificant
         * @return
         */
        @Override
        public boolean isSignificant() {
            return isSignificant;
        }
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Actiuniile pe treetable
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    /**
     * Managementul actiuniilor
     * @param e
     */
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (ACTION_ADD.equals(cmd)) {
            fireActionAdd();
        } else
        if (ACTION_DELETE.equals(cmd)) {
            fireActionDelete();
        }
    }

    /**
     * Actiune de adaugare
     */
    public void fireActionAdd() {
       DefaultTreeModel model = (DefaultTreeModel) treeMdl;
       DefaultMutableTreeNode root = (DefaultMutableTreeNode) model.getRoot();
       DefaultMutableTreeNode parent = treetable.getSelectedNode();
       if (parent == null)
           parent = root;


       ControllerNode controllerNode = new ControllerNode();
       DefaultMutableTreeNode nd = new DefaultMutableTreeNode(controllerNode);
       InsertNodeToParentStandardUndoableEdit insertEdit =
               new InsertNodeToParentStandardUndoableEdit(treetable,
               nd, parent, parent.getChildCount());
       insertEdit.execute();

       this.repaint();
    }

    /**
     * Actiune de stergere
     */
    public void fireActionDelete() {
       DefaultTreeModel model = (DefaultTreeModel) treeMdl;
       DefaultMutableTreeNode root = (DefaultMutableTreeNode) model.getRoot();
       Vector<DefaultMutableTreeNode> nodesToDelete = new Vector<DefaultMutableTreeNode>();

       int[] selectedIndices = treetable.getSelectedIndices();
       if (selectedIndices.length <= 0)
           return;

       //Compun vectorul de stergere
        for (int i = selectedIndices.length-1; i >= 0; i--) {
            int j = selectedIndices[i];
           DefaultMutableTreeNode selectedNode = treetable.getNodeAt(j);
           if (selectedNode != null)
               nodesToDelete.add(selectedNode);
        }

        //Sterg nodurile multiple
        RemoveMultipleNodesUndoableEdit multipleNodeDelete =
                new RemoveMultipleNodesUndoableEdit(nodesToDelete);
        multipleNodeDelete.execute();


       this.repaint();
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Mecanismul de drag and drop
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Data providerul pentru handle-ul de transferuri DnD
     */
    TransferDataProvider transferDataProvider = new TransferDataProvider() {

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Constructia Data Providerului
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        /**
         * Obtin treetable-ul
         */
        public Treetable getTreetable() {
            return treetable;
        }

        /**
         * Obtin actiuniile disponibile
         */
        public int getSourceActions() {
            return TransferHandler.COPY_OR_MOVE;
        }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Creeare pachet
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        /**
         * Obtin numele flavorului folosit
         */
        public String getFlavourName() {
            return PackNode.FLAVOR_NAME;
        }

        /**
         * Creeaza un pachet cu obiectele care se doresc a fi transferate
         * @return Un obiect de tip PackObject
         */
        public PackObjects createPack() {
            PackNode pack = new PackNode();

            //Obtin nodul selectat
            DefaultMutableTreeNode n = treetable.getSelectedNode();
            if (n == null) return null;

            //Obtin elementele selectate
            DefaultMutableTreeNode nd;
            ControllerNode controllerNode;
            Object userobj;
            Class tip;
            int[] sels = treetable.getSelectedIndices();

            for (int i = 0; i < sels.length ; i++) {
                nd = (DefaultMutableTreeNode) treetable.getValueAt(sels[i], 0);

                userobj = nd.getUserObject();
                tip = userobj.getClass();

                if (tip == ControllerNode.class) {
                    controllerNode = (ControllerNode) userobj;
                    //Il adaug in pachet
                    pack.add(controllerNode);
                    pack.setNode(controllerNode, nd);
                    pack.setNodeHash(controllerNode, new Integer(nd.hashCode()));
                }
             }

            return pack;
        }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Etapa de EXPORT
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        /**
         * Controleaza actiunea metodei de export Pack
         * @return true daca nu se va folosi metoda export
         */
        public boolean isInhibitExport() {
            return false;
        }

        /**
         * Creeaza un pachet cu obiectele care se doresc a fi transferate
         * @return Un obiect de tip PackObject
         */
        public void exportDone(PackObjects packObjects) {
            DefaultTreeModel model = (DefaultTreeModel) treeMdl;
            ControllerNode item = null;
            DefaultMutableTreeNode node = null;
            Vector<DefaultMutableTreeNode> nodesToDelete = new Vector<DefaultMutableTreeNode>();

            Iterator<ControllerNode> it = packObjects.iterator();
            while (it.hasNext()) {
                item = it.next();
                 node = (DefaultMutableTreeNode) packObjects.getNode(item);
                 nodesToDelete.add(node);
            }


            //Sterg nodurile multiple
            RemoveMultipleNodesUndoableEdit multipleNodeDelete =
                    new RemoveMultipleNodesUndoableEdit(nodesToDelete);
            multipleNodeDelete.execute();
            multipleNodeDelete.setIsSignificant(false);

            treetable.repaint();
        }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Etapa de CAN IMPORT
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        /**
         * Specifica daca pachetul este de uz global sau local
         * @return
         */
        public boolean isGlobalPack() {
            return true;
        }

        /**
         * Verifica daca un pachet poate fi introdus la locatia specifiata
         * Conditia de adaugare a unui obiect la sine nu trebuie luata in calcul
         * @param packObjects   Pachetul de importat
         * @param parentNode    Nodul Parinte
         * @return true daca se poate, false in caz contrar
         */
        public boolean canImport(PackObjects packObjects, DefaultMutableTreeNode parentNode) {
            //Verific nodul parinte
            Object parentObj = parentNode.getUserObject();
            if (parentObj.getClass() != ControllerNode.class)
                return false;

            return true;
        }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Etapa de IMPORT
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        /**
         * Fac actiunea de importare date in parintele specificat
         * In aceasta functie trebuie doar sa se importe datele,
         * operatile de ajustare selectie si reincarcare model sunt facute in spate.
         * @param packObjects   Pachetul de importat
         * @param parentNode    Nodul Parinte
         * @param dropNode      Nodul corespunzator locatiei de drop (null daca e dropOn)
         * @param dropNodeImdex Indexul nodului in care se insereaza in parinte
         * @return true daca s-a reusit operatia
         */
        public boolean importData(PackObjects packObjects,
                DefaultMutableTreeNode parentNode,
                DefaultMutableTreeNode dropNode, int dropNodeIndex, boolean isMove) {

            ImportaMultipleNodesUndoableEdit importAction =
                    new ImportaMultipleNodesUndoableEdit(
                    parentNode, packObjects, dropNodeIndex);
            Vector<DefaultMutableTreeNode> newNodes = importAction.execute();

            treetable.repaint();

            return true;
        }

        /**
         * Drop on se trateaza normal
         */
        public boolean isTreatDropOnAsNear(PackObjects packObjects,
                DefaultMutableTreeNode targetNode) {
            ControllerNode controllerNode = (ControllerNode) targetNode.getUserObject();

            if (controllerNode.getType() == ControllerNode.TYPE_2)
                return true;

            //Default value
            return false;
        }

        /**
         * Paste se trateaza normal
         */
        public boolean isTreatPasteAsDropOn(PackObjects packObjects,
                    DefaultMutableTreeNode targetNode) {
            ControllerNode controllerNode = (ControllerNode) targetNode.getUserObject();

            if (controllerNode.getType() == ControllerNode.TYPE_1)
                return true;

            //Default value
            return false;
        }

    };

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Personalizarea tree-table-ului
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Modelul pentru afisarea randurilor
     */
    private class NodeRowModel implements  RowModel {
        private int scale = 2;

        /**
         * COnstruiesc providerul de date si de informatii desenare
         */
        public NodeRowModel() {
        }

        /**
         * Obtin clasa dintr-o coloana
         * @param column
         * @return
         */
        public Class getColumnClass(int column) {
            switch (column) {
            case 0:
                return String.class;
            case 1:
                return BigDecimal.class;
            case 2:
                return Double.class;
            default:
                assert false;
            }
            return null;
        }

        /**
         * Obtin numarul de coloane
         * @return
         */
        public int getColumnCount() {
            return 3;
        }

        /**
         * Obtin numele coloanelor
         * @param column
         * @return
         */
        public String getColumnName(int column) {
            switch (column) {
            case 0:
                return "Name \n(String)";
            case 1:
                return "Value \n(BigDecimal)";
            case 2:
                return "Another value \n(Double)";
            default:
                assert false;
            }
            return null;
        }

        /**
         * Obtin valoare neprelucrata
         * @param node  Obiectul curent
         * @param column Coloana de unde se obtine
         * @return valoarea neprelucrata
         */
        public Object getValueFor(Object node, int column) {
            DefaultMutableTreeNode currentNode =  ((DefaultMutableTreeNode) node);
            if (currentNode == null) return null;
            ControllerNode n = (ControllerNode) currentNode.getUserObject();

            switch (column) {
            case 0:
                return n.getName();
            case 1:
                return n.getValue();
            case 2:
                return n.getAnotherValue();
            default:
                assert false;
            }
            return null;
        }

        /**
         * Setez tooltip text pentru celule
         * @param node
         * @param column
         * @return
         */
        public String getTooltipTextFor(Object node, int column) {
            DefaultMutableTreeNode currentNode =  ((DefaultMutableTreeNode) node);
            if (currentNode == null) return null;
            ControllerNode n = (ControllerNode) currentNode.getUserObject();

            if (n.getType() == ControllerNode.TYPE_1) {
                if (column == 2 || column == 0)
                    return "ole";
            }

            //Valoarea default
            return null;
        }

        /**
         * Specifica daca celula este editabila
         * @param node
         * @param column
         * @return
         */
        public boolean isCellEditable(Object node, int column) {
            DefaultMutableTreeNode currentNode =  ((DefaultMutableTreeNode) node);
            if (currentNode == null) return false;
            ControllerNode n = (ControllerNode) currentNode.getUserObject();

            if (n.getType() == ControllerNode.TYPE_1)
                return true;
            else return false;
        }

        /**
         * Metoda apelata pentru setarea valorilor
         * @param node
         * @param column
         * @param value
         * @return
         */
        public boolean setValueFor(Object node, int column, Object value) {
            //Cells not editable
            return false;
        }

        /**
         * Metoda apelata daca se solicita fundal special pentru o anumita celula
         * @param node
         * @param column
         * @return
         */
        public boolean isCellImportant(Object node, boolean isExpanded, int column ) {
            DefaultMutableTreeNode currentNode =  ((DefaultMutableTreeNode) node);
            if (currentNode == null) return false;
            ControllerNode n = (ControllerNode) currentNode.getUserObject();

            if (n.getType() == ControllerNode.TYPE_0) {
                if (column == 1) {
                    if (isExpanded)
                        return true;
                }
            }

            //Valoarea default
            return false;
        }

        /**
         * Daca se doreste inlocuirea valorii afisata in panou
         * @param node
         * @param column
         * @return
         */
        public String getOverwriteString(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode =  ((DefaultMutableTreeNode) node);
            if (currentNode == null) return null;
            ControllerNode n = (ControllerNode) currentNode.getUserObject();

            if (n.getType() == ControllerNode.TYPE_2) {
                if (column == 1) return "";
                else if (column == 2 ) return "- \" -";
            } else
            if (n.getType() == ControllerNode.TYPE_0) {
                if (column == 1) {
                    if (isExpanded)
                        return "";
                }
            }

            //Default value
            return null;
        }

        /**
         * If the cell wants to overwrite the row background
         * return a non null value
         * @param node
         * @param column
         * @return
         */
        public Color getOverwriteBackground(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode =  ((DefaultMutableTreeNode) node);
            if (currentNode == null) return null;
            ControllerNode n = (ControllerNode) currentNode.getUserObject();

            if (n.getType() == ControllerNode.TYPE_0) {
                if (column == 0 ) return Color.CYAN;
            } else
            if (n.getType() == ControllerNode.TYPE_2) {
                if (column == 2 ) return Color.LIGHT_GRAY;
            }

            //Default value
            return null;
        }

        /**
         * If the cell wants to overwrite the row background
         * return a non null value
         * @param node
         * @param column
         * @return
         */
        public Color getOverwriteForeground(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode =  ((DefaultMutableTreeNode) node);
            if (currentNode == null) return null;
            ControllerNode n = (ControllerNode) currentNode.getUserObject();

            if (n.getType() == ControllerNode.TYPE_0) {
                if (column == 0 ) return Color.RED;
            } else
            if (n.getType() == ControllerNode.TYPE_2) {
                if (column == 2 ) return Color.RED;
            }

            //Default value
            return null;
        }
    }

    /**
     * Modelul pentru afisarea Nodurilor arborelui
     */
    private class RenderData implements RenderDataProvider {

        /**
         * Construiesc un provider de date pentru desenare
         */
        public RenderData() {
        }

        /**
         * Obtine Stringul ce se afiseaza din nod
         * @param o Nodul ce trebuie desenat
         * @return Textul ce va fi afisat
         */
        public String getDisplayName(Object o) {
            String name = "";
            DefaultMutableTreeNode nod = (DefaultMutableTreeNode) o;
            ControllerNode usernod = (ControllerNode) nod.getUserObject();
            name = usernod.getCod();
            return name;
        }

        /**
         * Seteaza coloarea de Background
         * @param o Nodul cu informatii
         * @return Coloare de fundal pentru materiale
         */
        public Color getBackground(Object o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode) o;
            ControllerNode userObject = (ControllerNode) node.getUserObject();

            switch (userObject.getType()) {
                case ControllerNode.TYPE_0:
                    return new Color(0, 0, 255);
                case ControllerNode.TYPE_1:
                    return new Color(255, 200, 200);
                case ControllerNode.TYPE_2:
                    return new Color(200, 255, 200);
                default:
                    return null;
            }
        }

        /**
         * Seteaza coloarea de Foreground
         * @param o Nodul cu informatii
         * @return Coloare cu care se desenaza
         */
        public Color getForeground(Object o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode) o;
            ControllerNode userObject = (ControllerNode) node.getUserObject();

            switch (userObject.getType()) {
                case ControllerNode.TYPE_0:
                    return new Color(255, 255, 255);
                default:
                    return null;
            }
        }

         /**
         * Obtine tooltipul
         * @param o Nodul cu informatii
         * @return Stringul ce se va afisa cu informatii
         */
        public String getTooltipText(Object o) {
            return null;
        }

         /**
         * Obtine iconul ce se afiseaza cu textul
         * @param o Nodul cu informatii
         * @return Icon-ul ce se va afisa
         */
        public Icon getIcon(Object o,boolean isExpanded) {
            return null;
        }

        /**
         * Obtine tipul resursei din interior
         * @param o Nodul ce contine resursa
         * @return Tipul resursei
         */
        public boolean isGrouping(Object o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode) o;
            ControllerNode userObject = (ControllerNode) node.getUserObject();

            if (userObject.getType() == ControllerNode.TYPE_0)
                return true;
            else return false;
        }

        /**
         * Numarul de zecimale cu care se lucreaza
         * @return
         */
        public int getDecimalScale() {
            return 3;
        }
    }

    /**
     * Clasa ce descrie desenarea headerului de rand
     */
    private class RowWarningHeaderData extends WarningRowBarModel {

        /**
         * Constructorul suprascris
         * @param tabelModel 
         */
        public RowWarningHeaderData(TableModel tabelModel) {
            super(tabelModel);
        }
        
        @Override
        public WarningBarCellData getWarningBarCellData(Object tableObject) {
            if (tableObject instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode) tableObject;
                ControllerNode controllerNode = (ControllerNode) node.getUserObject();

                //Numerul afisat
                WarningBarCellData cellData = new WarningBarCellData();
                if (node.getLevel() == 1)
                    cellData.setText(node.getParent().getIndex(node)+"");
                
                //Culoare in functie de nod
                if (controllerNode.getType() == 1) {
                    cellData.setState(WarningBarCellData.STATE_FATAL);
                    cellData.setTooltipText("Tooltip text");
                    
                    Vector<RunnableSuggestion> suggestions 
                            = new Vector<RunnableSuggestion>();
                    suggestions.add(new RunnableSuggestion() {

                        @Override
                        public String getName() {
                            return "test suggestion";
                        }

                        @Override
                        public void run() {
                            System.out.println(getName());
                        }
                    });
                    suggestions.add(new RunnableSuggestion() {

                        @Override
                        public String getName() {
                            return "another entry";
                        }

                        @Override
                        public void run() {
                            System.out.println(getName());
                        }
                    });
                    cellData.setSuggestions(suggestions);
                    
                }
                
                return cellData;
            } throw new ClassCastException();
        }
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Metode statice pentru rularea clasei
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Init look and feel
        initLookAndFeel();

        //Create and set up the window.
        JFrame frame = new JFrame("TreetableTestClass");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //testez clasa
        TreetableTestClass testClass = new TreetableTestClass();
        frame.add(testClass);

        //Display the window.
        frame.setSize(500, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

     /**
     *  <p style="margin-top: 0">
     *         Initializeaza Look and Feel. Default este cel al sistemului.
     *      </p>
     * @param titlu Titlul ferestrei
     * @author iulian
     */
    public static void initLookAndFeel() {
        String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * Metoda main
     * @param args
     */
    public static void main(String[] args) {
        //Initializez limba
        Locale.setDefault(new Locale("ro", "RO"));

        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
}
