

/* Genomic Comparison Tool
   Master Thesis of computer science

   Author: Yue Lu
   Version: 1.1

*/



/* the tableCellEditor for the color column*/

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.io.*;


public class ColorTableCellEditor extends ColorTableCellRenderer
   implements TableCellEditor
{
	ColorTableCellEditor()
   {


      ColorValue = new JColorChooser();

	  //listener for OK button
	  ActionListener okListener = new ActionListener() {
      	public void actionPerformed(ActionEvent e) {
            System.out.println("Inside ColorTableCellEditor's constructor before calling stopCellEditing in ColorTableCellEditor's constructor:-(");
              stopCellEditing();
        }
      };

	   //listener for Cancel button
      ActionListener cancelListener = new ActionListener() {
		 public void actionPerformed(ActionEvent e) {
		      cancelCellEditing();
		 }
      };

      //create a dialog for JColorChooser
      ColorChooserDialog = JColorChooser.createDialog(null,"select color", false,ColorValue,
      okListener, cancelListener);
	}

   public Component getTableCellEditorComponent(JTable table,
      Object value, boolean isSelected, int row, int column)
   {

      ColorValue.setColor((Color)value);
     System.out.println("Before calling getTableCellRenderC in ColorTableCellEditor clas sin getTableCelleditorComponent method");
     //  open up standard input 
      /** BufferedReader br = new BufferedReader(new InputStreamReader(System.in)); 
      try {
      String temp=br.readLine();
      } catch (IOException ioe) { 
         System.out.println("IO error trying to read crappy user input!"); 
         System.exit(1); 
      } */
      Component Color_Panel=getTableCellRendererComponent(table, value,
       isSelected, true, row, column);
      return Color_Panel;
   }

  public boolean isCellEditable(EventObject e)
   {
	   return true;
   }

   public boolean shouldSelectCell(EventObject e)
   {

      ColorChooserDialog.setVisible(true);

      return true;
   }

   public void cancelCellEditing()
   {
		Object[] listeners = listenerList.getListenerList();

		//cancel the listener if the listener type matched
		for (int i = listeners.length - 2; i >= 0; i -= 2){

		  if (listeners[i]==CellEditorListener.class) {
				// Lazily create the event:
				if (changeEvent == null)
					changeEvent = new ChangeEvent(this);

			   ((CellEditorListener)listeners[i+1]).editingCanceled(changeEvent);
		   }
	   }
      ColorChooserDialog.setVisible(false);
   }

   public boolean stopCellEditing()
   {
	  Object[] listeners = listenerList.getListenerList();
           System.out.println("After selecting color, it comes here...inside stopCellEditing in ColorTableCellEditor");
	  //stop the listener if the listener type matched
	  for (int i = listeners.length - 2; i >= 0; i -= 2){
		if (listeners[i]==CellEditorListener.class) {
                    System.out.println("CellEditorListener's listener is matching?");
			// Lazily create the event:
			if (changeEvent == null)
				changeEvent = new ChangeEvent(this);
			((CellEditorListener)listeners[i+1]).editingStopped(changeEvent);
			System.out.println("Editing is stopped....inside stopcellediting in colortablecelleditor after listener blaha lbah");
                       }
		}

      ColorChooserDialog.setVisible(false);
     System.out.println("Inside stopCellEditing in ColorTableCellEditor");
      return true;
   }

   public Object getCellEditorValue()
   {
	   return ColorValue.getColor();
   }

   public void addCellEditorListener(CellEditorListener l)
   {
	   listenerList.add(CellEditorListener.class, l);
   }

   public void removeCellEditorListener(CellEditorListener l)
   {
	   listenerList.remove(CellEditorListener.class, l);
   }


   private Color color;
   private JColorChooser ColorValue;
   private JDialog ColorChooserDialog;
   private EventListenerList listenerList= new EventListenerList();
   private ChangeEvent changeEvent= new ChangeEvent(this);
}