
/* Genomic Comparison Tool
   Master Thesis of computer science

   Author: Yue Lu
   Version: 1.1

*/


/* This singleton class will get the instance of the database
	connection
*/
import java.net.*;
import java.sql.*;
import java.io.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.event.*;


/* get connection with database through the properties file*/

public class DatabaseConnection
{

	// get the connection through the properties file
	protected DatabaseConnection() throws SQLException,IOException
    {

	    Properties properties = new Properties();
            String fileName = "C:/VDApp/Database_Manager.properties";
	    FileInputStream in = new FileInputStream(fileName);
	    properties.load(in);


		//to get the driver, url, username, and password from the file
	    String drivers = properties.getProperty("jdbc.drivers");
	    if (drivers != null)
	    System.setProperty("jdbc.drivers", drivers);
	    String url = properties.getProperty("jdbc.url");
	    String username = properties.getProperty("jdbc.username");
	    String password = properties.getProperty("jdbc.password");
            System.out.println("I got all of this from Database_Manager.properties.txt");
	    con=DriverManager.getConnection(url, username, password);

      }

	//return the database connection
    public Connection getConnection()
    {
		return con;
    }

	// get the instance of the database connection
    public static DatabaseConnection getInstance()
    {
       try{

		   if (instance == null)
            instance= new DatabaseConnection();
		}
      catch (SQLException ex)
      {

		  System.out.println ("1"+ex);

      }
      catch (IOException ex)
      {

		  System.out.println("2" + ex);

      }

      return instance;
	}

	//close the database
	public void Close_Database()
	{
		try{
			con.close();
		}
      catch (SQLException ex)
      {

		  System.out.println (""+ex);

      }

	}

	private Connection con;
	private static DatabaseConnection instance = null;

}
