
//~--- JDK imports ------------------------------------------------------------

/* This is the class which connects with database and
   get the distinct values of the selected attribute
   and put them into the ColorShape table
*/
import java.awt.*;
import java.awt.event.*;

import java.io.*;

import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;

//~--- classes ----------------------------------------------------------------

/**
 * Attribute Selection contains methods for manipulating attributes
 * corresponding to particular table depending on incoming events
 * @author Yue Lu, Lalitha Viswanath
 * @version 1.2
 * @design Dr.George Fox, Yue Lu, Lalitha Viswanath
 */
public class AttributeSelection {
    private Object[] rowData = new Object[5];

    //~--- constructors -------------------------------------------------------

    // constructor

    /**
     * Attribute Selection Overridden method
     * @param evt Event such as clicking on a particular table/attribute
     * @param jTable1 Table containing information for gene region
     * @param jTable2pregene Table containing information corresponding to upstream region
     * of gene
     * @param jTable3postgene Table containing information corresponding to downstream
     * region of gene
     * @param Table_Name Table whose data is being viewed
     */
    public AttributeSelection(final ListSelectionEvent evt,
                              final JTable jTable1,
                              final JTable jTable2pregene,
                              final JTable jTable3postgene,
                              final String Table_Name) {
        if (evt.getValueIsAdjusting() == false) {
            // getting the values from the list
            JList    source      = (JList) evt.getSource();
            Object[] values1     = source.getSelectedValues();
            String   Column_Name = "";

            // get the column names
            for (int i = 0; i < values1.length; i++) {
                String word = (String) values1[i];

                Column_Name += word + " ";
            }

            String queryNew = "select [" + Column_Name + "], count (["
                              + Column_Name + "]) from " + Table_Name
                              + " group by [" + Column_Name + "] ";

            System.exit(0);

            DatabaseQueryString ListNew       =
                new DatabaseQueryString(queryNew);
            Vector              wordsNew      = ListNew.getList();
            int                 totalNonNulls = 0;

            // put the value into the ColorShapeTableModel
            for (int i = 0; i < wordsNew.size(); i++) {
                rowData[0] = Column_Name;
                rowData[1] = wordsNew.elementAt(i);
                rowData[2] = wordsNew.elementAt(++i);
                // totalNonNulls += (int)rowData[2];
                rowData[3] = Color.white;

                Icon blank = new blank();

                rowData[4] = blank;

                DefaultTableModel model =
                    (DefaultTableModel) jTable1.getModel();
                DefaultTableModel preGenemodel =
                    (DefaultTableModel) jTable2pregene.getModel();
                DefaultTableModel postGenemodel =
                    (DefaultTableModel) jTable3postgene.getModel();

                model.addRow(rowData);    // add data to the rows using superclass methods
                preGenemodel.addRow(rowData);
                postGenemodel.addRow(rowData);
            }
        }
    }

    /**
     * Overridden method
     * @param evt Event which caused this method to be invoked
     * @param jTable1 Table containing information for gene region
     * @param jTable2pregene Table containing information corresponding to upstream region
     * of gene
     * @param jTable3postgene Table containing information corresponding to downstream
     * region of gene
     * @param Table_Name Table whose data is being viewed
     */
    public AttributeSelection(final MouseEvent evt, final JTable jTable1,
                              final JTable jTable2pregene,
                              final JTable jTable3postgene,
                              final String Table_Name) {
        if (evt.getButton() != evt.NOBUTTON) {
            // getting the values from the list
            JList    source      = (JList) evt.getSource();
            Object[] values1     = source.getSelectedValues();
            String   Column_Name = "";

            // get the column names
            for (int i = 0; i < values1.length; i++) {
                String word = (String) values1[i];

                Column_Name += word + " ";
            }

            String queryNew = "select [" + Column_Name + "], count (["
                              + Column_Name + "]) from " + Table_Name
                              + " group by [" + Column_Name + "] ";
            DatabaseQueryString ListNew = new DatabaseQueryString(queryNew);
            // System.out.println(" The query is " + queryNew);
            Vector wordsNew = ListNew.getList();
            String newq     = "select count([" + Column_Name + "]) from "
                              + Table_Name + " where [" + Column_Name
                              + "] is NOT NULL";
            int value = 0;

            try {
                DatabaseConnection connection =
                    DatabaseConnection.getInstance();
                Connection con = connection.getConnection();

                if (newq != null) {
                    // System.out.println("The new query is " + newq);
                    Statement stmt = con.createStatement();
                    ResultSet rs   = stmt.executeQuery(newq);

                    while (rs.next()) {
                        value = rs.getInt(1);
                    }

                    stmt.close();
                }
            } catch (SQLException ex) {
                System.out.println("6" + ex);
            }

            String            Query      = "select * from [" + Table_Name
                                           + "]";
            DatabaseRowNumber Num        = new DatabaseRowNumber(Query);
            int               totalRows  = Num.getRowNumber();
            int               nullValues = totalRows - value;

            // put the value into the ColorShapeTableModel
            for (int i = 0; i < wordsNew.size(); i++) {
                rowData[0] = Column_Name;
                rowData[1] = wordsNew.elementAt(i);

                if (wordsNew.elementAt(i + 1).toString() == "0") {
                    rowData[2] = nullValues + "";

                    i++;

                    rowData[1] = "NullEntry";
                } else {
                    rowData[2] = wordsNew.elementAt(++i);
                }

                rowData[3] = Color.white;

                Icon blank = new blank();

                rowData[4] = blank;

                DefaultTableModel model =
                    (DefaultTableModel) jTable1.getModel();
                DefaultTableModel preGenemodel =
                    (DefaultTableModel) jTable2pregene.getModel();
                DefaultTableModel postGenemodel =
                    (DefaultTableModel) jTable3postgene.getModel();

                model.addRow(rowData);    // add data to the rows using superclass methods
                preGenemodel.addRow(rowData);
                postGenemodel.addRow(rowData);
            }
        }
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
