
//~--- JDK imports ------------------------------------------------------------

//This class is the tableModel
//    for the ColorShapeTable Model
import java.awt.*;
import java.awt.event.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

//~--- classes ----------------------------------------------------------------

//inherit from the defaultTableModel in order to
//use the super class method like addRow(), removeRow()

/**
 * Class for Color Table
 * @author Yue Lu
 * @version 1.2
 * @design Dr.George Fox, Yue Lu
 */
public class ColorTableModel extends DefaultTableModel {
    public static final long serialVersionUID = 24362462L;

    //~--- fields -------------------------------------------------------------

    private Object[] value = new Object[5];

    //~--- constructors -------------------------------------------------------

    // constructor

    /**
     * Constructor
     * @param columnName Takes in array of objects
     * @param rowNumber number of rows
     */
    public ColorTableModel(final Object[] columnName, final int rowNumber) {
        super(columnName, rowNumber);

        // input the default values to the table
        value[0] = "";
        value[1] = "";
        value[2] = "";
        value[3] = Color.white;
        value[4] = new ImageIcon("");
    }

    //~--- get methods --------------------------------------------------------

    /**
     * returns class corresponding to column Number
     * @return returns ColumnClass
     * @param column number corresponding to column Name
     */
    public Class getColumnClass(final int column) {
        return value[column].getClass();
    }

    // only Color and Shape column can be modified

    /**
     * determines whether a given cell is editable or not
     * @param row row number of cell
     * @param column column number of cell
     * @return returns whether cell is editable or nor
     */
    public boolean isCellEditable(final int row, int column) {
        if ((column == 3) || (column == 4)) {
            return true;
        } else {
            return false;
        }
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
