
//~--- JDK imports ------------------------------------------------------------

import java.awt.*;
import java.awt.event.*;

import java.io.*;

/* This class get the connection with database and get the all
        the column name from the table
*/
import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;

//~--- classes ----------------------------------------------------------------

public class DatabaseColumnName {
    private Vector     ColumnName = new Vector(0, 1);
    private Connection con;
    private String     query;

    //~--- constructors -------------------------------------------------------

    // constructor
    public DatabaseColumnName(final String query) {
        try {
            // get the database connection instance
            DatabaseConnection connection = DatabaseConnection.getInstance();

            con = connection.getConnection();

            // execute the query
            Statement stmt = con.createStatement();
            ResultSet rs   = stmt.executeQuery(query);

            // get the query's columnNames
            ResultSetMetaData rsmd = rs.getMetaData();

            for (int i = 1; i <= rsmd.getColumnCount(); i++) {
                ColumnName.addElement(rsmd.getColumnLabel(i));
            }

            stmt.close();
        } catch (SQLException ex) {
            System.out.println(
                "Error in DatabaseColumnName \n Class: DatabaseColumnName \n"
                + ex);
        }
    }

    //~--- get methods --------------------------------------------------------

    // return the columnName
    public Vector getColumnName() {
        return ColumnName;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
