
//~--- JDK imports ------------------------------------------------------------

import java.awt.*;

import java.io.*;

/* This calss get the database connection and
        return the resultset as a array
*/
import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;

//~--- classes ----------------------------------------------------------------

/**
 * Class for executing Database Query String query
 * @version 1.2
 * @author Yue Lu, Lalitha Viswanath
 * @design Dr.George Fox, Yue Lu, Lalitha Viswanath
 */
public class DatabaseQuery {
    private ResultSet  Query_Result;
    private Connection con;
    private String     query;

    //~--- constructors -------------------------------------------------------

    /**
     * Constructor for Database Query
     * @param q Query String
     */
    public DatabaseQuery(final String q) {
        query = q;

        try {
            // get the database connection instance
            DatabaseConnection connection = DatabaseConnection.getInstance();

            con = connection.getConnection();

            // execute the query
            Statement stmt = con.createStatement();
            ResultSet rs   = stmt.executeQuery(query);

            stmt.close();
            // rs.close();
        } catch (SQLException ex) {
            System.out.println(
                "Error in executing database query\nClass: DatabaseQuery\n"
                + ex);
        }
    }

    //~--- get methods --------------------------------------------------------

    // get the query as a ResultSet

/**
 * returns Query String
 * @return Result Set
 */
    public ResultSet getQueryResult() {
        return Query_Result;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
