

/* the program to draw the square and color or shape*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.net.*;
import java.sql.*;
import java.io.*;




/**
 * Class for drawing gene information and upstream, downstream region on display
 * @author Yue Lu, Lalitha Viswanath
 * @version 1.2
 * @design Dr. George Fox, Yue Lu, Lalitha Viswanath
 */
public class DatabaseVisualDisplay extends JPanel {

    //constructor

    /**
     * Constructor
     * @param T_Name Table Name whose data is being viewed
     * @param C_Data vector containing data corresponding to gene information (such as color and shape) to be viewed
     * @param preC_Data vector containing data corresponding to upstream region of gene information (such as color and shape) to be viewed
     * @param postC_Data vector containing data corresponding to donwstream region of gene information (such as color and shape) to be viewed
     * @param totalRowsToDisplay total number of genes to display
     * @param dispX display Offset in the X axis
     * @param dispY display Offset in the Y axis
     * @param rws number of rows required to display data
     * @param cols number of columns required to display data
     * @param widthCell width of cell to be displayed
     * @param htCell height of cell to be displayed
     * @param directions array containing directions corresponding to each gene
     */
    public DatabaseVisualDisplay(final String T_Name, final Vector C_Data, final Vector preC_Data, final Vector postC_Data, final int totalRowsToDisplay, final int dispX, final int dispY, final int rws, final int cols, final int widthCell, final int htCell, final int[] directions, final int gridFlag) {
        Table_Name=T_Name;
        Color_Data=C_Data;
        PreGColor_Data = preC_Data;
        PostGColor_Data = postC_Data;
        total =  totalRowsToDisplay;
        columns = cols;
        rows = rws;
        widthOfCell = widthCell;
        heightOfCell = htCell;
        displayOffY = dispY;
        displayOffX = dispX;
        directionCells = new int[total];
        directionCells = directions;

        gridF = gridFlag;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(screenSize.width, screenSize.height*7/10));
    }

    //set the font
    /**
     * sets fonts for display
     * @param g Grpahics context of current display
     */
    public void setFonts(final Graphics g) {
        if (f != null)
            return;
        f = new Font("SansSerif", Font.BOLD, 2);
        fi = new Font("SansSerif",Font.BOLD + Font.ITALIC, 6);
        fm = g.getFontMetrics(f);
        fim = g.getFontMetrics(fi);
    }

    //paint the colors and shapes
    /**
     * paints display area
     * @param g Graphics Context of current display
     */
    public void paintComponent(final Graphics g) {
        super.paintComponent(g);
        //execute the query to get the rowNumber of the query
        String Query="select * from ["+Table_Name+"]";

        DatabaseRowNumber Num=new DatabaseRowNumber(Query);
        total=Num.getRowNumber();

        //draw the number indicate the gene location in the database
        DrawNumber(g);
        //draw the Rectangles to represent the genes in the database
        DrawRect(g);

        //get the row Data from the color shape table
        Enumeration enumVar = Color_Data.elements();
        int temp=0;
        while (enumVar.hasMoreElements()) {
            Vector Data=(Vector)enumVar.nextElement();
            Enumeration enum_Data = Data.elements();
            int i=0;
            while(enum_Data.hasMoreElements()) {
                C_Data[i]=enum_Data.nextElement();
                i++;
            }
            // get connection with database
            try {
                //get the Column_Name and value that user want to display
                String Column_Name=C_Data[0].toString();
                Object value2=C_Data[1];
                Color color=(Color)C_Data[3];
                Icon shape=(Icon)C_Data[4];

                //get the shapes' name
                String shapeString=shape.toString();
                String s=shapeString.substring(0, 6);

                if(color != Color.white || !s.equals("blank.")) {
                    if(value2=="NullEntry") {
                        query = "select ID, ["+Column_Name+"] from ["+Table_Name+"] where ["+Column_Name+"] is null";
                    } else {
                        String string=new String();
                        if(value2==null) {
                            value2="null";
                            query = "select ID, ["+Column_Name+"] from ["+Table_Name+"] where ["+Column_Name+"] is NULL";
                        } else if(value2.getClass()==string.getClass()) {

                            query = "select ID, ["+Column_Name+"] from ["+Table_Name+"] where ["+Column_Name+"]="+"'"+value2+"'";
                        } else {

                            query = "select ID, ["+Column_Name+"] from ["+Table_Name+"] where ["+Column_Name+"]="+value2;
                        }
                    }

                    //get the database connection instance
                    DatabaseConnection connection=DatabaseConnection.getInstance();
                    con=connection.getConnection();

                    //get all the IDs that match with Column_Name and values
                    Statement stmt = con.createStatement();
                    rs = stmt.executeQuery(query);

                    //iterate the ResultSet to draw the color and Shape for
                    //each gene

                    while (rs.next()) {
                        int proteinNum=rs.getInt(1);

                        //fill the color on each gene
                        DrawColor(proteinNum,color,g,0);

                        //draw shape on each gene
                        DrawShape(proteinNum, s, g,0);

                    }
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                System.out.println("Error in rendering colors to the cells\nClass:DatabaseVisualDisplay\n"+ex);
            }
        }
        //****************************************************************************
        //draw pre-gene information
        Enumeration enumpregene = PreGColor_Data.elements();
        int pregenetemp=0;
        while (enumpregene.hasMoreElements()) {
            Vector pregeneData=(Vector)enumpregene.nextElement();
            Enumeration enum_Datapregene = pregeneData.elements();
            int i=0;
            while(enum_Datapregene.hasMoreElements()) {
                pregeneC_Data[i]=enum_Datapregene.nextElement();
                i++;
            }

            // get connection with database
            try {
                //get the Column_Name and value that use want to display
                String pregeneColumn_Name=pregeneC_Data[0].toString();
                Object pregenevalue2=pregeneC_Data[1];
                Color pregenecolor=(Color)pregeneC_Data[3];
                Icon pregeneshape=(Icon)pregeneC_Data[4];
                //get the shapes' name
                String pregeneshapeString=pregeneshape.toString();
                String pregenes=pregeneshapeString.substring(0, 6);
                if(pregenecolor!=Color.white || !pregenes.equals("blank.")) {
                    if(pregenevalue2=="NullEntry") {
                        query = "select ID, ["+pregeneColumn_Name+"] from ["+Table_Name+"] where ["+pregeneColumn_Name+"] is null";
                    } else {
                        String pregenestring=new String();
                        if(pregenevalue2==null) {
                            pregenevalue2="null";
                            query = "select ID, ["+pregeneColumn_Name+"] from ["+Table_Name+"] where ["+pregeneColumn_Name+"] is NULL";
                        } else
                            if(pregenevalue2.getClass()==pregenestring.getClass()) {
                                query = "select ID, ["+pregeneColumn_Name+"] from ["+Table_Name+"] where ["+pregeneColumn_Name+"]="+"'"+pregenevalue2+"'";
                            } else {
                                query = "select ID, ["+pregeneColumn_Name+"] from ["+Table_Name+"] where ["+pregeneColumn_Name+"]="+pregenevalue2;
                            }
                    }
                    //get the database connection instance
                    DatabaseConnection pregeneconnection=DatabaseConnection.getInstance();
                    con=pregeneconnection.getConnection();
                    //get all the IDs that match with Column_Name and values
                    Statement pregenestmt = con.createStatement();
                    rs = pregenestmt.executeQuery(query);
                    //iterate the ResultSet to draw the color and Shape for each gene
                    while (rs.next()) {
                        int proteinNum=rs.getInt(1);
                        //fill the color on each gene
                        DrawColor(proteinNum,pregenecolor,g, -1);

                        //draw shape on each gene
                        DrawShape(proteinNum, pregenes, g, -1);
                    }
                    pregenestmt.close();
                }
            } catch (SQLException ex) {
                System.out.println("10"+ex);
            }
        }
        //****************************************************************

        //draw pre-gene information
        Enumeration enumpostgene = PostGColor_Data.elements();
        int postgenetemp=0;
        while (enumpostgene.hasMoreElements()) {
            Vector postgeneData=(Vector)enumpostgene.nextElement();
            Enumeration enum_Datapostgene = postgeneData.elements();
            int i=0;
            while(enum_Datapostgene.hasMoreElements()) {
                postgeneC_Data[i]=enum_Datapostgene.nextElement();
                i++;
            }

            // get connection with database
            try {
                //get the Column_Name and value that use want to display
                String postgeneColumn_Name=postgeneC_Data[0].toString();
                Object postgenevalue2=postgeneC_Data[1];
                Color postgenecolor=(Color)postgeneC_Data[3];
                Icon postgeneshape=(Icon)postgeneC_Data[4];
                //get the shapes' name
                String postgeneshapeString=postgeneshape.toString();
                String postgenes=postgeneshapeString.substring(0, 6);
                if(postgenecolor!=Color.white || !postgenes.equals("blank.")) {
                    if(postgenevalue2=="NullEntry") {
                        query = "select ID, ["+postgeneColumn_Name+"] from ["+Table_Name+"] where ["+postgeneColumn_Name+"] is null";
                    } else {
                        String postgenestring=new String();
                        if(postgenevalue2==null) {
                            postgenevalue2="null";
                            query = "select ID, ["+postgeneColumn_Name+"] from ["+Table_Name+"] where ["+postgeneColumn_Name+"] is NULL";
                        } else
                            if(postgenevalue2.getClass()==postgenestring.getClass()) {
                                query = "select ID, ["+postgeneColumn_Name+"] from ["+Table_Name+"] where ["+postgeneColumn_Name+"]="+"'"+postgenevalue2+"'";
                            } else {
                                query = "select ID, ["+postgeneColumn_Name+"] from ["+Table_Name+"] where ["+postgeneColumn_Name+"]="+postgenevalue2;
                            }
                    }
                    //get the database connection instance
                    DatabaseConnection postgeneconnection=DatabaseConnection.getInstance();
                    con=postgeneconnection.getConnection();
                    //get all the IDs that match with Column_Name and values
                    Statement postgenestmt = con.createStatement();
                    rs = postgenestmt.executeQuery(query);
                    //iterate the ResultSet to draw the color and Shape for
                    //each gene
                    while (rs.next()) {
                        int proteinNum=rs.getInt(1);
                        DrawColor(proteinNum,postgenecolor,g, 1);

                        //draw shape on each gene
                        DrawShape(proteinNum, postgenes, g, 1);
                    }
                    postgenestmt.close();
                }
            } catch (SQLException ex) {
                System.out.println("10"+ex);
            }
        }
    }

    //draw the rectangle represent each gene
    /**
     * draw rectangles and symbols corresponding to information to be displayed.
     * Also draws '+" sign corresponding to genes which are on the forward strand
     * @param g Graphics context of display
     */
    public void DrawRect(final Graphics g) {
        int i, j, k;
        int proteinCounter=0;
        for(i=0; i<rows; i++) {
            for(j=0; j<columns;j++) {
                g.setColor(Color.black);

                // pre gene rectangle
                if(gridF==1) {
                    if(proteinCounter < total)
                        g.drawRect((2*displayOffX)+1 + j*(widthOfCell*75/100), (2*displayOffY)+1+(i*(heightOfCell*8/10)),(widthOfCell*75/100)*2/10,heightOfCell*8/10);

                    // gene rectangle
                    g.drawRect((2*displayOffX)+1 + j*(widthOfCell*75/100) +((widthOfCell*75/100)*2/10), (2*displayOffY)+1+(i*(heightOfCell*8/10)),(widthOfCell*75/100)*6/10,heightOfCell*8/10);
                }

                if(gridF==0)
                    // MODIFICATIONS MADE ON 13TH JAN 2005
                    // drawing ONE big Rectangle
                    //System.out.println("Drawing one big rect ");
                    g.drawRect((2*displayOffX)+1 + j*(widthOfCell*75/100), (2*displayOffY)+1+(i*(heightOfCell*8/10)),(widthOfCell*75/100),heightOfCell*8/10);

                if((proteinCounter < total)&&(directionCells[proteinCounter]==1)) // forward strand
                {
                    // draws vertical line
                    int x1 =(2*displayOffX)+1 + j*(widthOfCell*75/100) +((widthOfCell*75/100)*5/10);
                    int x2=x1;
                    int y1 =  (2*displayOffY)+1+(i*(heightOfCell*8/10))+(heightOfCell*8/10)*3/10;
                    int y2 =   (2*displayOffY)+1+(i*(heightOfCell*8/10))+(heightOfCell*8/10)*8/10;
                    g.drawLine(x1, y1, x2, y2);
                    // draws horizontal line
                    int x11 = (2*displayOffX)+1 + j*(widthOfCell*75/100) +((widthOfCell*75/100)*4/10);
                    int x12 =  (2*displayOffX)+1 + j*(widthOfCell*75/100) +((widthOfCell*75/100)*3/10)+ (widthOfCell*75/100)*3/10;
                    int y11 = (2*displayOffY)+1+(i*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                    int y12 = y11;
                    g.drawLine(x11,y11, x12, y12);
                }

                // post gene rectangle
                if(gridF==1) {
                    if(proteinCounter < total)
                        g.drawRect((2*displayOffX)+1 + j*(widthOfCell*75/100) + ((widthOfCell*75/100)*75/100), (2*displayOffY)+1+(i*(heightOfCell*8/10)),((widthOfCell*75/100)*25/100),heightOfCell*8/10);
                }
                proteinCounter++;
            }
        }

        //get the rest of rectangle that are not enough for columns genes
        int left=total%columns;
        for(k=0; k<left; k++) {
            //pre gene rect
            if(gridF==1)  {
                g.drawRect((2*displayOffX)+1 + k*(widthOfCell*75/100), (2*displayOffY)+1+(rows*(heightOfCell*8/10)),(widthOfCell*75/100)*2/10,heightOfCell*8/10);
                // middle rect
                //if(directionCells[proteinCounter]==0)
                g.drawRect((2*displayOffX)+1 + k*(widthOfCell*75/100) +((widthOfCell*75/100)*2/10), (2*displayOffY)+1+(rows*(heightOfCell*8/10)),(widthOfCell*75/100)*6/10,heightOfCell*8/10);
            }

            if(directionCells[proteinCounter]==1) // forward strand
            {
                // draws vertical line
                int x1 =(2*displayOffX)+1 + k*(widthOfCell*75/100) +((widthOfCell*75/100)*5/10);
                int x2=x1;
                int y1 =  (2*displayOffY)+1+(rows*(heightOfCell*8/10))+(heightOfCell*8/10)*3/10;
                int y2 =   (2*displayOffY)+1+(rows*(heightOfCell*8/10))+(heightOfCell*8/10)*8/10;
                g.drawLine(x1, y1, x2, y2);
                // draws horizontal line
                int x11 = (2*displayOffX)+1 + k*(widthOfCell*75/100) +((widthOfCell*75/100)*4/10);
                int x12 =  (2*displayOffX)+1 + k*(widthOfCell*75/100) +((widthOfCell*75/100)*3/10)+ (widthOfCell*75/100)*3/10;
                int y11 = (2*displayOffY)+1+(rows*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                int y12 = y11;
                g.drawLine(x11,y11, x12, y12);
            }
            if(gridF==1) {
                //  last rect
                g.drawRect((2*displayOffX)+1 + k*(widthOfCell*75/100) + ((widthOfCell*75/100)*75/100), (2*displayOffY)+1+(rows*(heightOfCell*8/10)),((widthOfCell*75/100)*25/100),heightOfCell*8/10);
            }
            // modifications on jan 13th 2005
            if(gridF==0) {
                // one big rect
                g.drawRect((2*displayOffX)+1 + k*(widthOfCell*75/100), (2*displayOffY)+1+(rows*(heightOfCell*8/10)),(widthOfCell*75/100),heightOfCell*8/10);
            }
            proteinCounter++;
        }
    }

    //draw the number for indicating the gene positions
    /**
     * draws numbers along X and Y axis to enable user to understand the display better
     * @param g Graphics context
     */
    public void DrawNumber(Graphics g) {
        g.setColor(Color.black);
        //draw horizontal numbers
        for(int i=0; i<=columns; i++) {
            if((i % 10) ==0) {
                String num= i + "" ;
                int x = (2*displayOffX) + (widthOfCell*75/100 * i);
                int y=displayOffY;
                g.setFont(f);
                g.drawString(num, x, y);
            }
        }

        //draw vertical Numbers
        int rowsFor1000 = 1000/columns;
        int counter=0;
        for(int i=0; i<=rows; i++) {
            if(i % rowsFor1000 == 0) {
                String num=counter*1000 + "";
                counter++;
                int x=(int)(0.5*displayOffX);
                int y=(2*displayOffY)+(heightOfCell * 8/10 * i);
                g.drawString(num, x, y);
            }
        }
    }


    //fill the color of the rectangle
    /**
     * colors the displayed rectangles appropriately
     * @param proteinNum the number of gene being displayed
     * @param Draw_Color color in which gene[proteinNum] should be displayed
     * @param g Graphics Context
     * @param flag determines whether upstream, gene or downstream region is to be displayed.
     * Flag=-1 means upstream region
     * Flag=0 means gene region
     * Flag=1 means downstream region
     */
    public void DrawColor(final int proteinNum, final Color Draw_Color, final Graphics g, final int flag) {
        g.setColor(Draw_Color);
        g.setXORMode(Color.white);
       // System.out.println(" protein number is" +proteinNum);
        // no grid means fill full rectangle
        if(gridF==0)
        {
            if(flag==0)
            {
                //System.out.println(" x coord is " + ((proteinNum-1)%columns)*(widthOfCell*75/100)+(2*displayOffX)+1);
                g.fillRect(((proteinNum-1)%columns)*(widthOfCell*75/100)+(2*displayOffX)+1, ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY)+1+1, ((widthOfCell*80/100))-1, ((heightOfCell*8/10)*90/100)-1);
            }
        } else {
         // 0 flag indicates center 
        // -1 indicates upstream
        // 1 indicates downstream
         if(flag==0) {
            g.fillRect(((proteinNum-1)%columns)*(widthOfCell*75/100)+(2*displayOffX)+1+((widthOfCell*75/100)*2/10)+1, ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY)+1+1, ((widthOfCell*75/100)*6/10)-1, (heightOfCell*8/10)-1);
        } else if (flag==-1) {
            g.fillRect(((proteinNum-1)%columns)*(widthOfCell*75/100)+(2*displayOffX)+1+1, ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY)+1+1, ((widthOfCell*75/100)*2/10)-1, (heightOfCell*8/10)-1);
        } else if (flag==1) {
            g.fillRect(((proteinNum-1)%columns)*(widthOfCell*75/100)+(2*displayOffX)+1+((widthOfCell*75/100)*8/10)+1, ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY)+1+1, ((widthOfCell*75/100)*2/10), (heightOfCell*8/10)-1);

        } 
        }
    }

    //fill the shape in the rectangles
    /**
     * Draws shape on the displayed region, if selected
     * @param proteinNum the number of gene being displayed
     * @param shape Shape number corresponding to which shape is to be displayed
     * @param g Graphics Context of display
     * @param flag determines whether upstream, gene or downstream region is to be displayed.
     * Flag=-1 means upstream region
     * Flag=0 means gene region
     * Flag=1 means downstream region
     */
    public void DrawShape(final int proteinNum, final String shape, final Graphics g, final int flag) {
        //Draw the shape which is shorter than the rectangle
        //will make it look better
        // shape 1 is diagonal from right to left
        // shape 2 is diagonal from left to right
        // shape 3 is vertical line
        // shape 4 is horizpntal line
        //System.out.println("Inside draw shapes");
        int x1=0, x2=0, y1=0, y2=0;
        if(shape.equals("Shape1")) {
           // System.out.println("Inside draw shapes 1");
            
            if(gridF==1) {
            //System.out.println("Inside Shape 1");
            g.setColor(Color.BLACK);
            if(flag==-1) {
                x2 = (2*displayOffX)+1 + (((proteinNum-1)%columns)*(widthOfCell*75/100));
                x1 =(2*displayOffX)+1 + (((proteinNum-1)%columns)*(widthOfCell*75/100)) +((widthOfCell*75/100)*2/10);
                y1 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
            }
            // post gene information
            else if(flag==1) {
                x1 =  (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +(widthOfCell*75/100);
                x2 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*8/10);
                y1 =  (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =   (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
            }
            // gene information
            else if (flag==0) {
                // take x-coords from shape 4 and revert them (i.e. x2 in shape 3 becomes x1 and vice versae)
                //  take y-coords from shape 3 and DO NOT revert them
                x1 =  (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*7/10);
                x2 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*2/10);
                
                y1 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
            }            
            g.drawLine(x1,y1, x2, y2);
            } else if(gridF==0)
            {
                g.setColor(Color.BLACK);
                x1 =  (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100));
                x2 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) /*+((widthOfCell*75/100)*2/10)*/;
                
                y1 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
                g.drawLine(x1,y1, x2, y2);
            }
        }
        else if(shape.equals("Shape2")) {
            // goes frm right to left
            // System.out.println("Inside Shape 2");
            g.setColor(Color.BLACK);
            //g.setPaintMode();
            if(gridF == 1) {
            if(flag==-1) {
                x1 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100);
                x2 =(2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*2/10);
                y1 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
            }
            //g.drawLine(((proteinNum-1)%columns)*(widthOfCell*75/100)+(2*displayOffX), ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY)+(heightOfCell*8/10),((proteinNum-1)%columns)*(widthOfCell*75/100)+(2*displayOffX)+((widthOfCell*75/100)*2/10)+2, ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY));
            // post gene information
            else if(flag==1) {
                x2 =  (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +(widthOfCell*75/100);
                x1 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*8/10);
                y1 =  (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =   (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
            }
            //g.drawLine(((proteinNum-1)%columns)*(widthOfCell*75/100)+(2*displayOffX)+((widthOfCell*75/100)*8/10), ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY)+(heightOfCell*8/10),((proteinNum-1)%columns)*(widthOfCell*75/100)+(2*displayOffX)+((widthOfCell*75/100)*8/10)+((widthOfCell*75/100)*2/10), ((proteinNum-1)/columns)*(heightOfCell*8/10)+(2*displayOffY));
            else if(flag==0) {
                x2 =  (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*7/10);
                x1 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*2/10);
                y1 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
            }
            g.drawLine(x1,y1,x2,y2);
            } else if (gridF==0){
                g.setColor(Color.BLACK);
                x2 =  (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100));
                x1 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100);
                y1 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
            g.drawLine(x1,y1,x2,y2);
            }
        }
        else if(shape.equals("Shape4")) {
            //System.out.println("Inside Shape 4");
            if(gridF == 1) {
            g.setColor(Color.BLACK);
            g.setPaintMode();
            if(flag==-1) {
                x1 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100);
                x2 =  (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*2/10);
                y1 = (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                y2 = y1;
            }
            // post gene information
            else if(flag==1) {
                x1 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*8/10);
                x2 =  (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +(widthOfCell*75/100);
                y1 = (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                y2 = y1;
            } else if(flag==0) {
                x1 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*2/10);
                x2 =  (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*7/10);
                y1 = (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
                y2 = y1;
            }
            g.drawLine(x1,y1,x2,y2);
        } else if (gridF==0) {
            g.setColor(Color.BLACK);
            //g.setPaintMode();
            x1 = (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100);
            x2 =  (2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +(widthOfCell*75/100);
            y1 = (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+((heightOfCell*8/10)*5/10);
            y2 = y1;
            g.drawLine(x1,y1,x2,y2);
        }
        }
        else if(shape.equals("Shape3")) {
           // System.out.println("Inside Shape 3");
            g.setColor(Color.BLACK);
            g.setPaintMode();
            // pre gene information
            if(flag==-1) {
                x1 =(2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*15/100);
                x2=x1;
                y1 =  (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =   (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
            }
            // post gene information
            else if(flag==1) {
                x1 =(2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*85/100);
                x2=x1;
                y1 =  (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =   (2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
            } else if (flag==0) {
                x1 =(2*displayOffX)+1 + ((proteinNum-1)%columns)*(widthOfCell*75/100) +((widthOfCell*75/100)*5/10);
                x2=x1;
                y1 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10));
                y2 =(2*displayOffY)+1+(((proteinNum-1)/columns)*(heightOfCell*8/10))+(heightOfCell*8/10)*9/10;
            }
            g.drawLine(x1, y1, x2, y2);
        }

    }


    private Font f;
    private Font fi;
    private FontMetrics fm;
    private FontMetrics fim;
    private int current = 0;
    private String Table_Name;
    private Vector Color_Data, PreGColor_Data, PostGColor_Data;
    private Object[] C_Data=new Object[5];
    private Object[] pregeneC_Data = new Object[5];
    private Object[] postgeneC_Data = new Object[5];
    private ResultSet rs;
    private int total;
    private Connection con;
    private String query;
    private int rows, columns, widthOfCell, heightOfCell;
    private int displayOffY, displayOffX;
    private int  panelHeight, gridF;
    private int[] directionCells;
    public static final long serialVersionUID = 24362462L;
}
