

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.net.*;
import java.sql.*;
import java.io.*;
import java.util.*;
import java.net.URL;
import java.net.MalformedURLException;
//import org.jdesktop.jdic.desktop.Desktop;
//import org.jdesktop.jdic.desktop.DesktopException;

/**
 * Class for displaying the gene features in the genome
 * @author Yue Lu, Lalitha Viswanath
 * @version 1.2
 * @design Dr. George Fox, Yue Lu, Lalitha Viswanath
 */
public class VisualInterface extends JFrame {

    /*Constructor*/

    /**
     * Constructor for creating the Window in which the display occurs
     */
    public VisualInterface () {
        //set Icon
        //setIconImage(Toolkit.getDefaultToolkit().createImage(VisualInterface.class.getResource("bg.gif")));

        //get contentPane, set BorderLayout
        Container contentPane = getContentPane();
        contentPane.setLayout(new BorderLayout());

        //Set the frame size as the user's screen size
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        height=(int)screenSize.height*1/2;
        this.setSize(new Dimension(screenSize.width,(int)(screenSize.height*0.95)));
        this.setTitle("Genome Display Tool");
        tempWidth = (int)0.4%(screenSize.width);
        tempHt = height -30;
        totalGenesToDisplay = -1;
        //**************************************************************************
        //Open Database Button

        ImageIcon OpenImage = new ImageIcon("Open_folder.gif");
        OpenButton = new JButton();
        OpenButton.setIcon(OpenImage);
        OpenButton.setText("Open Database");
        OpenButton.setBorder(null);
        OpenButton.setMaximumSize(new Dimension(200, 30));
        OpenButton.setPreferredSize(new Dimension(250, 40));
        OpenButton.setToolTipText("Open Dataset");

        //Open database button actionListener
        OpenButton.addActionListener(new java.awt.event.ActionListener() {
                                         public void actionPerformed(ActionEvent e) {
                                             OpenButton_actionPerformed(e);
                                         }
                                     }
                                    );

        //Help Button
        ImageIcon HelpImage = new ImageIcon("help1.gif");
        HelpButton = new JButton();
        HelpButton.setIcon(HelpImage);
        HelpButton.setText("Readme");
        HelpButton.setBorder(null);
        HelpButton.setMaximumSize(new Dimension(200, 30));
        HelpButton.setPreferredSize(new Dimension(250, 40));
        HelpButton.setToolTipText("Read Me");

        //Help Button actionListener
        HelpButton.addActionListener(new java.awt.event.ActionListener() {
                                         public void actionPerformed(ActionEvent e) {
                                             HelpButton_actionPerformed(e);
                                         }
                                     }
                                    );

        //Exit button
        ImageIcon ExitImage = new ImageIcon("exit.gif");
        ExitButton= new JButton();
        ExitButton.setIcon(ExitImage);
        ExitButton.setText("Exit");
        ExitButton.setBorder(null);
        ExitButton.setMaximumSize(new Dimension(200, 30));
        ExitButton.setPreferredSize(new Dimension(250, 40));
        ExitButton.setToolTipText("Exit Genome Comparison Tool");

        //Exit Button actionListener
        ExitButton.addActionListener(new java.awt.event.ActionListener() {
                                         public void actionPerformed(ActionEvent e) {
                                             ExitButton_actionPerformed(e);
                                         }
                                     }
                                    );

        //Overview button
        ImageIcon OverviewImage = new ImageIcon("overview.gif");
        OverviewButton = new JButton();
        OverviewButton.setIcon(OverviewImage);
        OverviewButton.setText("Overview");
        OverviewButton.setBorder(null);
        OverviewButton.setMaximumSize(new Dimension(150, 30));
        OverviewButton.setPreferredSize(new Dimension(250, 40));
        OverviewButton.setToolTipText("Overview of the system");

        //Help Button actionListener
        OverviewButton.addActionListener(new java.awt.event.ActionListener() {
                                             public void actionPerformed(ActionEvent e) {
                                                 OverviewButton_actionPerformed(e);
                                             }
                                         }
                                        );

        ImageIcon InterfaceImage = new ImageIcon("interface.gif");
        InterfaceButton = new JButton();
        InterfaceButton.setIcon(InterfaceImage);
        InterfaceButton.setText("Interface Description");
        InterfaceButton.setBorder(null);
        InterfaceButton.setMaximumSize(new Dimension(200, 40));
        InterfaceButton.setPreferredSize(new Dimension(250, 40));
        InterfaceButton.setToolTipText("Interface Description");

        //Help Button actionListener
        InterfaceButton.addActionListener(new java.awt.event.ActionListener() {
                                              public void actionPerformed(ActionEvent e) {
                                                  InterfaceButton_actionPerformed(e);
                                              }
                                          }
                                         );
       //System.out.println(" here ");
        JToolBar MenuTool = new JToolBar();

        MenuTool.add(OpenButton);
        MenuTool.add(HelpButton);
        MenuTool.add(InterfaceButton);
        MenuTool.add(OverviewButton);
        MenuTool.add(ExitButton);


        //add the ToolBar to the north of contentPane
        contentPane.add(MenuTool, BorderLayout.NORTH);


        //***********************************************************************


        //add the whole Panel to the center of the contentPane
        WholePanel.setLayout(new GridBagLayout());
        contentPane.add(WholePanel, BorderLayout.CENTER);


        //************************************************************************
        //DisplayPanel for graphics of the database
        DisplayPanel.setBorder(BorderFactory.createEtchedBorder());
        DisplayPanel.setLayout(new BorderLayout());
        scrollPaneDisplayPanel= new JScrollPane(DisplayPanel,
                                     JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                     JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);



        //************************************************************************

        //for displaying dataset
        DataPanel.setBackground(Color.white);
        DataPanel.setBorder(BorderFactory.createEtchedBorder());
        DataPanel.setMinimumSize(new Dimension(10, 10));
        DataPanel.setPreferredSize(new Dimension(10, 10));
        DataPanel.setMaximumSize(new Dimension(screenSize.width, dataPanelHeight));
        scrollPaneDataPanel= new JScrollPane(DataPanel,
                                     JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                     JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);



        //************************************************************************


        BottomPanel = new JPanel();
        BottomPanel.setBorder(BorderFactory.createEtchedBorder());
        BottomPanel.setMinimumSize(new Dimension(5, 5));
        BottomPanel.setPreferredSize(new Dimension(screenSize.width,((int)(0.4*(screenSize.height)))));
        BottomPanel.setLayout(new GridBagLayout());
        scrollPaneBotPanel = new JScrollPane(BottomPanel);

        //*************************************************************************
         
        //Panel for table name list
        TableNamePanel = new JPanel();
        TableNamePanel.setMinimumSize(new Dimension(5,2));
        TableNamePanel.setPreferredSize(new Dimension(10,2));
        TableNamePanel.setLayout(new GridBagLayout());

        //Label for DataSet
        DataSetLabel = new JLabel();
        DataSetLabel.setHorizontalAlignment(SwingConstants.LEFT);
        DataSetLabel.setText("Dataset");

        
        //Icon for the arrow
        IconLabel1 = new JLabel();
        //System.out.println("here 1");
        //IconLabel1.setIcon(new ImageIcon("cy_r_arr.gif"));
        IconLabel1.setMaximumSize(new Dimension(10, 27));
        IconLabel1.setPreferredSize(new Dimension(10, 27));



        /* add Table_Name to the TableList*/
        JList TableList = new JList();
        DatabaseTableName Table_Name=new DatabaseTableName();

        Vector words1=Table_Name.getTableName();
        TableList = new JList(words1);
        JScrollPane scrollPane1 = new JScrollPane(TableList);
        TableList.setBackground(Color.lightGray);
        TableList.setBorder(BorderFactory.createLoweredBevelBorder());
        TableList.setToolTipText("Click the table to display the attributes in the table");

        //the actionListener for the Table list
        TableList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
                                               public void valueChanged(ListSelectionEvent e) {
                                                   TableList_valueChanged(e);
                                               }
                                           }
                                          );

        //add Labels and list to the Panel
        TableNamePanel.add(DataSetLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 10), 0, 0));

        TableNamePanel.add(scrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), 0, 0));

        //************************************************************************************


        //Panel for attribute list
        AttributPanel = new JPanel();
        AttributPanel.setPreferredSize(new Dimension(10,2));
        AttributPanel.setMinimumSize(new Dimension(5,2));
        AttributPanel.setLayout(new GridBagLayout());

        //Label for attribute
        JLabel AttributeLabel = new JLabel();
        AttributeLabel.setHorizontalAlignment(SwingConstants.LEFT);
        AttributeLabel.setText("Features");

        //Icon for arrow
        JLabel IconLabel2 = new JLabel();
        //System.out.println("here 11");
        //IconLabel2.setIcon(new ImageIcon("cy_r_arr.gif"));
        IconLabel2.setMaximumSize(new Dimension(100, 27));
        IconLabel2.setPreferredSize(new Dimension(100, 27));



        /* add Column_Name to the AttributeList*/

        scrollPaneAttributeList = new JScrollPane(AttributeList);
        AttributeList.setBackground(Color.lightGray);
        AttributeList.setBorder(BorderFactory.createLoweredBevelBorder());
        AttributeList.setToolTipText("Select the feature you want to display to show all the different values for that feature" );


        AttributeList.addMouseListener(new javax.swing.event.MouseInputAdapter() {
                                           public void mouseClicked(MouseEvent m) {
                                               AttributeList_valueChangedMouseClick(m);
                                           }
                                       }
                                      );
        
        //add Labels and list to the Panel
        AttributPanel.add(AttributeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 10, 10), 0, 0));
        AttributPanel.add(scrollPaneAttributeList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0,GridBagConstraints.SOUTHEAST, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), 0, 0));

        //*****************************************************************************************

        //Panel for Jtable and buttons
        ColorShapePanel = new JPanel();
        ColorShapePanel.setLayout(new GridBagLayout());
        ColorShapePanel.setMinimumSize(new Dimension(5,5));
        //Panel for ColorShape Table
        TablePanel = new JPanel();
        TablePanel.setLayout(new GridBagLayout());
        //Label for the Color and Shape table
        JLabel ColorShapeLabel = new JLabel();
        ColorShapeLabel.setHorizontalAlignment(SwingConstants.LEFT);
        ColorShapeLabel.setText("Color and shape");
        /* add the color JTable using defaultTableModel*/
        TableModel Color_Table=new ColorTableModel(columnNames,0);
        ColorTable=new JTable(Color_Table);
        ColorTable.setBackground(Color.lightGray);
        ColorTable.setBorder(BorderFactory.createLoweredBevelBorder());
        ColorTable.setToolTipText("Click the color column to select color, and click shape column to select shape");
        ColorTable.setRowSelectionAllowed(true);
        ColorTable.setSelectionBackground(Color.blue);
        ColorTable.clearSelection();

        // set up default renderers and editors
        ColorTable.setDefaultRenderer(Color.class, new ColorTableCellRenderer());

        ColorTable.setDefaultEditor(Color.class,
                                    new ColorTableCellEditor());

        // set up the combo box for the Shape
        shapeCombo = new JComboBox();
        //System.out.println("here 111");
        //use the customer Icon Image
        Icon blank = new blank();
        Icon Shape1 = new Shape1();
        Icon Shape2 = new Shape2();
        Icon Shape3 = new Shape3();
        Icon Shape4 = new Shape4();
       
        //add the Icons to the JComboBox
        shapeCombo.addItem(blank);
        shapeCombo.addItem(Shape1);
        shapeCombo.addItem(Shape2);
        shapeCombo.addItem(Shape3);
        shapeCombo.addItem(Shape4);

        //init the Color Shape Table
        columnModel = ColorTable.getColumnModel();
        shapeColumn = columnModel.getColumn(4);
        //set up the default celleditor for combobox
        shapeColumn.setCellEditor(new DefaultCellEditor(shapeCombo));
        scrollPaneColorTable = new JScrollPane(ColorTable);
        //add the label to TablePanel
        TablePanel.add(ColorShapeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                       ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

        //add the table to the TablePanel
        TablePanel.add(scrollPaneColorTable, new GridBagConstraints(0, 1, 2, 2, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        //add the TablePanel to the ColorShapePanel
        ColorShapePanel.add(TablePanel, new GridBagConstraints(0, 0, 2, 2, 1.0, 1.0
                            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        //**************************************************************************************
        
        //Panel for Jtable and buttons
        PreGeneColorShapePanel = new JPanel();
        PreGeneColorShapePanel.setLayout(new GridBagLayout());
        PreGeneColorShapePanel.setMinimumSize(new Dimension(5, 5));
        JPanel PreGeneTablePanel = new JPanel();
        PreGeneTablePanel.setLayout(new GridBagLayout());

        //Label for the Color and Shape table
        JLabel PreGeneColorShapeLabel = new JLabel();
        PreGeneColorShapeLabel.setHorizontalAlignment(SwingConstants.LEFT);
        PreGeneColorShapeLabel.setText("Color and shape for upstream region");


        /* add the color JTable using defaultTableModel */
        PreGeneColor_Table=new ColorTableModel(columnNames,0);
        PreGeneColorTable=new JTable(PreGeneColor_Table);
        PreGeneColorTable.setBackground(Color.lightGray);
        PreGeneColorTable.setBorder(BorderFactory.createLoweredBevelBorder());
        PreGeneColorTable.setToolTipText("Click the color column to select color, and click shape column to select shape For PreGene information");
        PreGeneColorTable.setRowSelectionAllowed(true);
        PreGeneColorTable.setSelectionBackground(Color.blue);
        PreGeneColorTable.clearSelection();

        // set up default renderers and editors
        PreGeneColorTable.setDefaultRenderer(Color.class,new ColorTableCellRenderer());

        PreGeneColorTable.setDefaultEditor(Color.class,new ColorTableCellEditor());

        // set up the combo box for the Shape
        PreGeneshapeCombo = new JComboBox();

        //use the customer Icon Image
        Icon PreGeneblank = new blank();
        Icon PreGeneShape1 = new Shape1();
        Icon PreGeneShape2 = new Shape2();
        Icon PreGeneShape3 = new Shape3();
        Icon PreGeneShape4 = new Shape4();

        //add the Icons to the JComboBox
        PreGeneshapeCombo.addItem(PreGeneblank);
        PreGeneshapeCombo.addItem(PreGeneShape1);
        PreGeneshapeCombo.addItem(PreGeneShape2);
        PreGeneshapeCombo.addItem(PreGeneShape3);
        PreGeneshapeCombo.addItem(PreGeneShape4);

        //init the Color Shape Table
        PreGenecolumnModel = PreGeneColorTable.getColumnModel();
        PreGeneshapeColumn  = PreGenecolumnModel.getColumn(4);

        //set up the default celleditor for combobox
        PreGeneshapeColumn.setCellEditor(new DefaultCellEditor(PreGeneshapeCombo));

        PreGenescrollPane3 = new JScrollPane(PreGeneColorTable);

        //add the label to TablePanel
        PreGeneTablePanel.add(PreGeneColorShapeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

        //add the table to the TablePanel
        PreGeneTablePanel.add(PreGenescrollPane3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        //add the TablePanel to the ColorShapePanel
        PreGeneColorShapePanel.add(PreGeneTablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        //********************************************************************************

        //Panel for Jtable and buttons
        PostGeneColorShapePanel = new JPanel();
        PostGeneColorShapePanel.setLayout(new GridBagLayout());
        PostGeneColorShapePanel.setMinimumSize(new Dimension(5, 5));
        //Panel for ColorShape Table
        JPanel PostGeneTablePanel = new JPanel();
        PostGeneTablePanel.setLayout(new GridBagLayout());

        //Label for the Color and Shape table
        JLabel PostGeneColorShapeLabel = new JLabel();
        PostGeneColorShapeLabel.setHorizontalAlignment(SwingConstants.LEFT);
        PostGeneColorShapeLabel.setText("Color and shape for downstream region");

        /* add the color JTable using defaultTableModel*/

        PostGeneColor_Table=new ColorTableModel(columnNames,0);
        PostGeneColorTable=new JTable(PostGeneColor_Table);
        PostGeneColorTable.setBackground(Color.lightGray);
        PostGeneColorTable.setBorder(BorderFactory.createLoweredBevelBorder());
        PostGeneColorTable.setToolTipText("Click the color column to select color, and click shape column to select shape for post gene information");
        PostGeneColorTable.setRowSelectionAllowed(true);
        PostGeneColorTable.setSelectionBackground(Color.blue);
        PostGeneColorTable.clearSelection();

        // set up default renderers and editors
        PostGeneColorTable.setDefaultRenderer(Color.class, new ColorTableCellRenderer());

        PostGeneColorTable.setDefaultEditor(Color.class, new ColorTableCellEditor());

        // set up the combo box for the Shape

        PostGeneshapeCombo = new JComboBox();

        //use the customer Icon Image
        Icon PostGeneblank = new blank();
        Icon PostGeneShape1 = new Shape1();
        Icon PostGeneShape2 = new Shape2();
        Icon PostGeneShape3 = new Shape3();
        Icon PostGeneShape4 = new Shape4();

        //add the Icons to the JComboBox
        PostGeneshapeCombo.addItem(PostGeneblank);
        PostGeneshapeCombo.addItem(PostGeneShape1);
        PostGeneshapeCombo.addItem(PostGeneShape2);
        PostGeneshapeCombo.addItem(PostGeneShape3);
        PostGeneshapeCombo.addItem(PostGeneShape4);

        //init the Color Shape Table
        PostGenecolumnModel = PostGeneColorTable.getColumnModel();
        PostGeneshapeColumn = PostGenecolumnModel.getColumn(4);

        //set up the default celleditor for combobox
        PostGeneshapeColumn.setCellEditor(new DefaultCellEditor(PostGeneshapeCombo));

        scrollPanePostGene = new JScrollPane(PostGeneColorTable);

        PostGeneTablePanel.add(PostGeneColorShapeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                               ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

        PostGeneTablePanel.add(scrollPanePostGene, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
                               ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        PostGeneColorShapePanel.add(PostGeneTablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
                                    ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        //***********************************************************************************
       
        createButtonPanel();
        //add the buttonPanel to the ColorShape Panel
        ColorShapePanel.add(ButtonPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0
                            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), -190, 0));
        //*************************************************************************
            
        createpgButtonPanel(); 
        //add the buttonPanel to the ColorShape Panel
        PreGeneColorShapePanel.add(pgButtonPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0
                                   ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), -100, 0));
        //************************************************************************************
        
        createButtonPanelpg();
        //add the buttonPanel to the ColorShape Panel
        PostGeneColorShapePanel.add(ButtonPanelpg, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0
                                    ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        //*************************************************************************************
        
        WholePanel.add(scrollPaneDisplayPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), (12*screenSize.width)/10, screenSize.height/2));
        WholePanel.add(scrollPaneDataPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 2, 0, 2), screenSize.width/8, screenSize.height/8));
        createBottomPanel(); 
        WholePanel.add(scrollPaneBotPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), screenSize.width/8,screenSize.height/8));
        //System.out.println("here 1v");
    }
private void createButtonPanel() { 
       //Panel for buttons
        ButtonPanel = new JPanel();

        // Cancel button
        CancelButton = new JButton();//Cancel
        CancelButton.setFont(new java.awt.Font("Dialog", 0, 10));
        CancelButton.setMaximumSize(new Dimension(71, 25));
        CancelButton.setMinimumSize(new Dimension(71, 27));
        CancelButton.setPreferredSize(new Dimension(71, 27));
        CancelButton.setText("Cancel");
        CancelButton.setEnabled(false);

        //the actionListener for the cancelbutton
        CancelButton.addActionListener(new java.awt.event.ActionListener() {
                                           public void actionPerformed(ActionEvent e) {
                                               CancelButton_actionPerformed(e);
                                           }
                                       }
                                      );

        //delete button
        DeleteButton = new JButton();//delete
        DeleteButton.setFont(new java.awt.Font("Dialog", 0, 10));
        DeleteButton.setMaximumSize(new Dimension(71, 25));
        DeleteButton.setMinimumSize(new Dimension(71, 25));
        DeleteButton.setPreferredSize(new Dimension(71, 25));
        DeleteButton.setText("Delete");
        DeleteButton.setEnabled(false);

        //the actionListener for the deletebutton
        DeleteButton.addActionListener(new java.awt.event.ActionListener() {
                                           public void actionPerformed(ActionEvent e) {
                                               DeleteButton_actionPerformed(e);
                                           }
                                       }
                                      );


        // display button
        DisplayButton = new JButton();//display
        DisplayButton.setFont(new java.awt.Font("Dialog", 0, 10));
        DisplayButton.setPreferredSize(new Dimension(71, 25));
        DisplayButton.setText("Display");
        DisplayButton.setEnabled(false);
        //the actionListener for the displaybutton
        DisplayButton.addActionListener(new java.awt.event.ActionListener() {
                                            public void actionPerformed(ActionEvent e) {
                                                DisplayButton_actionPerformed(e);
                                            }
                                        }
                                       );
        rbutton =  new JCheckBox("Dirns");
        rbutton.setSelected(true);
        rbutton.addActionListener(
            new java.awt.event.ActionListener() {
                public void actionPerformed(ActionEvent a) {
                    if (dirFlag==0)
                        dirFlag=1;
                    else
                        dirFlag=0;
                }
            }
        );
        rbutton.setEnabled(false);

        // button for demarcation
        demarcateButton =  new JCheckBox("Upstream and Downstream Display");
        demarcateButton.setSelected(false);
        demarcateButton.addActionListener(
            new java.awt.event.ActionListener() {
                public void actionPerformed(ActionEvent a) {
                    if (gridFlag==0)
                    {
                        gridFlag=1;
                        redrawBottomPanel();
                    }
                    else
                    {
                        gridFlag=0;
                        redrawBottomPanel();
                    }
                }
            }
        );
        demarcateButton.setEnabled(false);

        //add the buttons to the button Panel
        ButtonPanel.setLayout(new BoxLayout(ButtonPanel,BoxLayout.Y_AXIS));
        JPanel buttontemppanel = new JPanel();
        buttontemppanel.add(CancelButton, null);
        buttontemppanel.add(DeleteButton, null);
        buttontemppanel.add(DisplayButton, null);
        JPanel tempPanel = new JPanel();
        tempPanel.add(rbutton, null);
        tempPanel.add(demarcateButton, null);
        ButtonPanel.add(buttontemppanel, null);
        ButtonPanel.add(tempPanel, null);        
       }
    
private void createpgButtonPanel() {
        //Panel for buttons
        pgButtonPanel = new JPanel();


        // Cancel button
        pgCancelButton = new JButton();//Cancel
        pgCancelButton.setFont(new java.awt.Font("Dialog", 0, 10));
        pgCancelButton.setMaximumSize(new Dimension(71, 25));
        pgCancelButton.setMinimumSize(new Dimension(71, 27));
        pgCancelButton.setPreferredSize(new Dimension(71, 27));
        pgCancelButton.setText("Cancel");
        pgCancelButton.setEnabled(false);

        //the actionListener for the cancelbutton
        pgCancelButton.addActionListener(new java.awt.event.ActionListener() {
                                             public void actionPerformed(ActionEvent e) {
                                                 pgCancelButton_actionPerformed(e);
                                             }
                                         }
                                        );


        //delete button
        pgDeleteButton = new JButton();
        pgDeleteButton.setFont(new java.awt.Font("Dialog", 0, 10));
        pgDeleteButton.setMaximumSize(new Dimension(71, 25));
        pgDeleteButton.setMinimumSize(new Dimension(71, 25));
        pgDeleteButton.setPreferredSize(new Dimension(71, 25));
        pgDeleteButton.setText("Delete");
        pgDeleteButton.setEnabled(false);

        //the actionListener for the deletebutton
        pgDeleteButton.addActionListener(new java.awt.event.ActionListener() {
                                             public void actionPerformed(ActionEvent e) {
                                                 pgDeleteButton_actionPerformed(e);
                                             }
                                         }
                                        );


        // display button
        pgDisplayButton = new JButton();//display
        pgDisplayButton.setFont(new java.awt.Font("Dialog", 0, 10));
        pgDisplayButton.setPreferredSize(new Dimension(71, 25));
        pgDisplayButton.setText("Display");
        pgDisplayButton.setEnabled(false);
        //the actionListener for the displaybutton
        pgDisplayButton.addActionListener(new java.awt.event.ActionListener() {
                                              public void actionPerformed(ActionEvent e) {
                                                  pgDisplayButton_actionPerformed(e);
                                              }
                                          }
                                         );

        //add the buttons to the button Panel
        pgButtonPanel.add(pgCancelButton, null);
        pgButtonPanel.add(pgDeleteButton, null);
        pgButtonPanel.add(pgDisplayButton, null);
    }
    //*****************************************************************************
 private void createButtonPanelpg() {
        //Panel for buttons
        ButtonPanelpg = new JPanel();

        // Cancel button
        CancelButtonpg = new JButton();
        CancelButtonpg.setFont(new java.awt.Font("Dialog", 0, 10));
        CancelButtonpg.setMaximumSize(new Dimension(71, 25));
        CancelButtonpg.setMinimumSize(new Dimension(71, 27));
        CancelButtonpg.setPreferredSize(new Dimension(71, 27));
        CancelButtonpg.setText("Cancel");
        CancelButtonpg.setEnabled(false);

        //the actionListener for the cancelbutton
        CancelButtonpg.addActionListener(new java.awt.event.ActionListener() {
                                             public void actionPerformed(ActionEvent e) {
                                                 CancelButtonpg_actionPerformed(e);
                                             }
                                         }
                                        );


        //delete button
        DeleteButtonpg = new JButton();
        DeleteButtonpg.setFont(new java.awt.Font("Dialog", 0, 10));
        DeleteButtonpg.setMaximumSize(new Dimension(71, 25));
        DeleteButtonpg.setMinimumSize(new Dimension(71, 25));
        DeleteButtonpg.setPreferredSize(new Dimension(71, 25));
        DeleteButtonpg.setText("Delete");
        DeleteButtonpg.setEnabled(false);

        //the actionListener for the deletebutton
        DeleteButtonpg.addActionListener(new java.awt.event.ActionListener() {
                                             public void actionPerformed(ActionEvent e) {
                                                 DeleteButtonpg_actionPerformed(e);
                                             }
                                         }
                                        );


        // display button
        DisplayButtonpg = new JButton();
        DisplayButtonpg.setFont(new java.awt.Font("Dialog", 0, 10));
        DisplayButtonpg.setPreferredSize(new Dimension(71, 25));
        DisplayButtonpg.setText("Display");
        DisplayButtonpg.setEnabled(false);
        //the actionListener for the displaybutton
        DisplayButtonpg.addActionListener(new java.awt.event.ActionListener() {
                                              public void actionPerformed(ActionEvent e) {
                                                  DisplayButtonpg_actionPerformed(e);
                                              }
                                          }
                                         );

        //add the buttons to the button Panel
        ButtonPanelpg.add(CancelButtonpg, null);
        ButtonPanelpg.add(DeleteButtonpg, null);
        ButtonPanelpg.add(DisplayButtonpg, null);
      
        }
    
    /* when close the window, close the database connection*/
    /**
     * process window events
     * @param e Window Event
     */
    public void createBottomPanel()
    {
        // add the three Panels to the Bottom Panel
        BottomPanel.add(TableNamePanel, new GridBagConstraints(0, 0, 1, 24, 0.25, 0.5
                        ,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0),0);
        BottomPanel.add(AttributPanel, new GridBagConstraints(1, 0, 1, 24, 0.25, 0.5
                        ,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0),1);
        
       // System.out.println("Before the gridbag thingee");   
        if(gridFlag == 1) { 
       // System.out.println("inside gridflag = 1 ");
       // System.out.println("Number of components in ButtonPanel beginning " + ButtonPanel.getComponentCount());
        BottomPanel.add(PreGeneColorShapePanel, new GridBagConstraints(2, 0, 2, 2, 1.0, 3.0
                        ,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), 10, 10),2);
             
        BottomPanel.add(ColorShapePanel, new GridBagConstraints(2, 3, 2, 2, 1.0, 3.0
                        ,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), 20, 10),3);
       
        BottomPanel.add(PostGeneColorShapePanel, new GridBagConstraints(2, 6, 2, 2, 1.0, 3.0
                        ,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), 30, 10),4);
        } else {
       // System.out.println("Number of components in ButtonPanel end " + ButtonPanel.getComponentCount());
        //System.out.println("inside gridflag = 0 ");
       // System.out.println("Number of components in ButtonPanel " + ButtonPanel.getComponentCount());
        BottomPanel.add(ColorShapePanel, new GridBagConstraints(2, 0, 2, 2, 1.0, 3.0
                       ,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), 20, 10));
        }
       
    }
    public void redrawBottomPanel()
    {
        WholePanel.remove(scrollPaneBotPanel);
        if(gridFlag == 1) { 
       // System.out.println("inside gridflag = 1 ");
        //System.out.println("Number of components in ButtonPanel beginning " + ButtonPanel.getComponentCount());
        BottomPanel.add(PreGeneColorShapePanel, new GridBagConstraints(2, 0, 2, 2, 1.0, 3.0
                        ,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), 10, 10),2);
             
        BottomPanel.add(ColorShapePanel, new GridBagConstraints(2, 3, 2, 2, 1.0, 3.0
                        ,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), 20, 10),3);
       
        BottomPanel.add(PostGeneColorShapePanel, new GridBagConstraints(2, 6, 2, 2, 1.0, 3.0
                        ,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), 30, 10),4);
        } else {
        //System.out.println("Number of components in ButtonPanel " + ButtonPanel.getComponentCount());
        //System.out.println("inside gridflag = 0 ");
        if(BottomPanel.getComponentCount()==5) {
        BottomPanel.remove(PreGeneColorShapePanel);
        BottomPanel.remove(PostGeneColorShapePanel);
        }
        BottomPanel.add(ColorShapePanel, new GridBagConstraints(2, 0, 2, 2, 1.0, 3.0
                       ,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 10, 10), 20, 10));
        }
         WholePanel.add(scrollPaneBotPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), screenSize.width/8,screenSize.height/8));
         WholePanel.validate();
    }
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {

            DatabaseConnection connection=DatabaseConnection.getInstance();
            connection.Close_Database();
            System.exit(0);
        }
    }


    //******************************************************************************

    /* ActionListener for TableList*/
    void TableList_valueChanged(ListSelectionEvent evt) {

        DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();
        DefaultTableModel pgModel = (DefaultTableModel)PreGeneColorTable.getModel();
        DefaultTableModel Modelpg = (DefaultTableModel)PostGeneColorTable.getModel();
        //remove all the rows in the table when user select cancel
        model.setNumRows(0);
        pgModel.setNumRows(0);
        Modelpg.setNumRows(0);
        DisplayButton.setEnabled(false);
        CancelButton.setEnabled(false);
        DeleteButton.setEnabled(false);
        DisplayButtonpg.setEnabled(false);
        pgDisplayButton.setEnabled(false);
        pgCancelButton.setEnabled(false);
        CancelButtonpg.setEnabled(false);
        DeleteButtonpg.setEnabled(false);
        pgDeleteButton.setEnabled(false);
        rbutton.setEnabled(false);
        demarcateButton.setEnabled(false);
        demarcateButton.setSelected(false);
        dirFlag=1;
        totalGenesToDisplay=-1;
        //remove the old panel
        WholePanel.remove(scrollPaneDisplayPanel);
        //DisplayPanel for graphics of the database
        DisplayPanel.setLayout(new BorderLayout());
        scrollPaneDisplayPanel= new JScrollPane(DisplayPanel,
                                     JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                     JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        WholePanel.add(scrollPaneDisplayPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 0, 2), tempWidth,tempHt ));


        DataPanel.setBackground(Color.white);
        DataPanel.setBorder(BorderFactory.createEtchedBorder());
        DataPanel.setMinimumSize(new Dimension(10, 10));
        DataPanel.setPreferredSize(new Dimension(10, 10));
        DataPanel.setMaximumSize(new Dimension(screenSize.width, dataPanelHeight));
        scrollPaneDataPanel= new JScrollPane(DataPanel,
                                     JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                     JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        WholePanel.add(scrollPaneDataPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 2, 0, 2), 659, 5));


        WholePanel.validate();

        //init the FilteredAttribute to get the column name
        //which has less than 20 distinct values
        TableFilteredAttribute FilteredAttribute=new TableFilteredAttribute(evt, AttributeList);
        //get the table name which selected by the user
        Table_Name=FilteredAttribute.getTableName();
        sizeNonWhiteVals=0;
        sizeNonWhiteUniqueAttributes=0;
        sizePreGeneNonWhiteVals=0;
        sizePreGeneNonWhiteUniqueAttributes=0;
        sizePostGeneNonWhiteVals=0;
        sizePostGeneNonWhiteUniqueAttributes=0;
        disabledFlag=0;
        preGenedisabledFlag=0;
        postGenedisabledFlag=0;
        nonWhiteVals=null;
        preGenenonWhiteVals=null;
        postGenenonWhiteVals=null;
        uniqueAttributesNonWhite=null;
        uniqueAttributespreGeneNonWhite=null;
        uniqueAttributespostGeneNonWhite=null;
        if(zoomclasses!=null) {
            for(int counter=0;counter<zoomclasses.length;counter++) {
                if(zoomclasses[counter]!=null) {
                    zoomclasses[counter].setVisible(false);
                    zoomclasses[counter].dispose();
                }
            }
        }
    }


    //*******************************************************************************

    /* ActionListener for the Attribute List*/

    void AttributeList_valueChanged(ListSelectionEvent evt) {
        //add the column name and value which user selected to the Color Shape table
        AttributeSelection Attribute=new AttributeSelection(evt, ColorTable, PreGeneColorTable, PostGeneColorTable, Table_Name);
        DeleteButton.setEnabled(true);
        CancelButton.setEnabled(true);
        DeleteButtonpg.setEnabled(true);
        CancelButtonpg.setEnabled(true);
        pgDeleteButton.setEnabled(true);
        pgCancelButton.setEnabled(true);
        rbutton.setEnabled(true);
        demarcateButton.setEnabled(true);
    }


    //********************************************************************************
    /* ActionListener for the Attribute List*/

    void AttributeList_valueChangedMouseClick(MouseEvent evt) {
        //add the column name and value which user selected to the Color Shape table
        AttributeSelection Attribute=new AttributeSelection(evt, ColorTable,PreGeneColorTable, PostGeneColorTable, Table_Name);
        if (DeleteButton.isEnabled() == false)
            DeleteButton.setEnabled(true);
        if(CancelButton.isEnabled() == false)
            CancelButton.setEnabled(true);
        if(DisplayButton.isEnabled() == false)
            DisplayButton.setEnabled(true);

        if (DeleteButtonpg.isEnabled() == false)
            DeleteButtonpg.setEnabled(true);
        if(CancelButtonpg.isEnabled() == false)
            CancelButtonpg.setEnabled(true);
        if(DisplayButtonpg.isEnabled() == false)
            DisplayButtonpg.setEnabled(true);

        if (pgDeleteButton.isEnabled() == false)
            pgDeleteButton.setEnabled(true);
        if(pgCancelButton.isEnabled() == false)
            pgCancelButton.setEnabled(true);
        if(pgDisplayButton.isEnabled() == false)
            pgDisplayButton.setEnabled(true);
        if(rbutton.isEnabled() == false)
            rbutton.setEnabled(true);
        if(demarcateButton.isEnabled() == false)
            demarcateButton.setEnabled(true);
    }

    //CancelButton actionlistener
    void CancelButton_actionPerformed(ActionEvent e) {


        DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();
        DefaultTableModel modelpg = (DefaultTableModel)PostGeneColorTable.getModel();
        DefaultTableModel pgmodel = (DefaultTableModel)PreGeneColorTable.getModel();
        //remove all the rows in the table when user select cancel
        model.setNumRows(0);
        modelpg.setNumRows(0);
        pgmodel.setNumRows(0);
        DeleteButton.setEnabled(false);
        DisplayButton.setEnabled(false);
        CancelButton.setEnabled(false);
        DeleteButtonpg.setEnabled(false);
        DisplayButtonpg.setEnabled(false);
        CancelButtonpg.setEnabled(false);
        pgDeleteButton.setEnabled(false);
        pgDisplayButton.setEnabled(false);
        pgCancelButton.setEnabled(false);
        rbutton.setEnabled(false);
        demarcateButton.setEnabled(false);
        //remove the old panel
        WholePanel.remove(scrollPaneDataPanel);
        WholePanel.remove(scrollPaneDisplayPanel);
        //DisplayPanel for graphics of the database
        DisplayPanel.setLayout(new BorderLayout());
        DataPanel.setBackground(Color.white);
        DataPanel.setBorder(BorderFactory.createEtchedBorder());
        DataPanel.setMinimumSize(new Dimension(10, 10));
        DataPanel.setPreferredSize(new Dimension(10, 10));
        DataPanel.setMaximumSize(new Dimension(screenSize.width, dataPanelHeight));

        scrollPaneDataPanel= new JScrollPane(DataPanel,
                                     JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                     JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);

        scrollPaneDisplayPanel= new JScrollPane(DisplayPanel,
                                     JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                     JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        WholePanel.add(scrollPaneDisplayPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 0, 2), tempWidth,tempHt ));
        WholePanel.add(scrollPaneDataPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 2, 0, 2), 659, 5));
        WholePanel.validate();
    }

    void CancelButtonpg_actionPerformed(ActionEvent e) {


        DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();
        DefaultTableModel modelpg = (DefaultTableModel)PostGeneColorTable.getModel();
        DefaultTableModel pgmodel = (DefaultTableModel)PreGeneColorTable.getModel();
        //remove all the rows in the table when user select cancel
        model.setNumRows(0);
        modelpg.setNumRows(0);
        pgmodel.setNumRows(0);
        DeleteButton.setEnabled(false);
        DisplayButton.setEnabled(false);
        CancelButton.setEnabled(false);
        DeleteButtonpg.setEnabled(false);
        DisplayButtonpg.setEnabled(false);
        CancelButtonpg.setEnabled(false);
        pgDeleteButton.setEnabled(false);
        pgDisplayButton.setEnabled(false);
        pgCancelButton.setEnabled(false);
        rbutton.setEnabled(false);
        demarcateButton.setEnabled(false);
        WholePanel.remove(scrollPaneDisplayPanel);
        //DisplayPanel for graphics of the database
        DisplayPanel.setLayout(new BorderLayout());
        scrollPaneDisplayPanel= new JScrollPane(DisplayPanel,
                                     JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                     JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        WholePanel.add(scrollPaneDisplayPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 0, 2), tempWidth,tempHt ));

        WholePanel.validate();
    }
    //**********************************************************************************

    void pgCancelButton_actionPerformed(ActionEvent e) {

        DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();
        DefaultTableModel modelpg = (DefaultTableModel)PostGeneColorTable.getModel();
        DefaultTableModel pgmodel = (DefaultTableModel)PreGeneColorTable.getModel();
        //remove all the rows in the table when user select cancel
        model.setNumRows(0);
        modelpg.setNumRows(0);
        pgmodel.setNumRows(0);
        DeleteButton.setEnabled(false);
        DisplayButton.setEnabled(false);
        CancelButton.setEnabled(false);
        DeleteButtonpg.setEnabled(false);
        DisplayButtonpg.setEnabled(false);
        CancelButtonpg.setEnabled(false);
        pgDeleteButton.setEnabled(false);
        pgDisplayButton.setEnabled(false);
        pgCancelButton.setEnabled(false);
        rbutton.setEnabled(false);
        demarcateButton.setEnabled(false);
        WholePanel.remove(scrollPaneDisplayPanel);
        //DisplayPanel for graphics of the database
        DisplayPanel.setLayout(new BorderLayout());
        scrollPaneDisplayPanel= new JScrollPane(DisplayPanel,
                                     JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                     JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        WholePanel.add(scrollPaneDisplayPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
                       ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 0, 2), tempWidth,tempHt ));

        WholePanel.validate();
    }
    //**********************************************************************************

    //DeleteButton actionlistner
    void DeleteButton_actionPerformed(ActionEvent e) {

        DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();
        // remove the most recently added rows
        int numberOfRows = ColorTable.getRowCount();
        String columnName =(String) model.getValueAt(numberOfRows-1,0);
        for (int i=numberOfRows-1;i>=0;i--) {
            if(((String)model.getValueAt(i,0)).equals(columnName)) {
                model.removeRow(i);
            }
        }
        numberOfRows = ColorTable.getRowCount();
        if(numberOfRows ==0) {
            DeleteButton.setEnabled(false);
            DisplayButton.setEnabled(false);
            CancelButton.setEnabled(false);
            rbutton.setEnabled(false);
            demarcateButton.setEnabled(false);
            //remove the old panel
            WholePanel.remove(scrollPaneDisplayPanel);
            //DisplayPanel for graphics of the database
            DisplayPanel.setBorder(BorderFactory.createEtchedBorder());
            DisplayPanel.setLayout(new BorderLayout());
            scrollPaneDisplayPanel= new JScrollPane(DisplayPanel,
                                         JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                         JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            WholePanel.add(scrollPaneDisplayPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
                           ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 0, 2), tempWidth,tempHt ));
            WholePanel.validate();
        }

    }


    //***********************************************************************************


    //DeleteButton actionlistner
    void DeleteButtonpg_actionPerformed(ActionEvent e) {

        DefaultTableModel model = (DefaultTableModel)PostGeneColorTable.getModel();
        // remove the most recently added rows
        int numberOfRows = PostGeneColorTable.getRowCount();
        String columnName =(String) model.getValueAt(numberOfRows-1,0);
        for (int i=numberOfRows-1;i>=0;i--) {
            if(((String)model.getValueAt(i,0)).equals(columnName)) {
                model.removeRow(i);
            }
        }
        numberOfRows = PostGeneColorTable.getRowCount();
        if(numberOfRows ==0) {
            DeleteButtonpg.setEnabled(false);
            DisplayButtonpg.setEnabled(false);
            CancelButtonpg.setEnabled(false);
            rbutton.setEnabled(false);
            demarcateButton.setEnabled(false);
            //remove the old panel
            WholePanel.validate();
        }

    }


    //***********************************************************************************
    //DeleteButton actionlistner
    void pgDeleteButton_actionPerformed(ActionEvent e) {


        DefaultTableModel model = (DefaultTableModel)PreGeneColorTable.getModel();
        // remove the most recently added rows
        int numberOfRows = PreGeneColorTable.getRowCount();
        String columnName =(String) model.getValueAt(numberOfRows-1,0);
        for (int i=numberOfRows-1;i>=0;i--) {
            if(((String)model.getValueAt(i,0)).equals(columnName)) {
                model.removeRow(i);
            }
        }
        numberOfRows = PreGeneColorTable.getRowCount();
        if(numberOfRows ==0) {
            pgDeleteButton.setEnabled(false);
            pgDisplayButton.setEnabled(false);
            pgCancelButton.setEnabled(false);
            rbutton.setEnabled(false);
            demarcateButton.setEnabled(false);
            WholePanel.validate();
        }
    }


    //***********************************************************************************
    //DisplayButton actionlistener
    void pgDisplayButton_actionPerformed(ActionEvent e) {
        DisplayButton_actionPerformed(e);
    }
    void DisplayButtonpg_actionPerformed(ActionEvent e) {
        DisplayButton_actionPerformed(e);
    }
    void DisplayButton_actionPerformed(ActionEvent e) {

        if(Table_Name !=null) {
            DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();
            DefaultTableModel preGeneModel = (DefaultTableModel)PreGeneColorTable.getModel();
            DefaultTableModel postGeneModel = (DefaultTableModel)PostGeneColorTable.getModel();
            //get the data in the color shape table
            Color_Data=model.getDataVector();
            PreGeneColor_Data =  preGeneModel.getDataVector();
            PostGeneColor_Data = postGeneModel.getDataVector();
            if(PreGeneColor_Data.size()==0) {
                JDialog jdialog = new JDialog(this," No attributes have been chosen for display",true);
                jdialog.setTitle("No attributes have been chosen for display");
            }
            //init the DatabaseVisualDisplay to use the Color_data
            //to fill the color or the shape of each rectangle
            finddirections();
            if(totalGenesToDisplay == -1) {
                String Query="select * from ["+Table_Name+"]";
                DatabaseRowNumber Num=new DatabaseRowNumber(Query);
                totalGenesToDisplay=Num.getRowNumber();
                if(totalGenesToDisplay > screenSize.width)
                    columns = (totalGenesToDisplay/screenSize.width)*10;
                else
                    columns =  (screenSize.width/totalGenesToDisplay)*10;
                
                if(columns < 60)
                    columns = columns * 2;
                if(columns > 80)
                    columns=80;                  
                
                columns = columns + (columns/2);
                
                    if(columns > 80)
                        columns=80;
                
                rows = totalGenesToDisplay/columns;
                
                widthOfCell = (int)(1.5*(screenSize.width))/columns;
                        
                heightOfCell = (int) (0.5 * widthOfCell);
                while((rows*heightOfCell) > 0.6*screenSize.height) {
                    heightOfCell = (int) (0.9 * heightOfCell);
                }
                while((columns*widthOfCell) >1.2 * screenSize.width) {
                    widthOfCell = (int) (0.95 * widthOfCell);
                }

            }
            Display=new DatabaseVisualDisplay(Table_Name,Color_Data, PreGeneColor_Data, PostGeneColor_Data, totalGenesToDisplay, displayOffX, displayOffY, rows, columns, widthOfCell, heightOfCell, directions, gridFlag);
            Display.setBackground(Color.white);

            //remove the old panel
            WholePanel.remove(scrollPaneDisplayPanel);

            //add the new DisplayPanel
            scrollPaneDisplayPanel = new JScrollPane(Display,
                                          JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                          JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);

            WholePanel.add(scrollPaneDisplayPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
                           ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(2, 2, 0, 2), tempWidth,tempHt ));

            //Mouse listener for the mouse click on the square
            Display.addMouseListener(new MouseAdapter() {
                                         public void mouseClicked(MouseEvent evt) {
                                             int x, y;
                                             x = evt.getX();
                                             y = evt.getY();
                                             current = find(x, y);
                                             if (evt.getButton()== evt.BUTTON1) {
                                                 //get the location of the mouse
                                                 if(current!=-1) {
                                                     //init the DatabaseDataDisplay to display the dataset in the JTable
                                                     DatabaseDataDisplay D_Display=new DatabaseDataDisplay(Table_Name, current);
                                                     D_Display.setBackground(Color.white);
                                                     //remove the old panel
                                                     WholePanel.remove(scrollPaneDataPanel);
                                                     //add the new DataPanel
                                                     scrollPaneDataPanel = new JScrollPane(D_Display,
                                                                                   JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                                                                   JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
                                                     WholePanel.add(scrollPaneDataPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
                                                                    ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 2, 0, 2), 659, 5));
                                                     WholePanel.validate();
                                                 }
                                             } else if(evt.getButton()== evt.BUTTON3) {
                                                 /////////////////////
                                                 DefaultTableModel model = (DefaultTableModel)ColorTable.getModel();
                                                 DefaultTableModel preGeneModel = (DefaultTableModel)PreGeneColorTable.getModel();
                                                 DefaultTableModel postGeneModel = (DefaultTableModel)PostGeneColorTable.getModel();
                                                 //get the data in the color shape table
                                                 Color_Data=model.getDataVector();
                                                 PreGeneColor_Data =  preGeneModel.getDataVector();
                                                 PostGeneColor_Data = postGeneModel.getDataVector();
                                                 extractColoredAttributes();
                                                 extractPreGeneColoredAttributes();
                                                 extractPostGeneColoredAttributes();
                                                 ////////////////////////
                                                 if(disabledFlag == 0) {
                                                     String tmpqueryString = "select " + nonWhiteAttributeNames + "from  [" + Table_Name.trim() + "]  where ID=" + current + "";
                                                     int idx=0;
                                                     try {
                                                         DatabaseConnection connection=DatabaseConnection.getInstance();
                                                         Connection con=connection.getConnection();
                                                         if(tmpqueryString!=null) {
                                                             Statement stmt = con.createStatement();
                                                             ResultSet rs = stmt.executeQuery(tmpqueryString);
                                                             rs = stmt.getResultSet();
                                                             ResultSetMetaData rsmd1 = rs.getMetaData();
                                                             rs.next();
                                                             for(int i=0;i<sizeNonWhiteUniqueAttributes;i++) {
                                                                 String tmp=uniqueAttributesNonWhite[i];
                                                                 if(tmp!=null) {
                                                                     String value=rs.getString(tmp);
                                                                     if(rs.wasNull())
                                                                         valsToCompare[idx++]="NullEntry";
                                                                     else
                                                                         valsToCompare[idx++]=value;
                                                                     tmp="";
                                                                 }
                                                             }
                                                         }
                                                     } catch (SQLException s) {
                                                         System.out.println("Exception in trying to enable or disable options for specific Cell\nClass:VisualInterface\n" + s.toString());
                                                     }
                                                     /// i now have values corredponding to non-white attributes FOR CURRENT CELL, as well as actual VALUES
                                                     /// now to compare the two
                                                     int tempcount, tempcountinnerLoop, setFlag=1;
                                                     for(tempcountinnerLoop=0;tempcountinnerLoop<idx;tempcountinnerLoop++) {
                                                         tempcount=0;
                                                         while(tempcount < sizeNonWhiteVals) {
                                                             if((nonWhiteVals[tempcount].trim()).equalsIgnoreCase(valsToCompare[tempcountinnerLoop].trim())) {
                                                                 setFlag=0;
                                                                 break;
                                                             } else
                                                                 tempcount++;
                                                         }
                                                         if(setFlag==0)
                                                             break;
                                                     }
                                                     if(setFlag==0)
                                                         disabledFlag=0;
                                                     else
                                                         disabledFlag=1;
                                                 }
                                                 ////////////////////////
                                                 if(preGenedisabledFlag == 0) {
                                                     String tmpqueryString = "select " + preGenenonWhiteAttributeNames + "from  [" + Table_Name.trim() + "]  where ID=" + current + "";
                                                     int idx= 0;
                                                     try {
                                                         DatabaseConnection connection=DatabaseConnection.getInstance();
                                                         Connection con=connection.getConnection();
                                                         if(tmpqueryString!=null) {
                                                             Statement stmt = con.createStatement();
                                                             ResultSet rs = stmt.executeQuery(tmpqueryString);
                                                             rs = stmt.getResultSet();
                                                             ResultSetMetaData rsmd1 = rs.getMetaData();
                                                             rs.next();
                                                             for(int i=0;i<sizePreGeneNonWhiteUniqueAttributes;i++) {
                                                                 String tmp=uniqueAttributespreGeneNonWhite[i];
                                                                 if(tmp!=null) {
                                                                     String value=rs.getString(tmp);
                                                                     if(rs.wasNull())
                                                                         preGenevalsToCompare[idx++]="NullEntry";
                                                                     else
                                                                         preGenevalsToCompare[idx++]=value;
                                                                     tmp="";
                                                                 }
                                                             }
                                                         }
                                                     } catch (SQLException s) {
                                                         System.out.println("Exception in trying to enable or disable options for specific Cell\nClass:VisualInterface\n" + s.toString());
                                                     }
                                                     /// i now have values corredponding to non-white attributes FOR CURRENT CELL, as well as actual VALUES
                                                     /// now to compare the two
                                                     int tempcount, tempcountinnerLoop, setFlag=1;
                                                     for(tempcountinnerLoop=0;tempcountinnerLoop<idx;tempcountinnerLoop++) {
                                                         tempcount=0;
                                                         while(tempcount < sizePreGeneNonWhiteVals) {
                                                             if((preGenenonWhiteVals[tempcount].trim()).equalsIgnoreCase(preGenevalsToCompare[tempcount].trim())) {
                                                                 setFlag=0;
                                                                 break;
                                                             }
                                                             tempcount++;
                                                         }
                                                         if(setFlag==0)
                                                             break;
                                                     }
                                                     if(setFlag==0)
                                                         preGenedisabledFlag=0;
                                                     else
                                                         preGenedisabledFlag=1;
                                                 }
                                                 ////////////////////////
                                                 if(postGenedisabledFlag == 0) {
                                                     String tmpqueryString = "select " + postGenenonWhiteAttributeNames + "from  [" + Table_Name.trim() + "]  where ID=" + current + "";
                                                     int idx= 0;
                                                     try {
                                                         DatabaseConnection connection=DatabaseConnection.getInstance();
                                                         Connection con=connection.getConnection();
                                                         if(tmpqueryString!=null) {
                                                             Statement stmt = con.createStatement();
                                                             ResultSet rs = stmt.executeQuery(tmpqueryString);
                                                             rs = stmt.getResultSet();
                                                             ResultSetMetaData rsmd1 = rs.getMetaData();
                                                             rs.next();
                                                             for(int i=0;i<sizePostGeneNonWhiteUniqueAttributes;i++) {
                                                                 String tmp=uniqueAttributespostGeneNonWhite[i];
                                                                 String value=rs.getString(tmp);
                                                                 if(rs.wasNull())
                                                                     postGenevalsToCompare[idx++]="NullEntry";
                                                                 else
                                                                     postGenevalsToCompare[idx++]=value;
                                                                 tmp="";
                                                             }
                                                         }
                                                     } catch (SQLException s) {
                                                         System.out.println("Exception in trying to enable or disable options for specific Cell\nClass:VisualInterface\n" + s.toString());
                                                     }
                                                     /// we now have values corresponding to non-white attributes FOR CURRENT CELL, as well as actual VALUES
                                                     /// now to compare the two

                                                     int tempcount, tempcountinnerLoop, setFlag=1;
                                                     for(tempcountinnerLoop=0;tempcountinnerLoop<idx;tempcountinnerLoop++) {
                                                         tempcount=0;
                                                         while(tempcount < sizePostGeneNonWhiteVals) {
                                                             if((postGenenonWhiteVals[tempcount].trim()).equalsIgnoreCase(postGenevalsToCompare[tempcount].trim())) {
                                                                 setFlag=0;
                                                                 break;
                                                             }
                                                             tempcount++;
                                                         }
                                                         if(setFlag==0)
                                                             break;
                                                     }
                                                     if(setFlag==0)
                                                         postGenedisabledFlag=0;
                                                     else
                                                         postGenedisabledFlag=1;
                                                 }
                                                 ////////////////////////
                                                 SubMenu s = new SubMenu(current, Table_Name, disabledFlag, preGenedisabledFlag, postGenedisabledFlag, nonWhiteAttributeNames, preGenenonWhiteAttributeNames, postGenenonWhiteAttributeNames,  totalGenesToDisplay, directions, Color_Data,PreGeneColor_Data, PostGeneColor_Data, uniqueAttributesNonWhite, uniqueAttributespreGeneNonWhite, uniqueAttributespostGeneNonWhite, gridFlag);
                                                 zoomclasses = new JFrame[s.numberOfZooms];
                                                 zoomclasses = s.listChilds;
                                                 JPopupMenu jpop = s.getPopUpMenu();
                                                 jpop.show(evt.getComponent(), evt.getX(), evt.getY());
                                                 WholePanel.validate();
                                             }
                                             WholePanel.validate();
                                         }
                                     }
                                    );

            WholePanel.validate();
        }
        WholePanel.validate();
    }

    private void finddirections() {
        String Query="select * from ["+Table_Name+"]";
        DatabaseRowNumber Num=new DatabaseRowNumber(Query);
        int total=Num.getRowNumber();
        directions = new int[total];
        Num.finddirections(dirFlag);
        directions = Num.getDirections();

    }
    //**************************************************************************************
    // Open the Access Database
    void OpenButton_actionPerformed(ActionEvent e) {
        Runtime r= Runtime.getRuntime();
        try {
            //  open the Access database
           System.out.println("Runtime is " + r.toString());
            Process p=r.exec("rundll32"+" "+"Url.dll,FileProtocolHandler"+" "+"C:/VDApp.mdb");
        } catch(IOException ex) {
            ex.printStackTrace();
        }
    }
    //*************************************************************************************

    //Open the README.doc
    void HelpButton_actionPerformed(ActionEvent e) {
        Runtime r= Runtime.getRuntime();
        try {  
            //open the MS word document
          BrowserLauncher.openURL("http://prion.bchs.uh.edu/~lviswana/PaperSite.htm");
        } catch(IOException m) {
            m.printStackTrace();
        }
    }
    //*************************************************************************************

    //exit the program and close the database
    void ExitButton_actionPerformed(ActionEvent e) {
        //exit the program and close the database
        DatabaseConnection connection=DatabaseConnection.getInstance();
        connection.Close_Database();
        System.exit(0);
    }

    //**************************************************************************************

    //Open the README.doc
    void OverviewButton_actionPerformed(ActionEvent e) {
        Runtime r= Runtime.getRuntime();
        
                try {  //open the MS word document
            
              BrowserLauncher.openURL("http://prion.bchs.uh.edu/~lviswana/PaperSite.htm");
                    //r.exec(new String[] {browserName, url});
           //Process p=r.exec("rundll32"+" "+"Url.dll,FileProtocolHandler"+" "+"GeneViewer/ReadMe_GenomeViewer.doc");                
        } catch (IOException ex) {
           ex.printStackTrace();
        }
        /* try {
            //open the MS word document
            Process p=r.exec("rundll32"+" "+"Url.dll,FileProtocolHandler"+" "+"GeneViewer/ReadMe_GenomeViewer.doc");
        } catch(Exception ex) {
            ex.printStackTrace();
        }*/
    }
    //***************************************************************************************

    //Open the README.doc
    void InterfaceButton_actionPerformed(ActionEvent e) {
        Runtime r= Runtime.getRuntime();
        try { //open the MS word document
            BrowserLauncher.openURL("http://prion.bchs.uh.edu/~lviswana/PaperSite.htm");
            //Process p=r.exec("rundll32"+" "+"Url.dll,FileProtocolHandler"+" "+"GeneViewer/ReadMe_GenomeViewer.doc");
        } catch(Exception ex) {
            ex.printStackTrace();
        }
    }
    //***************************************************************************************


    //find the position of the gene in the genome table
    /**
     * Finds the geneNumber at the location of the mouse click
     * @param x X coordinate of the mouse click
     * @param y Y coordinate of the mouse click
     * @return returns the proteinNumber at the location of the mouse click.
     * The proteinNumber returned uses 1-based indexing. i.e. The lowest
     * proteinNumber returned is 1
     */
    public int find(int x, int y) {
        //get the whole database row number
        String Num_Query="Select * from ["+Table_Name+"]";
        DatabaseRowNumber num=new DatabaseRowNumber(Num_Query);
        int number=num.getRowNumber();
        int value=-1;
        if((x>(2*displayOffX+1)) && (y>(2*displayOffY+1)))
            if(x<((columns*(widthOfCell*75/100))+(2*displayOffX+1))) {
                int rowIdent = (y-(2*displayOffY+1))/(heightOfCell*8/10);
                int colIdent = (x-(2*displayOffX+1))/(widthOfCell*75/100);
                if ((rowIdent*columns + colIdent+1) <=totalGenesToDisplay)
                    value= (rowIdent*columns + colIdent+1);
                else
                    value=-1;
            }
        return value;

    }

    //**************************************************************************************
    /**
     * Extracts the non-white attributes from the attributes chosen for display.
     * This method takes no parameters.
     * It iterates through the Color_Shape table and extracts colors and shapes
     * for those rows which have a color and/or shape associated wih them. i.e.
     * which are colored in the display.
     * This is later used for detecting the values for these attributes, for
     * a specific cell(when the user right-clicks on it) and determine whether
     * further operations such as writing out data to a file, etc. can be performed
     * on the cell.
     */
    public void extractColoredAttributes() {
        nonWhiteVals = new String[Color_Data.size()];
        uniqueAttributesNonWhite = new String[Color_Data.size()];
        nonWhiteAttributeNames="";
        sizeNonWhiteVals=0;
        sizeNonWhiteUniqueAttributes=0;
        Enumeration enumVar=Color_Data.elements();
        //get all those elements which are non White;
        while (enumVar.hasMoreElements()) {
            Vector Data=(Vector)enumVar.nextElement();
            Enumeration enum_Data = Data.elements();
            int i=0;
            Object[] C_Data = new Object[5];
            while(enum_Data.hasMoreElements()) {
                C_Data[i]=enum_Data.nextElement();
                i++;
            }
            String Column_Name=C_Data[0].toString();
            Object value2=C_Data[1];
            Color color=(Color)C_Data[3];
            int red= color.getRed();
            int grn = color.getGreen();
            int blu = color.getBlue();
            if((color != color.white)&&((red+grn+blu)!=765)) {
                nonWhiteVals[sizeNonWhiteVals] = value2.toString();
                boolean addFlag=true;
                for(int countercheck=0;countercheck<sizeNonWhiteUniqueAttributes;countercheck++) {
                    if(Column_Name.trim().equals(uniqueAttributesNonWhite[countercheck])) {
                        addFlag=false;
                        break;
                    }
                }
                if(addFlag) {
                    uniqueAttributesNonWhite[sizeNonWhiteUniqueAttributes++]=Column_Name.trim();
                    if(nonWhiteAttributeNames.length()>0)
                        nonWhiteAttributeNames +=",";
                    nonWhiteAttributeNames += " [" + Column_Name.trim() + "] ";
                }
                sizeNonWhiteVals++;
            }
        }

        if(sizeNonWhiteVals==0)
            disabledFlag=1;
        else
            disabledFlag=0;
        valsToCompare = new String[nonWhiteVals.length];
    }

    /**
     * Extracts the non-white attributes from the attributes chosen for display.
     * This method takes no parameters.
     * It iterates through the Color_Shape table corresponding to upstream region of gene
     * and extracts colors and shapes for those rows which have a color
     * and/or shape associated wih them. i.e.which are colored in the display.
     * This is later used for detecting the values for these attributes, for
     * a specific cell(when the user right-clicks on it) and determine whether
     * further operations such as writing out data to a file, etc. can be performed
     * on the cell.
     */
    public void extractPreGeneColoredAttributes() {
        // uniqueAttributespreGeneNonWhite
        sizePreGeneNonWhiteVals=0;
        sizePreGeneNonWhiteUniqueAttributes=0;
        preGenenonWhiteVals = new String[PreGeneColor_Data.size()];
        uniqueAttributespreGeneNonWhite = new String[PreGeneColor_Data.size()];
        preGenenonWhiteAttributeNames="";
        Enumeration pregenum=PreGeneColor_Data.elements();

        //get all those elements which are non White;
        while (pregenum.hasMoreElements()) {
            Vector pregData=(Vector)pregenum.nextElement();
            Enumeration pregenum_Data = pregData.elements();
            int pgi=0;
            Object[] pregC_Data = new Object[5];
            while(pregenum_Data.hasMoreElements()) {
                pregC_Data[pgi]=pregenum_Data.nextElement();
                pgi++;
            }
            String pgColumn_Name=pregC_Data[0].toString();
            Object pgvalue2=pregC_Data[1];
            Color pgcolor=(Color)pregC_Data[3];
            int red= pgcolor.getRed();
            int grn = pgcolor.getGreen();
            int blu = pgcolor.getBlue();
            if((pgcolor != pgcolor.white) &&(red+grn+blu!=765)) {
                preGenenonWhiteVals[sizePreGeneNonWhiteVals] = pgvalue2.toString();
                boolean addFlag=true;
                for(int countercheck=0;countercheck<sizePreGeneNonWhiteUniqueAttributes;countercheck++) {
                    if(pgColumn_Name.trim().equals(uniqueAttributespreGeneNonWhite[countercheck])) {
                        addFlag=false;
                        break;
                    }
                }
                if (addFlag) {
                    uniqueAttributespreGeneNonWhite[sizePreGeneNonWhiteUniqueAttributes++]=pgColumn_Name.trim();
                    if(preGenenonWhiteAttributeNames.length()>0)
                        preGenenonWhiteAttributeNames +=",";
                    preGenenonWhiteAttributeNames += " [" + pgColumn_Name.trim() + "] ";
                }

                sizePreGeneNonWhiteVals++;
            }

        }
        if(sizePreGeneNonWhiteVals==0)
            preGenedisabledFlag=1;
        else
            preGenedisabledFlag=0;
        preGenevalsToCompare = new String[preGenenonWhiteVals.length];
    }

    /**
     * It iterates through the Color_Shape table corresponding to downstream region of gene
     * and extracts colors and shapes for those rows which have a color
     * and/or shape associated wih them. i.e.which are colored in the display.
     * This is later used for detecting the values for these attributes, for
     * a specific cell(when the user right-clicks on it) and determine whether
     * further operations such as writing out data to a file, etc. can be performed
     * on the cell.
     */
    public void extractPostGeneColoredAttributes() {
        postGenenonWhiteVals = new String[PostGeneColor_Data.size()];
        uniqueAttributespostGeneNonWhite = new String[PostGeneColor_Data.size()];
        postGenenonWhiteAttributeNames="";
        sizePostGeneNonWhiteVals=0;
        sizePostGeneNonWhiteUniqueAttributes=0;
        Enumeration enumpostg=PostGeneColor_Data.elements();
        //get all those elements which are non White;
        while (enumpostg.hasMoreElements()) {
            Vector postgData=(Vector)enumpostg.nextElement();
            Enumeration postgenum_Data = postgData.elements();
            int ipg=0;
            Object[] postgC_Data = new Object[5];
            while(postgenum_Data.hasMoreElements()) {
                postgC_Data[ipg]=postgenum_Data.nextElement();
                ipg++;
            }
            String postgColumn_Name=postgC_Data[0].toString();
            Object postgvalue2=postgC_Data[1];
            Color postgcolor=(Color)postgC_Data[3];
            int red= postgcolor.getRed();
            int grn = postgcolor.getGreen();
            int blu = postgcolor.getBlue();
            if((postgcolor != postgcolor.white)&&(red+grn+blu!=765)) {
                postGenenonWhiteVals[sizePostGeneNonWhiteVals] = postgvalue2.toString();
                boolean addFlag=true;
                for(int countercheck=0;countercheck<sizePostGeneNonWhiteUniqueAttributes;countercheck++) {
                    if(postgColumn_Name.trim().equals(uniqueAttributespostGeneNonWhite[countercheck])) {
                        addFlag=false;
                        break;
                    }
                }
                if (addFlag) {
                    uniqueAttributespostGeneNonWhite[sizePostGeneNonWhiteUniqueAttributes++]=postgColumn_Name.trim();
                    if(postGenenonWhiteAttributeNames.length()>0)
                        postGenenonWhiteAttributeNames +=",";
                    postGenenonWhiteAttributeNames += " [" + postgColumn_Name.trim() + "] ";
                }

                sizePostGeneNonWhiteVals++;
            }

        }
        if(sizePostGeneNonWhiteVals==0)
            postGenedisabledFlag=1;
        else
            postGenedisabledFlag=0;
        postGenevalsToCompare = new String[postGenenonWhiteVals.length];
    }

    //****************************************************************************************
    //private member variables

    private JPanel WholePanel = new JPanel();

    //two main Panels on the screen, DisplayPanel is for display graphics
    private JPanel DisplayPanel = new background();

    //scrollPane for DisplayPanel
    private JScrollPane scrollPaneDisplayPanel;

    //Panel for display dataset JTable
    private JPanel DataPanel = new JPanel();

    //scrollPane for dataPanel
    private JScrollPane scrollPaneDataPanel, scrollPaneBotPanel;

    // checkbox for directions
    private JCheckBox rbutton;

    //checkbox for demarcation
    private JCheckBox demarcateButton;

    // List for displaying attributes of a table
    private JList AttributeList = new JList();
    // Table for storing colr/shape values for pregene, gene and post gene information
    private JTable ColorTable,PreGeneColorTable,PostGeneColorTable;
    private JMenuItem menuItem1, menuItem2, menuItem3;
    private JButton DeleteButton, pgDeleteButton,DeleteButtonpg, OpenButton, HelpButton, ExitButton, InterfaceButton, DisplayButton, pgDisplayButton, DisplayButtonpg, CancelButton, pgCancelButton, CancelButtonpg, OverviewButton;
    private Object[] columnNames={"Attribute", "Value", "Quantity", "Color", "Shape"};
    private String Table_Name;
    private static Vector Color_Data, PreGeneColor_Data, PostGeneColor_Data;
    private int current;
    private int height;
    private int tempHt;
    private int tempWidth;
    // height of data panel
    private int dataPanelHeight=20;
    private int  displayPanelWdth;
    private int totalGenesToDisplay;
    private int displayOffX=20, displayOffY=15;
    private Dimension screenSize;
    // values for dertermining the number of cols and rows in which the data can be displayed
    // and for determining the width and height of cell
    private int columns, rows, widthOfCell, heightOfCell;
    // flags for determining which options should be enabled and disabled on right click of a specific cell
    private int disabledFlag=0, preGenedisabledFlag=0, postGenedisabledFlag=0;
    private String[] nonWhiteVals, preGenenonWhiteVals,  postGenenonWhiteVals,  uniqueAttributesNonWhite, uniqueAttributespreGeneNonWhite, uniqueAttributespostGeneNonWhite;
    private String nonWhiteAttributeNames="", preGenenonWhiteAttributeNames="", postGenenonWhiteAttributeNames="";
    // array for storing directions for each cell
    private int[] directions;
    private String[] valsToCompare, preGenevalsToCompare, postGenevalsToCompare;
    private Component Display;
    private int dirFlag=1, gridFlag=0;
    private int sizeNonWhiteVals=0, sizeNonWhiteUniqueAttributes=0, sizePreGeneNonWhiteVals=0, sizePreGeneNonWhiteUniqueAttributes=0, sizePostGeneNonWhiteVals=0, sizePostGeneNonWhiteUniqueAttributes=0;
    private JFrame[] zoomclasses=null;
    public static final long serialVersionUID = 24362462L;
    private JPanel BottomPanel,TableNamePanel, AttributPanel, ColorShapePanel,TablePanel,PreGeneColorShapePanel, PostGeneColorShapePanel, ButtonPanel, pgButtonPanel, ButtonPanelpg;
    private JLabel DataSetLabel, IconLabel1;
    private JScrollPane scrollPaneAttributeList,scrollPaneColorTable, PreGenescrollPane3, scrollPanePostGene;
    private JComboBox shapeCombo, PreGeneshapeCombo, PostGeneshapeCombo;
    private ColorTableModel PreGeneColor_Table, PostGeneColor_Table;
    private TableColumnModel columnModel, PreGenecolumnModel, PostGenecolumnModel;
    private TableColumn PreGeneshapeColumn, shapeColumn, PostGeneshapeColumn;
}
