#!/usr/bin/perl -w

use Cwd;

$|=1;
my $version = "0.02";
my $OS = $^O;
my $modules = './modules.conf';
my %varTypes;
my @modules;
my %moduleTypes;
my $mw;
$update = $ARGV[0] || "none";


print "OS\t\t[$OS]\n";

unless ($OS =~ /win32/i || $OS =~ /linux/i){

	print "Your OS is not supported at this time\n";
	print "but this installer may still work on your system...\n";
	print "Do you wish to attempt the installation using\n";
	print "(1) Linux installer (general Unix installer)\n";
	print "(2) MS Windows installer\n";
	print "(3) STOP HERE\n";
	print "pleaase enter 1,2, or 3:  [3]  ";
	chomp(my $ans = <STDIN>);
	if ($ans == 1){$OS = 'linux'}
	elsif ($ans == 2){$OS = 'MSWin32'}
	else {die "installation aborted"}
}

unless ($OS =~ /win32/i){
	print "To install Genquire you must be root-user, and have the MySQL server (mysqld) running\n";
	print "(NOTE:  This will also set the permissions on the Genquire installation folders as root...)\n";
	print "\nIF YOU ARE BEHIND A FIREWALL you must have opened PORT 2401 (CVS default) for this installation to succeed.\n";
	print "IF YOU ARE USING AN HTTP PROXY this installatino WILL NOT WORK.  You must install everything by hand\n";
	print "Do you wish to continue? y/n\n";
	chomp(my $x = <STDIN>);
	exit 0 unless (($x eq 'y') || ($x eq "Y"));
} else {
	
	print "\nIF YOU ARE BEHIND A FIREWALL you must have opened PORT 2401 (CVS default) for this installation to succeed.\n";
	print "IF YOU ARE USING AN HTTP PROXY this installation WILL NOT WORK.  Sorry... You must install everything by hand\n";
	print "Do you wish to continue? y/n\n";
	chomp(my $x = <STDIN>);
	exit 0 unless (($x eq 'y') || ($x eq "Y"));
}


installModules($modules);

begin();
Tk::MainLoop();

sub begin {
	require Tk;
	eval {require  Tk::DirTree};
	if ($@){die "$@"}

	import Tk qw(Exists Ev exit MainLoop DoOneEvent tkinit
				NoOp after *widget *event lsearch catch $XS_VERSION
                DONT_WAIT WINDOW_EVENTS  FILE_EVENTS TIMER_EVENTS
                IDLE_EVENTS ALL_EVENTS
                NORMAL_BG ACTIVE_BG SELECT_BG
                SELECT_FG TROUGH INDICATOR DISABLED BLACK WHITE);
	$mw = MainWindow->new(-title => "Double-click where Genquire should install");
	my $dt;
	my $x;
	$dt = $mw->Scrolled("DirTree", -directory => ".", -width => 100, -height => 12, -command => sub {&splash();&continue($dt->selectionGet); $x=1} )->pack;
	$mw->update;
	#$mw->waitVariable(\$x);
	
}

sub continue {
	my @sel = @_;
	my $dir = shift @sel;

	if ($OS =~ /win32/i){
		if ($dir =~ /\:$/){$dir = $dir."\\"}
	}
	
	print "continuing\n";
	chdir $dir || die "cant go to that folder";
	eval {$mw->destroy};
	
	if ($update ne 'nocvs'){ # case is only for debugging
		installModulesFromCVS($OS);
	}
	if ($update ne 'update'){
			# write out the default config files
			writeConf();
			writeUpdate();
	}
	my $notDone = 1;
	while($notDone){
		print "Would you like to start Genquire? [y/n]:";
		chomp(my $ans = <STDIN>);
		if ($ans =~ /^y/i){
			# "Here we go" - startup Genquire
			chdir("BIO_SUPPORT/Genquire") or die "Error changing directotry to BIO_SUPPORT/Genquire: $!"; 
			my $cmd = 'perl ./Genquire.pl';
			system($cmd);
		}elsif($ans =~/^n/i){
			$notDone = 0;
		}
	}
	print "Genquire Installation/Update complete.  Hapy GQ'ing\n";
	exit;
}




################
#
# Subroutines
#
################

sub splash{
	require Tk::JPEG;
	$top = MainWindow->new();
	$top->geometry("+0+0");
	my $ttfCanvas = $top->Canvas(-width => 550, -height => 237, -relief=>'ridge',-borderwidth=>2)->pack(-side=>'top',-expand => '1', -fill => 'x');
	my $genquireImage = $ttfCanvas->Photo(-format => 'jpeg', -file => "Genquire_Splash.jpg");		
	$ttfCanvas->createImage(275, 118, -image => $genquireImage);
	$top->update();
}

sub installModules{
	#Read in the modules that need to be present
	my $configFile = $_[0];
	open(CONF,"$configFile") or die "Error opening $configFile: $!";
	while(<CONF>){
		chomp $_;
		my @line = split(/\s+/,$_);
		if ($line[0] =~ /^#/){
			#ignore comments
			next;
		}
		if(($line[2] eq $OS)||($line[2] eq 'all')){
			push(@modules,$line[0]);
			$moduleTypes{$line[0]} = $line[1];
		}
	}
	close(CONF);
		
	foreach my $mod (@modules){
		my $testmod;
		
		my $packOk = testPackage($mod);
		unless($packOk){
			installPackage($mod);
			$packOk = testPackage($mod);
			unless ($packOk){
				print "Error with Package $mod\n";
				exit -1;
			}
		}
	}
}


sub installModulesFromCVS{
	use Cwd;
	my $current_dir = cwd;
	
	if ($OS =~ /win32/i){
		print "\a\t\tGenquire is installing CVS.exe in local directory.  \n\n".
		"CVS is copyright Cyclic Software.  No warranty is provided.  CVS executables and source code are available from http://www.cvshome.org,".
		"and is distributed under the GNU public license http://www.cvshome.org/cyclic/cyclic-pages/gpl.html \n\n".
		"The authors of Genquire have no affiliation with CVS, nor do we offer any support for this software.  \a\n\n";
		require LWP::UserAgent;
		my $ua = LWP::UserAgent->new;
		my $req = new HTTP::Request GET => 'http://www.bioinformatics.org/Genquire/cvs.exe';
		my $res = $ua->request($req);
		$res->is_success || die "get CVS failed\n";
		
		open OUT, ">cvs.exe" || die "INSTALL OF CVS FAILED\n";
		binmode OUT;
		print OUT $res->content;
		close OUT;
	}

	mkdir "BIO_SUPPORT";
	chdir "BIO_SUPPORT" or warn "Cannot change directory to BIO_SUPPORT: $!"; 
	mkdir "tmp";

	chdir $current_dir;
	

	if ($OS eq 'MSWin32'){
		system "set HOMEDRIVE=C:";
		system "set HOMEPATH=\\";
		
		chdir("BIO_SUPPORT") or warn "Cannot change directory to BIO_SUPPORT: $!"; 
		# bioperl stuff
		print "trying CVS\n\n";	
                system('..\cvs.exe -d :pserver:cvs:cvs@cvs.open-bio.org:/home/repository/bioperl login');
                system('..\cvs.exe -d :pserver:cvs:cvs@cvs.open-bio.org:/home/repository/bioperl checkout bioperl-live');
		print "Done Bioperl-live\n";
                system('..\cvs.exe -d :pserver:cvs:cvs@cvs.open-bio.org:/home/repository/bioperl checkout bioperl-gui');
		print "Done bioperl-gui\n";
                system('..\cvs.exe -d :pserver:cvs:cvs@cvs.open-bio.org:/home/repository/bioperl checkout bioperl-db');
		print "Done bioperl-db\n";
		#GO stuff
		system('..\cvs.exe -d :pserver:anonymous:@cvs.geneontology.sourceforge.net:/cvsroot/geneontology login');
		system('..\cvs.exe -d :pserver:anonymous:@cvs.geneontology.sourceforge.net:/cvsroot/geneontology co go-dev/perl-api');
		print "Done go-dev\n";
		#Genquire stuff
		system('..\cvs.exe -d :pserver:anonymous:@bioinformatics.org:/cvsroot login');
		system('..\cvs.exe -d :pserver:anonymous:@bioinformatics.org:/cvsroot checkout Genquire');
		print "Done Genquire\n";
		chdir($current_dir) or die "Cannot change directory to base install point: $!"; 
	}elsif($OS eq 'linux'){
		# linux cvs command is different because linux will not allow the specification of username on the command line
		chdir("BIO_SUPPORT") or warn "Cannot change directory to BIO_SUPPORT: $!"; 
		# bugger!
		system("touch ~/.cvspass");
		# bioperl stuff
		print "\aTHE PASSWORD REQUESTED BELOW IS 'cvs'\n";
                system('cvs -d :pserver:cvs@cvs.open-bio.org:/home/repository/bioperl login');
                system('cvs -d :pserver:cvs@cvs.open-bio.org:/home/repository/bioperl checkout bioperl-live');
		print "\n\n\nDone Bioperl-live!!\n\n\n";
		
                system('cvs -d :pserver:cvs@cvs.open-bio.org:/home/repository/bioperl checkout bioperl-gui');
		print "\n\nDone bioperl-gui!!\n\n";
                system('cvs -d :pserver:cvs@cvs.open-bio.org:/home/repository/bioperl checkout bioperl-db');
		print "\n\nDone bioperl-db!!\n\n";
		#GO stuff
		print "\aTHE PASSWORD REQUESTED BELOW IS - just hit return....\n";
		system('cvs -d :pserver:anonymous@cvs.geneontology.sourceforge.net:/cvsroot/geneontology login');
		system('cvs -d :pserver:anonymous@cvs.geneontology.sourceforge.net:/cvsroot/geneontology co go-dev/perl-api');
		print "\n\n\nDone go-dev!!\n\n\n";
		#Genquire stuff
		print "\aTHE PASSWORD REQUESTED BELOW IS - just hit return....\n";
		system('cvs -d :pserver:anonymous@bioinformatics.org:/cvsroot login');
		system('cvs -d :pserver:anonymous@bioinformatics.org:/cvsroot checkout Genquire');
		print "\n\n\nDone Genquire!!\n\n\n";
		chdir("..") or die "Cannot change directory to base install point: $!"; 
	}else{
		print "Your OS ($OS) is not supported\n";

		exit -3;
	}
}


sub testPackage{
	my $package = $_[0];
	my $type = $moduleTypes{$package};

	# one exception... stupid!!
	if ($package eq "TermReadKey"){$package = "Term::ReadKey"}
	
	if($type eq 'perl'){
		my $len = length($package);
		TESTSWITCH:{
			if ($OS eq "linux"){
				my $val = eval("use $package;");
				if ($@ =~ /^Can\'t/) {
						print "$package\t";
						if ($len < 8){print "\t";}
						print "[NOT INSTALLED]\n";
						return 0;
				}
				else {
						print "$package\t";
						if ($len < 8) { print "\t";}
						print "[INSTALLED]\n";
						return 1;
				}
				last TESTSWITCH;
			}
			if ($OS eq "MSWin32") {
				my $cmd = "perl -e \"use $package;\"";
				my $val = system("$cmd");
				if ($val == 0) {
				print "$package\t";
				if ($len < 8) { print "\t";}
				print "[INSTALLED]\n";
				return 1;
				}
				else {
					print "$package\t";
					if ($len < 8) { print "\t";}
					print "[NOT INSTALLED]\n";
					return 0;
				}
				last TESTSWITCH;
			}
			print "Your os is not supported: $OS\n";
			exit -3;
		}
	}else{
		print "Type $type not supported\n";
	}
}


sub installPackage{
	my $package = $_[0];
	SWITCH: {
		if ($OS eq "linux") {
			# use cpan to install the module
			print "Installing $package using CPAN\n";
			my $cmd = "perl -MCPAN -e \'CPAN::Shell->install($package)\'";
			system("$cmd");
			last SWITCH;
		}
		if ($OS eq "MSWin32") {
			#use ppm to install the module
                        print "Installing $package using ppm3\n";
			system("ppm install --location=http://www.activestate.com/ppmpackages/5.6plus/ $package");
#                               system("ppm3 install --location=http://www.activestate.com/PPMPackages/5.6/ $package");
#                               system("ppm3 install $package");
#                               print "cmd: ppm3 install $package\n";
			last SWITCH;
		}
		print "Your OS is $OS\n";
		print "The only supported achitectures are linux and MSWin32\n";
		print "Install GENQUIRE at your own risk.\n";
		exit;
	}
	if (testPackage("$package")) {
#			print "$package\t[INSTALLED]\n";
	}
	else {
#			print "$package\t[NOT INSTALLED]\n";
		print STDERR "Unknown Error installing package: $package\n";
		print STDERR "Please report this error to the GENQUIRE developers\n";
		exit;
	}		
}
sub writeConf{
	# the nix'es are case sensitive!
	if ($^O =~ /win32/i){
		$s = "\\";
	} else {$s = "/";
	}
	
	open(GENQUIRECONF,'>./BIO_SUPPORT/Genquire/genquire.conf') or die "Error creating genquire.conf: $!";
	print GENQUIRECONF q^
{
use lib "../bioperl-gui";
use lib "../bioperl-live";
use lib "../go-dev/perl-api";
use lib "../Genquire";
use lib "../Genquire/PLUGINS";


$SIM4_DIR = "";
$TEMP_DIR = "../tmp";
$blast_BINARIES = "../BLAST";
$BROWSER = "netscape";

$BLAST_URL = "http://fingal/PANDA/pandablast.cgi";
$WORKING_DIR = "../Genquire";
$PLUGINS_DIR = "../Genquire/PLUGINS";
$DATA_SOURCES = [
	["SAMPLE","gq_demo.cfg"], # Bioinfo public
	["BioSQL", "BioSQL.cfg"],
	["GENQUIRE_LOCAL", "gq_local.cfg"],
	["GENBANK_FLAT", "gb_flat.cfg"],	
			 ];

$BLAST_CONFIG = {
# below is a list of all *acceptable* Blast parameters
# note that some are removed because the GUI must be able
# to receive and interpret the results.  
# when CGI_param is not avalable for your particular CGI,
# leave it undef.  Pay attention to the -i parameter, as it is not
# identical to the meaning in blastall...
#
# blastall_param		#[CGI_param, 		default]
'-i'			=>		['seq', 			undef],		# NOTA BENE!!  This parameter holds the input sequence Fasta *string* (NOT filename!!)
'-p'			=> 		['blastprogram', 	'blastn'],	# NB Genquire is only set up to handle nucleotide query inputs to Blast!
'-e'			=>		[undef,				'10.0'],
'-d'			=>		['database', 		'nt'],		# NB Genquire is only set up to handle nucleotide query inputs to Blast!
'-F'			=>		[undef,				'T'],
'-G'			=>		[undef,				'0'],
'-E'			=>		[undef,				'0'],
'-X'			=>		[undef,				'0'],
'-I'			=>		[undef,				'F'],
'-q'			=>		[undef,				'-3'],
'-r'			=>		[undef,				'1'],
'-v'			=>		[undef,				'500'],
'-b'			=>		[undef,				'250'],
'-f'			=>		[undef,				'0'],
'-g'			=>		[undef,				'T'],
'-Q'			=>		[undef,				'1'],
'-D'			=>		[undef,				'1'],
'-a'			=>		[undef,				'1'],
'-J'			=>		[undef,				'F'],
'-M'			=>		[undef,				'BLOSUM62'],
'-W'			=>		[undef,				'0'],
'-z'			=>		[undef,				'0'],
'-K'			=>		[undef,				'100'],
'-L'			=>		[undef,				'20'],
'-Y'			=>		[undef,				'0'],
'-S'			=>		[undef,				'3'],
'-T'			=>		[undef,				'F'],
'-U'			=>		[undef,				'F'],
'-y'			=>		[undef,				'0.0'],
'-Z'			=>		[undef,				'0'],					
			};

}
^;
	close(GENQUIRECONF);
	open(GQPUB,'>./BIO_SUPPORT/Genquire/gq_demo.cfg') or die "Error opening gq_pub.cfg for writting: $!";
	print GQPUB q^
$Username = "gqguest";
$Password = "";
$IPAddress = "bioinfo.usask.ca";
$Filename = "";
$Default_DB = "gqdemo";

$dbobj = GQ::Server::DB::DbObj->new($Username, $Password, $Default_DB, $IPAddress);
if ($dbobj) { #successful connection
	$context=GQ::Server::DB::Context->new($dbobj) # not all Context objects will require $dbobj for initialization! 
} else {
	die "failed to connect to local Genquire database to extract organism list";
}
^;
	close(GQPUB);


	open(BioSQL,'>./BIO_SUPPORT/Genquire/BioSQL.cfg') or die "Error creating BioSQL.cfg: $!";
	print BioSQL q^

use lib '../bioperl-live';
use lib '../bioperl-db';



use Getopt::Long;
use Bio::DB::SQL::DBAdaptor;
use Bio::SeqIO;
use Tk;
use Tk::BrowseEntry;


my $host = "localhost";
my $sqlname = "biosql";   # this is the name of the database itself
my $dbuser = "root";
my $driver = 'mysql';
my $dbpass = "root";

# everything below should NOT be changed
# =======================================

$dbadaptor = Bio::DB::SQL::DBAdaptor->new(
	-host   => $host,
	-dbname => $sqlname,
	-driver => $driver,
	-user   => $dbuser,
	-pass  => $dbpass,
	);

if ($dbadaptor) { #successful connection
	my $dbname = &getDBName($dbadaptor);
	$dbname || die "failed to connect to database $sqlname";
	use GQ::Server::BioSQL::Context;
    $context=GQ::Server::BioSQL::Context->new($dbadaptor);
	$context->dbname($dbname);
} else {
    die "failed to connect to Database $sqlname";
}


sub getDBName {
	my ($dbadaptor) = @_;
	my @names = $dbadaptor->get_dbNames;
	my $mw = MainWindow->new(-title => 'Use Biodatabase');
   
	my $selected;
	$mw->Label(-text => "         SELECT BIODATABASE NAME          ", -background => 'yellow')->pack(-side => "top", -anchor => 'w', -expand => 1, -fill => 'x');
	my $b = $mw->BrowseEntry(
		 -listwidth => 75,-background => 'yellow',
		 -variable=>\$selected,
		);
	
	foreach my $name(@names){
		$b->insert(1,$name); # add to the BrowseEntry widget
	}
	$b->pack(-side => 'top', -anchor => 'w', -expand => 1, -fill => 'x');
	$mw->waitVariable(\$selected);
	$mw->destroy;
	return $selected;
}
^;

close BioSQL;

	

}











sub writeUpdate{
	open(UPDATE,'>./update.pl') or die "Error opening update.pl for writting: $!";
	print UPDATE q^
#!/usr/bin/perl
system('perl ./install.pl update');
exit;
^;
	close(UPDATE);
}
