#!/usr/bin/expect

## Allow CVS commands to be run noninteractively.
## Parameters:  [password] [rest of cvs args]
set password [lindex $argv 0]
set cvsargs [lrange $argv 1 end]
set password_wait 10

set prompt "(%|#|\\$) $"          ;# default prompt
catch {set prompt $env(EXPECT_PROMPT)}
spawn $env(SHELL)

## If a password request comes within $password_wait seconds, we
## enter it in automatically.
send -- "cvs -d $cvsargs\n"
expect -timeout $password_wait -re "word: " {
    send "$password\n"
}

expect  -timeout -1 -re $prompt
send_user "\n"

