package GQ_comm;
use strict;

use vars qw(@ISA @EXPORT);

@ISA = qw(Exporter);
@EXPORT= qw(askGenquire);

use subs qw (askGenquire);

my $dbug = 0;


sub askGenquire {
	my ($request, $data) = @_;
	$| = 1;
	_log("$request $data\n");
	&_send("<REQUEST><$request>$data</$request></REQUEST>\n\n");
	my $response;
	my $partial;
	#sleep 1;
	for (;;){
		my $buf;
		my $len = sysread(STDIN, $buf, 1024);
		substr($buf,0,0)=$partial;  ## prepend from last sysread
		my @buf=split(/\r?\n/,$buf);   ## break into lines
		if ($buf=~/\n$/) { $partial=''; } else { $partial= pop(@buf); }
		_log("partial *". (length($partial)) . "*\n");
		foreach(@buf) { $response .= $_ }
		last if ($response =~ /<\/GQ_RESPONSE>/);
		last if ($len) < 1024;
		next;
	}
	my $sendback = (($response =~ /<$request>(.*)<\/$request>/) && $1);
	return $sendback;

}

sub _send {
	my ($return) = @_;
	my $len = length($return);
	my $offset = 0; my $tries = 0;
	while ($len){
		&_log("$return\n");
		my $written = syswrite STDOUT, $return, $len, $offset; # may only write partial data...
		unless (defined $written){next}
		$offset += $written;
		$len -= $written;
	}
	return $return;
}

sub _log{
	my ($m) = @_;
	return unless $dbug;
	open LOGFILE, ">>c:\\temp\\gqcommlogfile.txt";
	print LOGFILE $m;
	close LOGFILE;
}


1;
