CREATE TABLE `geneinfo` (
  `tax_id` int(11),
  `gene_id` int(11),
  `symbol` varchar(128),
  `locus_tag` varchar(32),
  `synonyms` varchar(1024),
  `db_xrefs` varchar(512),
  `chromosome` varchar(32),
  `map_location` varchar(32),
  `description` varchar(2048),
  `type_of_gene` varchar(32),
  `authority_symbol` varchar(32),
  `authority_name` varchar(256),
  `authority_status` varchar(4),
  `other_designations` varchar(2048),
  `modification_date` date,
  KEY `index_gene_id` (`gene_id`),
  KEY `index_tax_id` (`tax_id`)
);

CREATE TABLE `gene2go` (
  `tax_id` int(11),
  `gene_id` int(11),
  `go_id` varchar(20),
  `evidence_qualifier` varchar(10),
  `go_term` varchar(20),
  `pubmed_category` text,
  `pubmed_id` varchar(1024),
  `go_ontology` varchar(20),
  KEY `index_g2_tax_id` (`tax_id`)
);
