/*
 * Decompiled with CFR 0.152.
 */
package edu.hust.go.model;

import edu.hust.go.term.GO_term;

public class GoException
extends Exception {
    String msg = "";

    public GoException(String defFile, byte parseType) {
        this.msg = "Failed to parse the GO definition file: " + defFile + "\n";
        this.msg = this.msg + "It may be caused by the following: \n";
        this.msg = this.msg + "\tIt is not downloaded from the GO official site: http://www.geneontology.org or ftp://ftp.geneontology.org\n";
        this.msg = this.msg + "This defintion file is not in the format of ";
        switch (parseType) {
            case 0: {
                this.msg = this.msg + "OBO!";
                break;
            }
            case 1: {
                this.msg = this.msg + "OBOXML!";
                break;
            }
            case 2: {
                this.msg = this.msg + "RDFXML!";
                break;
            }
            case 3: {
                this.msg = this.msg + "OWL!";
                break;
            }
            default: {
                this.msg = "Failed to parse the GO definition file: " + defFile + "\n";
                this.msg = this.msg + "Unknown format, the format should be OBO, OBOXML, RDFXML or OWL";
            }
        }
        this.msg = this.msg + ". There are some problems in GO definition file";
    }

    public GoException(GO_term source, GO_term target) {
        this.msg = "Invalid GO definition, ";
        if (source == null) {
            if (target != null) {
                this.msg = this.msg + "and it may be have relation to " + target.getId();
            }
        } else {
            this.msg = source == null ? this.msg + "and it may be have relation to " + source.getId() : this.msg + "and it may be have relation to " + source.getId() + " " + target.getId();
        }
    }

    public String toString() {
        this.msg = this.msg + "\n Please make sure the GO definition file came from http://www.godatabase.org/dev/database/archive/";
        return this.msg;
    }
}

