/*
 * Decompiled with CFR 0.152.
 */
package edu.hust.go.model;

import edu.hust.go.model.GoAdaptor;
import edu.hust.go.term.DefaultGO_term;
import edu.hust.go.term.GO_term;
import edu.hust.go.term.OBOGO_term;
import edu.hust.go.term.OboXmlGo_term;
import edu.hust.go.term.OwlGo_term;
import edu.hust.go.term.RdfXmlGo_term;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Document;

public abstract class GoParser {
    public static final byte OBO = 0;
    public static final byte OBOXML = 1;
    public static final byte RDFXML = 2;
    public static final byte OWL = 3;
    static final int defaultThreadNumber = 4;
    static final int defaultPoolSize = 10000;
    String target;
    int threadNumber;
    int poolSize;
    HashMap termMap = new HashMap();
    Vector dataPool = new Vector();
    HashMap threadPool = new HashMap();
    boolean m_ParserActive = true;

    public GoParser(String _target) {
        this(_target, 4, 10000);
    }

    public GoParser(String _target, int _maxThreadNumber) {
        this(_target, _maxThreadNumber, 10000);
    }

    public GoParser(String _target, int _maxThreadNumber, int _maxPoolSize) {
        this.target = _target;
        this.threadNumber = _maxThreadNumber;
        this.poolSize = _maxPoolSize;
    }

    public HashMap getTermMap() {
        return this.termMap;
    }

    public abstract GO_term getGoTermById(String var1);

    protected void parse(byte goDefType) {
        this.setParserActive();
        int i = 0;
        while (i < this.threadNumber) {
            GoAdaptor adaptor = new GoAdaptor(this, String.valueOf(i), goDefType);
            adaptor.start();
            this.threadPool.put(String.valueOf(i), adaptor);
            ++i;
        }
        this.parseTarget();
        this.setParsingComplete();
        while (this.threadActive()) {
            try {
                this.wait();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected abstract void parseTarget();

    protected synchronized boolean queueProcessed() {
        return !this.parsingInProgress() && this.dataPool.size() == 0;
    }

    protected synchronized boolean parsingInProgress() {
        return this.m_ParserActive;
    }

    protected synchronized void setParserActive() {
        this.m_ParserActive = true;
    }

    protected synchronized void setParsingComplete() {
        this.m_ParserActive = false;
    }

    protected synchronized void addDataToPool(Object data) {
        block2: {
            this.dataPool.add(data);
            if (this.dataPool.size() != this.poolSize) break block2;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
    }

    protected synchronized Object getDataFromPool() {
        Object data = null;
        while (this.parsingInProgress() && this.dataPool.size() == 0) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (!this.parsingInProgress() && this.dataPool.size() == 0) {
            return null;
        }
        data = this.dataPool.remove(0);
        this.notify();
        return data;
    }

    protected synchronized void addTermToMap(Object data, byte defType) {
        DefaultGO_term term = null;
        try {
            switch (defType) {
                case 0: {
                    term = new OBOGO_term((HashMap)data);
                    break;
                }
                case 1: {
                    term = new OboXmlGo_term((Document)data);
                    break;
                }
                case 2: {
                    term = new RdfXmlGo_term((Document)data);
                    break;
                }
                case 3: {
                    term = new OwlGo_term((Document)data);
                    break;
                }
                default: {
                    term = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (term != null) {
            this.termMap.put(term.getId(), term);
        }
    }

    protected synchronized void removeThread(String threadName) {
        this.threadPool.remove(threadName);
    }

    protected synchronized boolean threadActive() {
        return this.threadPool.size() > 0;
    }
}

