/*
 * Decompiled with CFR 0.152.
 */
package edu.hust.go.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org._3pq.jgrapht.edge.DirectedEdge;
import org._3pq.jgrapht.graph.SimpleDirectedGraph;

public class GraphPath {
    public static HashSet getNodeAllParents(SimpleDirectedGraph graph, Object node) {
        return GraphPath.getAviableNodes(graph, node, true);
    }

    public static HashSet getNodeAllChildren(SimpleDirectedGraph graph, Object node) {
        return GraphPath.getAviableNodes(graph, node, false);
    }

    public static Vector getNodeParents(SimpleDirectedGraph graph, Object node) {
        return GraphPath.getDirectNodes(graph, node, true);
    }

    public static Vector getNodeChildren(SimpleDirectedGraph graph, Object node) {
        return GraphPath.getDirectNodes(graph, node, false);
    }

    private static Vector getDirectNodes(SimpleDirectedGraph graph, Object node, boolean parent) {
        Vector<Object> list = new Vector<Object>();
        if (parent) {
            List edgeList = graph.incomingEdgesOf(node);
            int i = 0;
            while (i < edgeList.size()) {
                Object obj = ((DirectedEdge)edgeList.get(i)).getSource();
                list.add(obj);
                ++i;
            }
        } else {
            List edgeList = graph.outgoingEdgesOf(node);
            int i = 0;
            while (i < edgeList.size()) {
                Object obj = ((DirectedEdge)edgeList.get(i)).getTarget();
                list.add(obj);
                ++i;
            }
        }
        return list;
    }

    private static HashSet getAviableNodes(SimpleDirectedGraph graph, Object node, boolean parent) {
        HashSet<Object> set = new HashSet<Object>();
        if (parent) {
            List edgeList = graph.incomingEdgesOf(node);
            int i = 0;
            while (i < edgeList.size()) {
                Object obj = ((DirectedEdge)edgeList.get(i)).getSource();
                set.add(obj);
                set.addAll(GraphPath.getAviableNodes(graph, obj, parent));
                ++i;
            }
        } else {
            List edgeList = graph.outgoingEdgesOf(node);
            int i = 0;
            while (i < edgeList.size()) {
                Object obj = ((DirectedEdge)edgeList.get(i)).getTarget();
                set.add(obj);
                set.addAll(GraphPath.getAviableNodes(graph, obj, parent));
                ++i;
            }
        }
        return set;
    }

    public static HashMap getPath2Node(SimpleDirectedGraph graph, Object obj1, Object obj2) {
        Vector<Object[]> pathVector = new Vector<Object[]>();
        HashSet p1Set = GraphPath.getNodeAllParents(graph, obj1);
        HashSet p2Set = GraphPath.getNodeAllParents(graph, obj2);
        HashSet commonSet = GraphPath.getCommonElements(p1Set.toArray(), p2Set.toArray());
        Object[][] path = GraphPath.getPath2Root(graph, obj1);
        int i = 0;
        while (i < path.length) {
            int j = 0;
            while (j < path[i].length) {
                if (commonSet.contains(path[i][j])) {
                    pathVector.add(path[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        path = GraphPath.getPath2Root(graph, obj2);
        int i2 = 0;
        while (i2 < path.length) {
            int j = 0;
            while (j < path[i2].length) {
                if (commonSet.contains(path[i2][j])) {
                    pathVector.add(path[i2]);
                    break;
                }
                ++j;
            }
            ++i2;
        }
        HashMap<HashSet, Object[]> pathMap = new HashMap<HashSet, Object[]>();
        pathMap.put(commonSet, pathVector.toArray());
        return pathMap;
    }

    public static boolean related(SimpleDirectedGraph graph, Object obj1, Object obj2) {
        if (obj1.equals(obj2)) {
            boolean related = true;
        } else {
            HashSet children = GraphPath.getNodeAllChildren(graph, obj1);
            HashSet parents = GraphPath.getNodeAllParents(graph, obj1);
            boolean related = children.contains(obj2) || parents.contains(obj2);
        }
        return false;
    }

    public static Object[][] getPath2Root(SimpleDirectedGraph graph, Object node) {
        Vector path = GraphPath.getPathVector(graph, node);
        return GraphPath.convertPahtVector2Array(path);
    }

    private static Vector getPathVector(SimpleDirectedGraph graph, Object obj) {
        Vector<Object> pathVector = new Vector<Object>();
        pathVector.add(obj);
        int pNumber = graph.inDegreeOf(obj);
        boolean finish = false;
        Object curObj = obj;
        while (pNumber < 2) {
            if (pNumber == 0) {
                finish = true;
                break;
            }
            curObj = ((DirectedEdge)graph.incomingEdgesOf(curObj).get(0)).getSource();
            pathVector.add(curObj);
            pNumber = graph.inDegreeOf(curObj);
        }
        if (!finish) {
            Object[] edges = graph.incomingEdgesOf(curObj).toArray();
            Vector<Vector> _path = new Vector<Vector>(pNumber);
            int i = 0;
            while (i < edges.length) {
                Object source = ((DirectedEdge)edges[i]).getSource();
                _path.add(GraphPath.getPathVector(graph, source));
                ++i;
            }
            pathVector.add(_path);
        }
        return pathVector;
    }

    private static Object[][] convertPahtVector2Array(Vector fullPath) {
        Object[][] pathArray;
        int size = fullPath.size();
        Object obj = fullPath.get(size - 1);
        if (obj instanceof Vector) {
            Object[] prefixPath = new Object[size - 1];
            int i = 0;
            while (i < size - 1) {
                prefixPath[i] = fullPath.get(i);
                ++i;
            }
            Vector curPath = (Vector)obj;
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            Vector<Object[]> temp = new Vector<Object[]>();
            int i2 = 0;
            while (i2 < curPath.size()) {
                Object[][] tempPath = GraphPath.convertPahtVector2Array((Vector)curPath.get(i2));
                int j = 0;
                while (j < tempPath.length) {
                    Object[] swapPath = new Object[size - 1 + tempPath[j].length];
                    System.arraycopy(prefixPath, 0, swapPath, 0, size - 1);
                    System.arraycopy(tempPath[j], 0, swapPath, size - 1, tempPath[j].length);
                    temp.add(swapPath);
                    Integer pathLength = new Integer(swapPath.length);
                    String indexStr = map.get(pathLength) == null ? String.valueOf(temp.size() - 1) : map.get(pathLength) + " " + (temp.size() - 1);
                    map.put(pathLength, indexStr);
                    ++j;
                }
                ++i2;
            }
            pathArray = new Object[temp.size()][];
            Object[] pathSize = new Integer[map.size()];
            map.keySet().toArray(pathSize);
            Arrays.sort(pathSize);
            int flag = 0;
            int i3 = 0;
            while (i3 < pathSize.length) {
                String[] str = ((String)map.get(pathSize[pathSize.length - 1 - i3])).split(" ");
                int j = 0;
                while (j < str.length) {
                    pathArray[flag++] = (Object[])temp.get(Integer.parseInt(str[j]));
                    ++j;
                }
                ++i3;
            }
        } else {
            pathArray = new Object[1][size];
            fullPath.toArray(pathArray[0]);
        }
        return pathArray;
    }

    public static void getCommonElements(Object[][] path, HashMap map) {
        HashSet<Object> nodeSet = new HashSet<Object>();
        int i = 0;
        while (i < path.length) {
            int j = 0;
            while (j < path[i].length) {
                nodeSet.add(path[i][j]);
                ++j;
            }
            ++i;
        }
        Object[] nodes = nodeSet.toArray();
        int i2 = 0;
        while (i2 < nodes.length) {
            int value = map.get(nodes[i2]) == null ? 0 : (Integer)map.get(nodes[i2]);
            map.put(nodes[i2], new Integer(++value));
            ++i2;
        }
    }

    public static HashSet getCommonElements(Object[] apath, Object[] bpath) {
        HashSet<Object> set = new HashSet<Object>();
        HashSet<Object> commonSet = new HashSet<Object>();
        int i = 0;
        while (i < apath.length) {
            set.add(apath[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < bpath.length) {
            if (set.contains(bpath[i2])) {
                commonSet.add(bpath[i2]);
            }
            ++i2;
        }
        return commonSet;
    }
}

