/*
 * Decompiled with CFR 0.152.
 */
package edu.hust.go.term;

import edu.hust.go.term.DefaultGO_term;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RdfXmlGo_term
extends DefaultGO_term {
    Vector synonym = new Vector();
    Vector comment = new Vector();
    Vector dbxref = new Vector();
    Vector association = new Vector();
    Vector history = new Vector();
    boolean is_obsolete;
    boolean focus;
    int n_associations;

    public RdfXmlGo_term(Document doc) throws TransformerException {
        CachedXPathAPI xpath = new CachedXPathAPI();
        this.is_obsolete = this.setBool(doc, xpath, "/term/is_obsolete");
        this.focus = this.setBool(doc, xpath, "/term/@focus");
        this.n_associations = (int)xpath.eval(doc, "/term/@n_associations").num();
        this.id = xpath.eval(doc, "/term/accession").str();
        this.name = xpath.eval(doc, "/term/accession").str();
        this.synonym = this.setVector(doc, xpath, "/term/synonym");
        this.def = xpath.eval(doc, "/term/definition").str();
        this.comment = this.setVector(doc, xpath, "/term/synonym");
        this.part_of = this.setAttrVector(doc, xpath, "/term/part_of");
        this.is_a = this.setAttrVector(doc, xpath, "/term/is_a");
        this.dbxref = this.setDbxref(doc, xpath);
        this.association = this.setAssociation(doc, xpath);
        this.history = this.setHistory(doc, xpath);
    }

    Vector setVector(Document doc, CachedXPathAPI xpath, String xqueryStr) throws TransformerException {
        Vector<String> vector = new Vector<String>();
        NodeList list = xpath.selectNodeList(doc, xqueryStr);
        int i = 0;
        while (i < list.getLength()) {
            vector.add(xpath.eval(list.item(i), ".").str());
            ++i;
        }
        return vector;
    }

    Vector setAttrVector(Document doc, CachedXPathAPI xpath, String xqueryStr) throws TransformerException {
        Vector<String> vector = new Vector<String>();
        NodeList list = xpath.selectNodeList(doc, xqueryStr);
        int i = 0;
        while (i < list.getLength()) {
            String str = xpath.eval(list.item(i), "./@resource").str();
            if (str.indexOf("#") > -1) {
                if ((str = str.substring(str.indexOf("#") + 1)).startsWith("GO:")) {
                    vector.add(str);
                } else if (str.startsWith("obsolete")) {
                    this.is_obsolete = true;
                }
            }
            ++i;
        }
        return vector;
    }

    Vector setDbxref(Document doc, CachedXPathAPI xpath) throws TransformerException {
        Vector<String[]> vector = new Vector<String[]>();
        NodeList list = xpath.selectNodeList(doc, "/term/dbxref");
        int i = 0;
        while (i < list.getLength()) {
            vector.add(this.setDbxref(list.item(i), xpath));
            ++i;
        }
        return vector;
    }

    String[] setDbxref(Node node, CachedXPathAPI xpath) throws TransformerException {
        String database_symbol = xpath.eval(node, "database_symbol").str();
        String reference = xpath.eval(node, "reference").str();
        String type = xpath.eval(node, "reference/@type").str();
        String[] array = new String[]{database_symbol, reference, type};
        return array;
    }

    Vector setAssociation(Document doc, CachedXPathAPI xpath) throws TransformerException {
        Vector<Object[]> vector = new Vector<Object[]>();
        NodeList list = xpath.selectNodeList(doc, "/term/association");
        int i = 0;
        while (i < list.getLength()) {
            String[] swap;
            String[] array;
            Vector<String[]> evidenceVector = new Vector<String[]>();
            Node node = list.item(i);
            NodeList swapList = xpath.selectNodeList(node, "evidence");
            int j = 0;
            while (j < swapList.getLength()) {
                array = this.setDbxref(xpath.selectSingleNode(swapList.item(j), "dbxref"), xpath);
                String evidence_code = xpath.eval(swapList.item(j), "./@evidence_code").str();
                swap = new String[array.length + 1];
                swap[0] = evidence_code;
                System.arraycopy(array, 0, swap, 1, array.length);
                evidenceVector.add(swap);
                ++j;
            }
            vector.add(this.setDbxref(list.item(i), xpath));
            node = xpath.selectSingleNode(node, "gene_product");
            array = this.setDbxref(xpath.selectSingleNode(node, "dbxref"), xpath);
            String name = xpath.eval(node, "name").str();
            swap = new String[array.length + 1];
            swap[0] = name;
            System.arraycopy(array, 0, swap, 1, array.length);
            Object[] obj = new Object[]{swap, evidenceVector};
            vector.add(obj);
            ++i;
        }
        return vector;
    }

    Vector setHistory(Document doc, CachedXPathAPI xpath) throws TransformerException {
        Vector<String[]> vector = new Vector<String[]>();
        NodeList nodeList = xpath.selectNodeList(doc, "/term/history");
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String date = xpath.eval(node, "date").str();
            String person = xpath.eval(node, "person").str();
            String rationale = xpath.eval(node, "rationale").str();
            String status = "";
            String resource = "";
            if (xpath.selectSingleNode(node, "created") != null) {
                status = "created";
            } else if (xpath.selectSingleNode(node, "deleted") != null) {
                status = "deleted";
            } else if (xpath.eval(node, "split/@resource").str().length() > 0) {
                status = "split";
                resource = xpath.eval(node, "split/@resource").str();
            } else if (xpath.eval(node, "merged/@resource").str().length() > 0) {
                status = "merged";
                resource = xpath.eval(node, "merged/@resource").str();
            } else if (xpath.eval(node, "moved/@resource").str().length() > 0) {
                status = "moved";
                resource = xpath.eval(node, "moved/@resource").str();
            }
            String obsolete = xpath.eval(node, "./obsolete").str();
            String[] array = new String[]{date, person, rationale, status, resource, obsolete};
            vector.add(array);
            ++i;
        }
        return vector;
    }

    boolean setBool(Document doc, CachedXPathAPI xpath, String xqueryStr) throws TransformerException {
        String str = xpath.eval(doc, xqueryStr).str();
        return str.equals("1") || str.equals("true") || str.equals("yes");
    }

    public Vector getComment() {
        return this.comment;
    }

    public Vector getDbxref() {
        return this.dbxref;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public Vector getHistory() {
        return this.history;
    }

    public boolean isIs_obsolete() {
        return this.is_obsolete;
    }

    public int getN_associations() {
        return this.n_associations;
    }

    public Vector getSynonym() {
        return this.synonym;
    }

    public Vector getAssociation() {
        return this.association;
    }
}

