/*
 * Decompiled with CFR 0.152.
 */
package example;

import edu.hust.go.model.GoGraphModel;
import edu.hust.go.term.GO_term;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;

public class GraphModelExample {
    public static void main(String[] args) {
        block10: {
            HashMap goMap = null;
            GO_term[] term = new GO_term[2];
            int type = -1;
            if (args.length < 3) {
                GraphModelExample.printUsage();
            }
            try {
                goMap = GoGraphModel.loadGoDefinition(args[0], (byte)0);
                if (goMap == null) {
                    GraphModelExample.printUsage();
                }
                int i = 2;
                while (i < args.length && i < 4) {
                    term[i - 2] = GraphModelExample.transForm(args[i], goMap);
                    ++i;
                }
                GoGraphModel graphModel = new GoGraphModel(goMap);
                int i2 = 0;
                while (i2 < term.length) {
                    if (term[i2] != null && graphModel.getObsoleteSet().contains(term[i2])) {
                        System.out.println(term[i2].getId() + " is obsolete");
                        System.exit(-1);
                    }
                    ++i2;
                }
                if (args[1].equals("-s")) {
                    GraphModelExample.getSimilarity(graphModel, term[0], term[1], (byte)0);
                    break block10;
                }
                if (args[1].equals("-r")) {
                    GraphModelExample.getPathway(graphModel, term[0]);
                    break block10;
                }
                if (args[1].equals("-p")) {
                    GraphModelExample.getPathway(graphModel, term[0], term[1]);
                    break block10;
                }
                GraphModelExample.printUsage();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    static void getPathway(GoGraphModel graphModel, GO_term term) {
        if (graphModel == null || term == null) {
            return;
        }
        Object[][] objs = graphModel.getPathsOfNode2Root(term);
        System.out.print("The pathways between " + term.getId() + " and the root is:");
        int i = 0;
        while (i < objs.length) {
            System.out.print("\nPath " + (i + 1) + ":\t");
            int j = 0;
            while (j < objs[i].length) {
                System.out.print(((GO_term)objs[i][j]).getId() + " ");
                ++j;
            }
            ++i;
        }
    }

    static void getPathway(GoGraphModel graphModel, GO_term term1, GO_term term2) {
        if (graphModel == null || term1 == null || term2 == null) {
            return;
        }
        HashMap map = graphModel.getPathsBetweenNodes(term1, term2);
        HashSet commonSet = (HashSet)map.keySet().toArray()[0];
        Object[] commomTerms = commonSet.toArray();
        System.out.println("The common ancestors between " + term1.getId() + " and " + term2.getId() + " are:\n\t");
        int i = 0;
        while (i < commomTerms.length) {
            System.out.print(((GO_term)commomTerms[i]).getId() + " ");
            ++i;
        }
        System.out.println("\nthe commonPathways are:");
        Object[][] values = (Object[][])map.get(commonSet);
        int i2 = 0;
        while (i2 < values.length) {
            System.out.print("\nPath " + (i2 + 1) + ":\t");
            int j = 0;
            while (j < values[i2].length) {
                System.out.print(((GO_term)values[i2][j]).getId() + " ");
                ++j;
            }
            ++i2;
        }
    }

    static void getSimilarity(GoGraphModel graphModel, GO_term term1, GO_term term2, byte methodType) {
        if (graphModel == null || term1 == null || term2 == null) {
            return;
        }
        float value = graphModel.evalSimilarity(term1, term2, methodType);
        System.out.println("The semantic similarity between ");
        System.out.print(term1.getId() + " " + term2.getId() + " is: " + value);
    }

    static void printUsage() {
        System.out.println("Usage: java filaName [-s id1 id2] [-r id1] [-p id1 id2]");
        System.out.println("\tfileName the location of GO definition in OBO.");
        System.out.println("\tid1 the first GO id.");
        System.out.println("\tid2 the second GO id, if -s or -p is chosen, id2 is necessary.");
        System.out.println("\t-s evaluate the similarity between id1 and id2");
        System.out.println("\t-r find the pathways between id1 and its root");
        System.out.println("\t-p find the pathways between id1 and id2");
        System.exit(-1);
    }

    static GO_term transForm(String rawId, HashMap goMap) {
        String id = rawId;
        GO_term term = null;
        if (id.indexOf(":") >= 0) {
            id = id.substring(id.indexOf(":") + 1);
        }
        try {
            DecimalFormat df = new DecimalFormat("GO:0000000");
            id = df.format(Integer.parseInt(id.trim()));
            term = (GO_term)goMap.get(id);
        }
        catch (Exception ex) {
            System.out.println("No such go id: " + rawId + "\nPlease input a new go id");
            System.exit(-1);
        }
        return term;
    }
}

