/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.cellview;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class JGraphRoundRectView
extends VertexView {
    public static transient ActivityRenderer renderer = new ActivityRenderer();

    public JGraphRoundRectView() {
    }

    public JGraphRoundRectView(Object object) {
        super(object);
    }

    public static int getArcSize(int n, int n2) {
        int n3;
        if (n <= n2) {
            n3 = n2 / 5;
            if (n3 > n / 2) {
                n3 = n / 2;
            }
        } else {
            n3 = n / 5;
            if (n3 > n2 / 2) {
                n3 = n2 / 2;
            }
        }
        return n3;
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public static class ActivityRenderer
    extends VertexRenderer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            int n = this.borderWidth;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            boolean bl = this.selected;
            int n2 = JGraphRoundRectView.getArcSize(dimension.width - n, dimension.height - n);
            if (super.isOpaque()) {
                graphics.setColor(super.getBackground());
                if (this.gradientColor != null && !this.preview) {
                    this.setOpaque(false);
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                }
                graphics.fillRoundRect(n / 2, n / 2, dimension.width - (int)((double)n * 1.5), dimension.height - (int)((double)n * 1.5), n2, n2);
            }
            try {
                this.setBorder(null);
                this.setOpaque(false);
                this.selected = false;
                super.paint(graphics);
            }
            finally {
                this.selected = bl;
            }
            if (this.bordercolor != null) {
                graphics.setColor(this.bordercolor);
                graphics2D.setStroke(new BasicStroke(n));
                graphics.drawRoundRect(n / 2, n / 2, dimension.width - (int)((double)n * 1.5), dimension.height - (int)((double)n * 1.5), n2, n2);
            }
            if (this.selected) {
                graphics2D.setStroke(GraphConstants.SELECTION_STROKE);
                graphics.setColor(this.graph.getHighlightColor());
                graphics.drawRoundRect(n / 2, n / 2, dimension.width - (int)((double)n * 1.5), dimension.height - (int)((double)n * 1.5), n2, n2);
            }
        }
    }
}

