/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;
import org.jgraph.layout.TreeLayoutSettings;

public class TreeLayoutAlgorithm
extends JGraphLayoutAlgorithm {
    protected int alignment = 1;
    protected int orientation = 1;
    protected int levelDistance = 30;
    protected int nodeDistance = 20;
    protected boolean centerRoot = true;
    protected boolean combineLevelNodes = true;
    protected JGraph graph;
    protected Map cell2node = new HashMap();

    public String toString() {
        return "Tree Layout";
    }

    public String getHint() {
        return "Select a root node";
    }

    public JGraphLayoutSettings createSettings() {
        return new TreeLayoutSettings(this);
    }

    public void setAlignment(int n) {
        if (n != 1 && n != 0 && n != 3) {
            throw new IllegalArgumentException("Alignment must be one of TOP, CENTER or BOTTOM");
        }
        this.alignment = n;
    }

    public void setOrientation(int n) {
        if (n != 1 && n != 3 && n != 5 && n != 7) {
            throw new IllegalArgumentException("Orientation must be one of NORTH, EAST, SOUTH or WEST");
        }
        this.orientation = n;
    }

    public void setLevelDistance(int n) {
        this.levelDistance = n;
    }

    public void setNodeDistance(int n) {
        this.nodeDistance = n;
    }

    public void setCenterRoot(boolean bl) {
        this.centerRoot = bl;
    }

    public void run(JGraph jGraph, Object[] objectArray, Object[] objectArray2) {
        this.graph = jGraph;
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getMapping(new Object[]{objectArray[0]});
        List list = Arrays.asList(cellViewArray);
        Iterator<CellView> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof CellView) continue;
            iterator.remove();
        }
        list = this.buildTrees(list);
        this.layoutTrees(list);
        if (this.combineLevelNodes) {
            this.setLevelHeights(list);
        }
        this.setPosition(list);
    }

    protected List buildTrees(List list) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.buildTree((CellView)iterator.next()));
        }
        return arrayList;
    }

    protected TreeNode buildTree(CellView cellView) {
        List list = this.getChildren(cellView);
        TreeNode treeNode = this.getTreeNode(cellView);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CellView cellView2 = (CellView)iterator.next();
            TreeNode treeNode2 = this.buildTree(cellView2);
            treeNode.children.add(treeNode2);
        }
        return treeNode;
    }

    protected List getChildren(CellView cellView) {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        GraphModel graphModel = this.graph.getModel();
        Object object = cellView.getCell();
        for (int i = 0; i < graphModel.getChildCount(object); ++i) {
            Object object2 = graphModel.getChild(object, i);
            Iterator iterator = graphModel.edges(object2);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (object2 != graphModel.getSource(e)) continue;
                Object object3 = graphModel.getTarget(e);
                Object object4 = graphModel.getParent(object3);
                arrayList.add(this.graph.getGraphLayoutCache().getMapping(object4, false));
            }
        }
        return arrayList;
    }

    protected TreeNode getTreeNode(CellView cellView) {
        Object v = this.cell2node.get(cellView);
        if (v != null) {
            return (TreeNode)v;
        }
        TreeNode treeNode = new TreeNode(cellView);
        this.cell2node.put(cellView, treeNode);
        return treeNode;
    }

    protected void layoutTrees(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.layout((TreeNode)iterator.next());
        }
    }

    protected void layout(TreeNode treeNode) {
        if (treeNode.children.size() != 0) {
            if (treeNode.children.size() == 1) {
                TreeNode treeNode2 = (TreeNode)treeNode.children.get(0);
                treeNode2.depth = treeNode.depth + 1;
                this.layout(treeNode2);
                treeNode2.leftContour.dx = (treeNode2.width - treeNode.width) / 2;
                treeNode2.rightContour.dx = (treeNode2.width - treeNode.width) / 2;
                treeNode.leftContour.next = treeNode2.leftContour;
                treeNode.rightContour.next = treeNode2.rightContour;
            } else {
                Iterator iterator = treeNode.children.iterator();
                while (iterator.hasNext()) {
                    TreeNode treeNode3 = (TreeNode)iterator.next();
                    treeNode3.depth = treeNode.depth + 1;
                    this.layout(treeNode3);
                }
                this.join(treeNode);
            }
        }
    }

    protected void join(TreeNode treeNode) {
        TreeNode treeNode2;
        int n;
        TreeNode treeNode3;
        int n2;
        Object object;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < treeNode.children.size(); ++n3) {
            object = (TreeNode)treeNode.children.get(n3);
            for (n2 = n3 + 1; n2 < treeNode.children.size(); ++n2) {
                treeNode3 = (TreeNode)treeNode.children.get(n2);
                n = this.distance(((TreeNode)object).rightContour, treeNode3.leftContour) / (n2 - n3);
                n4 = Math.max(n4, n);
            }
        }
        n3 = treeNode.children.size() % 2 == 0 ? (treeNode.children.size() / 2 - 1) * n4 + n4 / 2 : treeNode.children.size() / 2 * (n4 += this.nodeDistance);
        object = treeNode.children.iterator();
        n2 = 0;
        while (object.hasNext()) {
            ((TreeNode)object.next()).x = -n3 + n2 * n4;
            ++n2;
        }
        TreeNode treeNode4 = this.getLeftMostX(treeNode);
        treeNode3 = this.getRightMostX(treeNode);
        treeNode.leftContour.next = treeNode4.leftContour;
        treeNode.rightContour.next = treeNode3.rightContour;
        for (n = 1; n < treeNode.children.size(); ++n) {
            treeNode2 = (TreeNode)treeNode.children.get(n);
            this.merge(treeNode.leftContour.next, treeNode2.leftContour, n * n4 + treeNode.width);
        }
        for (n = treeNode.children.size() - 2; n >= 0; --n) {
            treeNode2 = (TreeNode)treeNode.children.get(n);
            this.merge(treeNode.rightContour.next, treeNode2.rightContour, n * n4 + treeNode.width);
        }
        n4 = (treeNode.children.size() - 1) * n4 / 2;
        treeNode.leftContour.next.dx += n4 - treeNode.width / 2;
        treeNode.rightContour.next.dx += n4 - treeNode.width / 2;
    }

    protected TreeNode getLeftMostX(TreeNode treeNode) {
        int n = Integer.MAX_VALUE;
        TreeNode treeNode2 = null;
        Iterator iterator = treeNode.getChildren();
        while (iterator.hasNext()) {
            TreeNode treeNode3 = (TreeNode)iterator.next();
            int n2 = treeNode3.x - treeNode3.getLeftWidth();
            if (n2 >= n) continue;
            treeNode2 = treeNode3;
            n = n2;
        }
        return treeNode2 != null ? treeNode2 : (TreeNode)treeNode.children.get(0);
    }

    protected TreeNode getRightMostX(TreeNode treeNode) {
        int n = Integer.MIN_VALUE;
        TreeNode treeNode2 = null;
        Iterator iterator = treeNode.getChildren();
        while (iterator.hasNext()) {
            TreeNode treeNode3 = (TreeNode)iterator.next();
            int n2 = treeNode3.x + treeNode3.getRightWidth();
            if (n2 <= n) continue;
            treeNode2 = treeNode3;
            n = n2;
        }
        return treeNode2 != null ? treeNode2 : (TreeNode)treeNode.children.get(0);
    }

    protected void merge(PolyLine polyLine, PolyLine polyLine2, int n) {
        while (polyLine != null) {
            if (polyLine2.next == null) {
                return;
            }
            if (polyLine.next == null) {
                polyLine2 = polyLine2.next;
                break;
            }
            n += polyLine.dx - polyLine2.dx;
            polyLine = polyLine.next;
            polyLine2 = polyLine2.next;
        }
        polyLine2.dx += -n;
        polyLine.next = polyLine2;
    }

    protected int distance(PolyLine polyLine, PolyLine polyLine2) {
        int n = 0;
        int n2 = 0;
        while (polyLine != null && polyLine2 != null) {
            if ((n2 += polyLine.dx + polyLine2.dx) > 0) {
                n += n2;
                n2 = 0;
            }
            polyLine = polyLine.next;
            polyLine2 = polyLine2.next;
        }
        return n;
    }

    protected void setPosition(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((TreeNode)iterator.next()).setPosition(null, 0);
        }
    }

    protected void setLevelHeights(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = ((TreeNode)iterator.next()).getNodesByLevel();
            int n = 0;
            for (int i = 0; i < list2.size(); ++i) {
                int n2;
                List list3 = (List)list2.get(i);
                for (n2 = 0; n2 < list3.size(); ++n2) {
                    n = Math.max(n, ((TreeNode)list3.get((int)n2)).height);
                }
                for (n2 = 0; n2 < list3.size(); ++n2) {
                    ((TreeNode)list3.get((int)n2)).levelheight = n;
                }
                n = 0;
            }
        }
    }

    public boolean isCombineLevelNodes() {
        return this.combineLevelNodes;
    }

    public void setCombineLevelNodes(boolean bl) {
        this.combineLevelNodes = bl;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean isCenterRoot() {
        return this.centerRoot;
    }

    public int getLevelDistance() {
        return this.levelDistance;
    }

    public int getNodeDistance() {
        return this.nodeDistance;
    }

    public int getOrientation() {
        return this.orientation;
    }

    protected class PolyLine {
        int dx;
        PolyLine next;

        public PolyLine(int n) {
            this.dx = n;
        }
    }

    protected class TreeNode {
        List children;
        int width;
        int height;
        int x;
        int y;
        int levelheight;
        PolyLine leftContour;
        PolyLine rightContour;
        int depth;
        CellView view;

        public TreeNode(CellView cellView) {
            this.view = cellView;
            if (TreeLayoutAlgorithm.this.orientation == 1 || TreeLayoutAlgorithm.this.orientation == 5) {
                this.width = (int)cellView.getBounds().getWidth();
                this.height = (int)cellView.getBounds().getHeight();
            } else {
                this.width = (int)cellView.getBounds().getHeight();
                this.height = (int)cellView.getBounds().getWidth();
            }
            this.children = new ArrayList();
            this.leftContour = new PolyLine(this.width / 2);
            this.rightContour = new PolyLine(this.width / 2);
            this.depth = 0;
        }

        public Iterator getChildren() {
            return this.children.iterator();
        }

        public int getLeftWidth() {
            int n = 0;
            PolyLine polyLine = this.leftContour;
            int n2 = 0;
            while (polyLine != null) {
                if ((n2 += polyLine.dx) > 0) {
                    n += n2;
                    n2 = 0;
                }
                polyLine = polyLine.next;
            }
            return n;
        }

        public int getRightWidth() {
            int n = 0;
            PolyLine polyLine = this.rightContour;
            int n2 = 0;
            while (polyLine != null) {
                if ((n2 += polyLine.dx) > 0) {
                    n += n2;
                    n2 = 0;
                }
                polyLine = polyLine.next;
            }
            return n;
        }

        public int getHeight() {
            if (this.children.isEmpty()) {
                return this.levelheight;
            }
            int n = 0;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                n = Math.max(n, ((TreeNode)iterator.next()).getHeight());
            }
            return n + TreeLayoutAlgorithm.this.levelDistance + this.levelheight;
        }

        public void setPosition(Point point, int n) {
            int n2 = 0;
            Object object = this.children.iterator();
            while (object.hasNext()) {
                n2 = Math.max(n2, ((TreeNode)object.next()).height);
            }
            if (point == null) {
                int n3;
                object = this.view.getBounds();
                Rectangle rectangle = new Rectangle((int)((RectangularShape)object).getX(), (int)((RectangularShape)object).getY(), (int)((RectangularShape)object).getWidth(), (int)((RectangularShape)object).getHeight());
                Point point2 = rectangle.getLocation();
                if (TreeLayoutAlgorithm.this.centerRoot) {
                    n3 = this.getLeftWidth();
                    int n4 = this.getRightWidth();
                    int n5 = this.getHeight();
                    Insets insets = TreeLayoutAlgorithm.this.graph.getInsets();
                    if (TreeLayoutAlgorithm.this.orientation == 1) {
                        rectangle.x = n3 - this.width / 2;
                        rectangle.y = insets.top;
                    } else if (TreeLayoutAlgorithm.this.orientation == 3) {
                        rectangle.x = insets.left + n5 - this.width;
                        rectangle.y = n3 - this.height / 2;
                    } else if (TreeLayoutAlgorithm.this.orientation == 5) {
                        rectangle.x = n3 - this.width / 2;
                        rectangle.y = insets.top + n5;
                    } else if (TreeLayoutAlgorithm.this.orientation == 7) {
                        rectangle.x = insets.right;
                        rectangle.y = n3 - this.width / 2;
                    }
                    Object object2 = this.view.getCell();
                    Map map = GraphConstants.createAttributes((Object)object2, (Object)"bounds", (Object)rectangle);
                    TreeLayoutAlgorithm.this.graph.getGraphLayoutCache().edit(map, null, null, null);
                    if (TreeLayoutAlgorithm.this.orientation == 7 || TreeLayoutAlgorithm.this.orientation == 3) {
                        TreeLayoutAlgorithm.this.graph.setPreferredSize(new Dimension(n5 + insets.left + insets.right, n3 + n4 + insets.top + insets.bottom));
                    } else {
                        TreeLayoutAlgorithm.this.graph.setPreferredSize(new Dimension(n3 + n4 + insets.left + insets.right, n5 + insets.top + insets.bottom));
                    }
                    point2 = rectangle.getLocation();
                }
                if (TreeLayoutAlgorithm.this.orientation == 7 || TreeLayoutAlgorithm.this.orientation == 3) {
                    n3 = point2.x;
                    point2.x = point2.y;
                    point2.y = n3;
                }
                if (TreeLayoutAlgorithm.this.orientation == 1 || TreeLayoutAlgorithm.this.orientation == 7) {
                    point = new Point(point2.x + this.width / 2, point2.y + this.height);
                } else if (TreeLayoutAlgorithm.this.orientation == 5 || TreeLayoutAlgorithm.this.orientation == 3) {
                    point = new Point(point2.x + this.width / 2, point2.y);
                }
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((TreeNode)iterator.next()).setPosition(point, n2);
                }
                return;
            }
            if (TreeLayoutAlgorithm.this.combineLevelNodes) {
                n = this.levelheight;
            }
            object = new Rectangle(this.width, this.height);
            if (TreeLayoutAlgorithm.this.orientation == 1 || TreeLayoutAlgorithm.this.orientation == 7) {
                ((Rectangle)object).x = this.x + point.x - this.width / 2;
                ((Rectangle)object).y = point.y + TreeLayoutAlgorithm.this.levelDistance;
            } else {
                ((Rectangle)object).x = this.x + point.x - this.width / 2;
                ((Rectangle)object).y = point.y - TreeLayoutAlgorithm.this.levelDistance - this.levelheight;
            }
            if (TreeLayoutAlgorithm.this.alignment == 0) {
                ((Rectangle)object).y += (n - this.height) / 2;
            } else if (TreeLayoutAlgorithm.this.alignment == 3) {
                ((Rectangle)object).y += n - this.height;
            }
            if (TreeLayoutAlgorithm.this.orientation == 7 || TreeLayoutAlgorithm.this.orientation == 3) {
                int n6 = ((Rectangle)object).x;
                ((Rectangle)object).x = ((Rectangle)object).y;
                ((Rectangle)object).y = n6;
                n6 = ((Rectangle)object).width;
                ((Rectangle)object).width = ((Rectangle)object).height;
                ((Rectangle)object).height = n6;
            }
            Object object3 = this.view.getCell();
            Map map = GraphConstants.createAttributes((Object)object3, (Object)"bounds", (Object)object);
            TreeLayoutAlgorithm.this.graph.getGraphLayoutCache().edit(map, null, null, null);
            this.y = TreeLayoutAlgorithm.this.orientation == 1 || TreeLayoutAlgorithm.this.orientation == 7 ? point.y + TreeLayoutAlgorithm.this.levelDistance + n : point.y - TreeLayoutAlgorithm.this.levelDistance - n;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((TreeNode)iterator.next()).setPosition(new Point(this.x + point.x, this.y), n2);
            }
        }

        public List getNodesByLevel() {
            ArrayList arrayList = new ArrayList<Object>();
            Object object = this.children.iterator();
            while (object.hasNext()) {
                ArrayList<Object> arrayList2 = ((TreeNode)object.next()).getNodesByLevel();
                if (arrayList.size() < arrayList2.size()) {
                    ArrayList<Object> arrayList3 = arrayList;
                    arrayList = arrayList2;
                    arrayList2 = arrayList3;
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ((List)arrayList.get(i)).addAll((List)arrayList2.get(i));
                }
            }
            object = new ArrayList();
            ((ArrayList)object).add(this);
            arrayList.add(0, object);
            return arrayList;
        }
    }
}

