/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.EdgeFactory;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.UndirectedGraph;
import org._3pq.jgrapht.graph.AsUndirectedGraph;

public final class GraphHelper {
    private GraphHelper() {
    }

    public static Edge addEdge(Graph graph, Object object, Object object2, double d) {
        EdgeFactory edgeFactory = graph.getEdgeFactory();
        Edge edge = edgeFactory.createEdge(object, object2);
        edge.setWeight(d);
        return graph.addEdge(edge) ? edge : null;
    }

    public static boolean addEdgeWithVertices(Graph graph, Edge edge) {
        graph.addVertex(edge.getSource());
        graph.addVertex(edge.getTarget());
        return graph.addEdge(edge);
    }

    public static Edge addEdgeWithVertices(Graph graph, Object object, Object object2) {
        graph.addVertex(object);
        graph.addVertex(object2);
        return graph.addEdge(object, object2);
    }

    public static Edge addEdgeWithVertices(Graph graph, Object object, Object object2, double d) {
        graph.addVertex(object);
        graph.addVertex(object2);
        return GraphHelper.addEdge(graph, object, object2, d);
    }

    public static boolean addGraph(Graph graph, Graph graph2) {
        boolean bl = graph.addAllVertices(graph2.vertexSet());
        return bl |= graph.addAllEdges(graph2.edgeSet());
    }

    public static List neighborListOf(Graph graph, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = graph.edgesOf(object).iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            arrayList.add(edge.oppositeVertex(object));
        }
        return arrayList;
    }

    public static List predecessorListOf(DirectedGraph directedGraph, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = directedGraph.incomingEdgesOf(object);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            arrayList.add(edge.oppositeVertex(object));
        }
        return arrayList;
    }

    public static List successorListOf(DirectedGraph directedGraph, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = directedGraph.outgoingEdgesOf(object);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            arrayList.add(edge.oppositeVertex(object));
        }
        return arrayList;
    }

    public static UndirectedGraph undirectedGraph(Graph graph) {
        if (graph instanceof DirectedGraph) {
            return new AsUndirectedGraph((DirectedGraph)graph);
        }
        if (graph instanceof UndirectedGraph) {
            return (UndirectedGraph)graph;
        }
        throw new IllegalArgumentException("Graph must be either DirectedGraph or UndirectedGraph");
    }
}

