/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.demo;

import java.io.IOException;
import org._3pq.jgrapht.graph.Pseudograph;
import org._3pq.jgrapht.traverse.BreadthFirstIterator;
import org._3pq.jgrapht.traverse.DepthFirstIterator;

public final class PerformanceDemo {
    public static void main(String[] stringArray) {
        Object object;
        long l = System.currentTimeMillis();
        PerformanceDemo.reportPerformanceFor("starting at", l);
        Pseudograph pseudograph = new Pseudograph();
        Object object2 = object = new Object();
        pseudograph.addVertex(object);
        int n = 10000;
        int n2 = 200;
        int n3 = n * (1 + n2);
        System.out.println("\nallocating graph with " + n3 + " elements (may take a few tens of seconds)...");
        int n4 = 0;
        while (n4 < n) {
            object2 = new Object();
            pseudograph.addVertex(object2);
            int n5 = 0;
            while (n5 < n2) {
                pseudograph.addEdge(object, object2);
                ++n5;
            }
            object = object2;
            ++n4;
        }
        PerformanceDemo.reportPerformanceFor("graph allocation", l);
        l = System.currentTimeMillis();
        BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(pseudograph);
        while (breadthFirstIterator.hasNext()) {
            breadthFirstIterator.next();
        }
        PerformanceDemo.reportPerformanceFor("breadth traversal", l);
        l = System.currentTimeMillis();
        DepthFirstIterator depthFirstIterator = new DepthFirstIterator(pseudograph);
        while (depthFirstIterator.hasNext()) {
            depthFirstIterator.next();
        }
        PerformanceDemo.reportPerformanceFor("depth traversal", l);
        System.out.println("\nPaused: graph is still in memory (to check mem consumption).");
        System.out.print("press any key to free memory and finish...");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("done.");
    }

    private static void reportPerformanceFor(String string, long l) {
        double d = (double)(System.currentTimeMillis() - l) / 1000.0;
        double d2 = (double)PerformanceDemo.usedMemory() / 1048576.0;
        d2 = (double)Math.round(d2 * 100.0) / 100.0;
        System.out.println(string + " (" + d + " sec, " + d2 + "MB)");
    }

    private static long usedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }
}

