/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.traverse;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.event.ConnectedComponentTraversalEvent;
import org._3pq.jgrapht.event.EdgeTraversalEvent;
import org._3pq.jgrapht.event.VertexTraversalEvent;
import org._3pq.jgrapht.traverse.AbstractGraphIterator;

public abstract class CrossComponentIterator
extends AbstractGraphIterator {
    private static final int CCS_BEFORE_COMPONENT = 1;
    private static final int CCS_WITHIN_COMPONENT = 2;
    private static final int CCS_AFTER_COMPONENT = 3;
    private final ConnectedComponentTraversalEvent m_ccFinishedEvent = new ConnectedComponentTraversalEvent(this, 32);
    private final ConnectedComponentTraversalEvent m_ccStartedEvent = new ConnectedComponentTraversalEvent(this, 31);
    private FlyweightEdgeEvent m_reusableEdgeEvent;
    private FlyweightVertexEvent m_reusableVertexEvent;
    private Iterator m_vertexIterator = null;
    private Map m_seen = new HashMap();
    private Object m_startVertex;
    private Specifics m_specifics;
    private int m_state = 1;

    public CrossComponentIterator(Graph graph, Object object) {
        if (graph == null) {
            throw new NullPointerException("graph must not be null");
        }
        this.m_specifics = CrossComponentIterator.createGraphSpecifics(graph);
        this.m_vertexIterator = graph.vertexSet().iterator();
        this.setCrossComponentTraversal(object == null);
        this.m_reusableEdgeEvent = new FlyweightEdgeEvent(this, null);
        this.m_reusableVertexEvent = new FlyweightVertexEvent(this, null);
        if (object == null) {
            this.m_startVertex = this.m_vertexIterator.hasNext() ? this.m_vertexIterator.next() : null;
        } else if (graph.containsVertex(object)) {
            this.m_startVertex = object;
        } else {
            throw new IllegalArgumentException("graph must contain the start vertex");
        }
    }

    public boolean hasNext() {
        if (this.m_startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.isConnectedComponentExhausted()) {
            if (this.m_state == 2) {
                this.m_state = 3;
                this.fireConnectedComponentFinished(this.m_ccFinishedEvent);
            }
            if (this.isCrossComponentTraversal()) {
                while (this.m_vertexIterator.hasNext()) {
                    Object e = this.m_vertexIterator.next();
                    if (this.m_seen.containsKey(e)) continue;
                    this.encounterVertex(e, null);
                    this.m_state = 1;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public Object next() {
        if (this.m_startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            if (this.m_state == 1) {
                this.m_state = 2;
                this.fireConnectedComponentStarted(this.m_ccStartedEvent);
            }
            Object object = this.provideNextVertex();
            this.fireVertexTraversed(this.createVertexTraversalEvent(object));
            this.addUnseenChildrenOf(object);
            return object;
        }
        throw new NoSuchElementException();
    }

    protected abstract boolean isConnectedComponentExhausted();

    protected abstract void encounterVertex(Object var1, Edge var2);

    protected abstract Object provideNextVertex();

    protected Object getSeenData(Object object) {
        return this.m_seen.get(object);
    }

    protected abstract void encounterVertexAgain(Object var1, Edge var2);

    protected Object putSeenData(Object object, Object object2) {
        return this.m_seen.put(object, object2);
    }

    static Specifics createGraphSpecifics(Graph graph) {
        if (graph instanceof DirectedGraph) {
            return new DirectedSpecifics((DirectedGraph)graph);
        }
        return new UndirectedSpecifics(graph);
    }

    private void addUnseenChildrenOf(Object object) {
        List list = this.m_specifics.edgesOf(object);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            this.fireEdgeTraversed(this.createEdgeTraversalEvent(edge));
            Object object2 = edge.oppositeVertex(object);
            if (this.m_seen.containsKey(object2)) {
                this.encounterVertexAgain(object2, edge);
                continue;
            }
            this.encounterVertex(object2, edge);
        }
    }

    private EdgeTraversalEvent createEdgeTraversalEvent(Edge edge) {
        if (this.isReuseEvents()) {
            this.m_reusableEdgeEvent.setEdge(edge);
            return this.m_reusableEdgeEvent;
        }
        return new EdgeTraversalEvent(this, edge);
    }

    private VertexTraversalEvent createVertexTraversalEvent(Object object) {
        if (this.isReuseEvents()) {
            this.m_reusableVertexEvent.setVertex(object);
            return this.m_reusableVertexEvent;
        }
        return new VertexTraversalEvent(this, object);
    }

    private void encounterStartVertex() {
        this.encounterVertex(this.m_startVertex, null);
        this.m_startVertex = null;
    }

    private static class UndirectedSpecifics
    extends Specifics {
        private Graph m_graph;

        public UndirectedSpecifics(Graph graph) {
            this.m_graph = graph;
        }

        public List edgesOf(Object object) {
            return this.m_graph.edgesOf(object);
        }
    }

    private static class DirectedSpecifics
    extends Specifics {
        private DirectedGraph m_graph;

        public DirectedSpecifics(DirectedGraph directedGraph) {
            this.m_graph = directedGraph;
        }

        public List edgesOf(Object object) {
            return this.m_graph.outgoingEdgesOf(object);
        }
    }

    static class FlyweightVertexEvent
    extends VertexTraversalEvent {
        public FlyweightVertexEvent(Object object, Object object2) {
            super(object, object2);
        }

        protected void setVertex(Object object) {
            this.m_vertex = object;
        }
    }

    static class FlyweightEdgeEvent
    extends EdgeTraversalEvent {
        public FlyweightEdgeEvent(Object object, Edge edge) {
            super(object, edge);
        }

        protected void setEdge(Edge edge) {
            this.m_edge = edge;
        }
    }

    static abstract class Specifics {
        Specifics() {
        }

        public abstract List edgesOf(Object var1);
    }

    static interface SimpleContainer {
        public boolean isEmpty();

        public void add(Object var1);

        public Object remove();
    }
}

