/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.traverse;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.event.ConnectedComponentTraversalEvent;
import org._3pq.jgrapht.event.EdgeTraversalEvent;
import org._3pq.jgrapht.event.VertexTraversalEvent;
import org._3pq.jgrapht.traverse.AbstractGraphIterator;
import org._3pq.jgrapht.traverse.CrossComponentIterator;

final class TraverseUtils {
    private TraverseUtils() {
    }

    static class XXFirstIterator
    extends AbstractGraphIterator {
        private static final int CCS_BEFORE_COMPONENT = 1;
        private static final int CCS_WITHIN_COMPONENT = 2;
        private static final int CCS_AFTER_COMPONENT = 3;
        private final ConnectedComponentTraversalEvent m_ccFinishedEvent = new ConnectedComponentTraversalEvent(this, 32);
        private final ConnectedComponentTraversalEvent m_ccStartedEvent = new ConnectedComponentTraversalEvent(this, 31);
        private CrossComponentIterator.FlyweightEdgeEvent m_reuseableEdgeEvent;
        private CrossComponentIterator.FlyweightVertexEvent m_reuseableVertexEvent;
        private Iterator m_vertexIterator = null;
        private Map m_seen = new HashMap();
        private SimpleContainer m_pending;
        private CrossComponentIterator.Specifics m_specifics;
        private int m_state = 1;

        public XXFirstIterator(Graph graph, Object object, SimpleContainer simpleContainer) {
            if (graph == null) {
                throw new NullPointerException("graph must not be null");
            }
            this.m_pending = simpleContainer;
            this.m_specifics = CrossComponentIterator.createGraphSpecifics(graph);
            this.m_vertexIterator = graph.vertexSet().iterator();
            this.setCrossComponentTraversal(object == null);
            this.m_reuseableEdgeEvent = new CrossComponentIterator.FlyweightEdgeEvent(this, null);
            this.m_reuseableVertexEvent = new CrossComponentIterator.FlyweightVertexEvent(this, null);
            if (object == null) {
                if (this.m_vertexIterator.hasNext()) {
                    Object e = this.m_vertexIterator.next();
                    this.encounterVertex(e, null);
                }
            } else if (graph.containsVertex(object)) {
                this.encounterVertex(object, null);
            } else {
                throw new IllegalArgumentException("graph must contain the start vertex");
            }
        }

        public boolean hasNext() {
            if (this.m_pending.isEmpty()) {
                if (this.m_state == 2) {
                    this.m_state = 3;
                    this.fireConnectedComponentFinished(this.m_ccFinishedEvent);
                }
                if (this.isCrossComponentTraversal()) {
                    while (this.m_vertexIterator.hasNext()) {
                        Object e = this.m_vertexIterator.next();
                        if (this.m_seen.containsKey(e)) continue;
                        this.encounterVertex(e, null);
                        this.m_state = 1;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.hasNext()) {
                if (this.m_state == 1) {
                    this.m_state = 2;
                    this.fireConnectedComponentStarted(this.m_ccStartedEvent);
                }
                Object object = this.m_pending.remove();
                this.fireVertexTraversed(this.createVertexTraversalEvent(object));
                this.addUnseenChildrenOf(object);
                return object;
            }
            throw new NoSuchElementException();
        }

        protected Object getSeenData(Object object) {
            return this.m_seen.get(object);
        }

        protected void encounterVertexAgain(Object object, Edge edge) {
        }

        protected Object newSeenData(Object object, Edge edge) {
            return object;
        }

        private final void encounterVertex(Object object, Edge edge) {
            Object object2 = this.newSeenData(object, edge);
            this.m_seen.put(object, object2);
            this.m_pending.add(object2);
        }

        private void addUnseenChildrenOf(Object object) {
            List list = this.m_specifics.edgesOf(object);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                this.fireEdgeTraversed(this.createEdgeTraversalEvent(edge));
                Object object2 = edge.oppositeVertex(object);
                if (this.m_seen.containsKey(object2)) {
                    this.encounterVertexAgain(object2, edge);
                    continue;
                }
                this.encounterVertex(object2, edge);
            }
        }

        private EdgeTraversalEvent createEdgeTraversalEvent(Edge edge) {
            if (this.isReuseEvents()) {
                this.m_reuseableEdgeEvent.setEdge(edge);
                return this.m_reuseableEdgeEvent;
            }
            return new EdgeTraversalEvent(this, edge);
        }

        private VertexTraversalEvent createVertexTraversalEvent(Object object) {
            if (this.isReuseEvents()) {
                this.m_reuseableVertexEvent.setVertex(object);
                return this.m_reuseableVertexEvent;
            }
            return new VertexTraversalEvent(this, object);
        }
    }

    static interface SimpleContainer {
        public boolean isEmpty();

        public void add(Object var1);

        public Object remove();
    }
}

