package edu.hust.go.gui;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import java.awt.event.MouseEvent;
import javax.swing.ToolTipManager;

import org.jgraph.JGraph;
import org.jgraph.graph.DefaultGraphModel;

public class GoGraphView
    extends JGraph {
    public GoGraphView(DefaultGraphModel model) {
        super(model);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public String getToolTipText(MouseEvent event) {
        Object cell = getFirstCellForLocation(event.getX(), event.getY());
        if (cell instanceof GoCell) {
            return ( (GoCell) cell).getToolTipString();
        }else if(cell instanceof GoEdge){
            return ((GoEdge)cell).getToolTipString();
        }
        return null;
    }

}