package edu.hust.go.gui;

/**
 * <p>Title: GO4J</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * This is for test
 * @author GQ Zhang
 * @version 1.0
 */
import java.util.HashMap;
import java.util.Hashtable;

import java.util.ArrayList;
import java.util.Enumeration;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultMutableTreeNode;
import java.io.*;

import java.util.*;
import edu.hust.go.term.GO_term;
import org._3pq.jgrapht.graph.SimpleDirectedGraph;

import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.util.JGraphUtilities;
import org.jgraph.layout.TreeLayoutAlgorithm;
import org.jgraph.layout.SpringEmbeddedLayoutAlgorithm;

import edu.hust.go.model.*;

/**
 * Three kinds of graphical pathways can be displayed.
 * The pathway is a set of nodes connected by "is_a" or "part of". In general,
 * it is from one of three root nodes to the target nodes. Here, the pathway can
 * be expanded or shorten with defined parent or child level. For parents, 0 means
 * the pathway should begin from one of 3 root nodes, -1 means the pathway should
 * not including parent nodes and begin from itself, and positive integer n means
 * the pathway should include n level nodes from itself to root. For children, 0
 * means the pathway should ends at its final leaf nodes, -1 means the pathway
 * should not include any children and end at itself, and positive integer means
 * the pathway shoudl include n level nodes from itself to final leaf nodes.In
 * default, the parent level should be 0, and child level should be -1.
 */
public class GraphCreator {
    private static Color queryColor = Color.RED;
    private static Color commonColor = Color.BLUE;
    private static Color rootColor = Color.GREEN;
    private static Color uniqueColor=Color.BLACK;

    public static final byte JTREEGRAPHVIEW = 0;
    public static final byte JTREEVIEW = 1;
    public static final byte JGRAPHVIEW = 2;

    /**Construct GUI by GO ids
     * @param goids every ids should be in the style of GO:*******
     * @param goMap the key is GO ids, the value is GO terms.
     * @param viewType GUI type,should be one of JTREEVIEW,JGRAPHVIEW,JTREEGRAPHVIEW
     * @param childLevel -1 means discard children, 0 means all children
     * postive integer means the depth from itself to corresponding children
     * @return two elements, element one is JComponent, element two is String
     */
    public static Object[] query(String[] goids, HashMap goMap, byte viewType, int childLevel) {
        GoGraphModel model = null;
        try {
            model = new GoGraphModel(goMap);
        }
        catch (GoException e) {
            System.out.println(e);
            return null;
        }
        ArrayList[] goLists = transForm(goids, goMap, model.getObsoleteSet());
        StringWriter writer = new StringWriter();
        for (int i = 0; i < goLists.length; i++) {
            if (i == 0) {
                writer.write("Aviable GO terms:\n");
            }
            else if (i == 1 && goLists[i].size() > 0) {
                writer.write("\nObsolete GO terms:\n");
            }
            else if (i == 2 && goLists[i].size() > 0) {
                writer.write("\nNot exist id:\n");
            }
            for (int j = 0; j < goLists[i].size(); j++) {
                writer.write("\t"+goLists[i].get(j) + "\n");
            }
        }
        writer.write("\n");
        Object [] result={createView(model, goLists[0], viewType,0, childLevel),writer.toString()};
        return result;
    }

    /**transforms standard GO ids into GO terms.
     * @param goids every ids should be in the style of GO:*******
     * @param goMap the key is GO ids, the value is GO terms.
     * @param obsoleteSet the obsolete GO terms does not exist in graph model
         * @return three GO terms list: aviable, obsolete, not-exist GO ids. The former two are GO terms, the latter is String
     */
    public static ArrayList[] transForm(String[] goids, HashMap goMap, HashSet obsoleteSet) {
        ArrayList[] lists = {
            new ArrayList(), new ArrayList(), new ArrayList()};
        for (int i = 0; i < goids.length; i++) {
            Object term = goMap.get(goids[i]);
            if (term == null) {
                lists[2].add(goids[i]);
            }
            else if (obsoleteSet.contains(term)) {
                lists[1].add(term);
            }
            else {
                lists[0].add(term);
            }
        }
        return lists;
    }

    /**Construct GUI by GO terms
     * @param graph the graph model including all GO terms except obsolete terms
     * @param golist aviable query GO terms
     * @param viewType GUI type,should be one of JTREEVIEW,JGRAPHVIEW,JTREEGRAPHVIEW
     * @param parentLevel -1 means discard parents, 0 means all parents
     * postive integer means the depth from itself to corresponding parents
     * @param childLevel -1 means discard children, 0 means all children
     * postive integer means the depth from itself to corresponding children
     * @return
     */
    public static JComponent createView(GoGraphModel graph, ArrayList golist, byte viewType,
                                    int parentLevel,int childLevel) {
        JComponent view;
        SimpleDirectedGraph subGraph = graph.buildSubGraph(golist, parentLevel, childLevel);
        HashSet commonSet = graph.getCommonParents(golist);
        switch (viewType) {
            case JTREEVIEW:
                view = createTree(subGraph);
                break;
            case JGRAPHVIEW:
                view = createJGraph(subGraph, golist, commonSet);
                break;
            case JTREEGRAPHVIEW:
                view = createTreeGraph(subGraph, golist, commonSet);
                break;
            default:
                view = null;
        }
        return view;
    }

    /**create a graph in the tree type
     * @param subGraph target graph model
     * @param goList aviable GO terms list
     * @param commonSet GO terms set in the common pathways of aviable GO terms
     * @return graph view
     */
    private static GoGraphView createTreeGraph(SimpleDirectedGraph subGraph, ArrayList goList, HashSet commonSet) {
        Object[] goRoots = GoGraphModel.getRoots(subGraph);
        Hashtable graphtCellTable = buildTreeCells(subGraph);
        ArrayList jgraphCellList = new ArrayList();

        GoCell topRoot = new GoCell("TOP", false);
        jgraphCellList.add(topRoot);

        for (int i = 0; i < goRoots.length; i++) {
            GoCell modelCell = (GoCell) graphtCellTable.get(goRoots[i]);
            GoCell viewCell = new GoCell( (GO_term) modelCell.getUserObject());
            GraphConstants.setForeground(viewCell.getAttributes(), rootColor);
            jgraphCellList.add(viewCell);
            GoEdge edge = new GoEdge(topRoot, viewCell);
            jgraphCellList.add(edge);
            jgraphCellList.addAll(getAllChild(viewCell, modelCell, goList, commonSet));
        }
        DefaultGraphModel model = new DefaultGraphModel();
        GoGraphView jgraph = new GoGraphView(model);
        jgraph.getGraphLayoutCache().insert(jgraphCellList.toArray());

        JGraphUtilities myGraphUtilities = new JGraphUtilities();
        myGraphUtilities.applyLayout(jgraph, new TreeLayoutAlgorithm());
        return jgraph;
    }

    /**create a standard tree
     * @param subGraph target graph model
     * @return tree view
     */
    private static JTree createTree(SimpleDirectedGraph subGraph) {
        Object[] roots = GoGraphModel.getRoots(subGraph);
        Hashtable cellTable = buildTreeCells(subGraph);
        DefaultMutableTreeNode topRoot = new DefaultMutableTreeNode("TOP");
        for (int i = 0; i < roots.length; i++) {
            GoCell cell = (GoCell) cellTable.get(roots[i]);
            topRoot.add(cell);
        }
        DefaultTreeModel model = new DefaultTreeModel(topRoot);
        GoTreeView tree = new GoTreeView(model);
        tree.setRootVisible(false);
        return tree;
    }

    /**create a standard graph without redunt nodes
     * @param subGraph target graph model
     * @queryTermList query GO terms list
     * @return graph view
     */
    private static GoGraphView createJGraph(SimpleDirectedGraph subGraph, ArrayList queryTermList, HashSet commonSet) {
        Hashtable cellTable = buildJGraphCell(subGraph);

        Object[] objs=subGraph.vertexSet().toArray();
        for(int i=0;i<objs.length;i++){
            GoCell cell=(GoCell)cellTable.get(objs[i]);
            if(queryTermList.contains(objs[i])){
                GraphConstants.setForeground(cell.getAttributes(), queryColor);
            }else if(commonSet.contains(objs[i])){
                GraphConstants.setForeground(cell.getAttributes(), commonColor);
            }
        }
        Object[] roots=GoGraphModel.getRoots(subGraph);
        for(int i=0;i<roots.length;i++){
            GoCell cell=(GoCell)cellTable.get(roots[i]);
            GraphConstants.setForeground(cell.getAttributes(), rootColor);
        }

        DefaultGraphModel model = new DefaultGraphModel();
        GoGraphView jgraph = new GoGraphView(model);
        jgraph.getGraphLayoutCache().insert(cellTable.values().toArray());

        JGraphUtilities myGraphUtilities = new JGraphUtilities();
        myGraphUtilities.applyLayout(jgraph, new SpringEmbeddedLayoutAlgorithm());
        return jgraph;
    }

    /**constructs all graph nodes into cells, which can be presened in GUI.
     * If one node has multiple parent nodes, it will be copied n times when converting nodes into cells.
     * Thus there are redunt cells in the returned table.
     * @param _subGraph target graph model
     * @return the key is nodes in graph model (edu.hust.go.term.GO_term),
     * while the value is cell(edu.hust.go.gui.GoCell)
     */
    private static Hashtable buildTreeCells(SimpleDirectedGraph _subGraph) {
        Hashtable cellTable = new Hashtable();
        Hashtable table = new Hashtable();
        //gets the children of each nodes from top to bottom
        //the class type of children is edu.hust.go.term.GO_term
        SimpleDirectedGraph subGraph = (SimpleDirectedGraph) _subGraph.clone();
        Object[] nodes = GoGraphModel.getRoots(subGraph);
        while (nodes.length > 0) {
            for (int i = 0; i < nodes.length; i++) {
                Vector vector = new Vector();
                Object[] outgoingEdges = subGraph.outgoingEdgesOf(nodes[i]).toArray();
                for (int j = 0; j < outgoingEdges.length; j++) {
                    vector.add( ( (MyEdge) outgoingEdges[j]).getTarget());
                }
                table.put(nodes[i], vector);
                subGraph.removeVertex(nodes[i]);
            }
            nodes = GoGraphModel.getRoots(subGraph);
        }
        //converts GO terms into GO cells from bottom to top
        //the class type is edu.hust.go.gui.GoCell
        subGraph = (SimpleDirectedGraph) _subGraph.clone();
        nodes = GoGraphModel.getLeave(subGraph);
        while (nodes.length > 0) {
            for (int i = 0; i < nodes.length; i++) {
                GoCell cell = new GoCell( (GO_term) nodes[i]);
                Vector vector = (Vector) table.get(nodes[i]);
                for (int j = 0; j < vector.size(); j++) {
                    GoCell childCell = (GoCell) cellTable.get(vector.get(j));
                    cell.add( (GoCell) childCell.clone());
                }
                cellTable.put(nodes[i], cell);
                subGraph.removeVertex(nodes[i]);
            }
            nodes = GoGraphModel.getLeave(subGraph);
        }

        return cellTable;
    }

    /**constructs all graph nodes into cells, which can be presened in GUI.
     * No redunt nodes in the GUI graph
     * @param _subGraph target graph model
     * @return the key is nodes in graph model (edu.hust.go.term.GO_term),
     * while the value is cell(edu.hust.go.gui.GoCell)
     */
    private static Hashtable buildJGraphCell(SimpleDirectedGraph _subGraph) {
        Hashtable cellTable = new Hashtable();
        SimpleDirectedGraph subGraph = (SimpleDirectedGraph) _subGraph.clone();
        Object[] nodes = GoGraphModel.getRoots(subGraph);
        while (nodes.length > 0) {
            for (int i = 0; i < nodes.length; i++) {
                GoCell sourceCell = (cellTable.get(nodes[i]) == null) ? (new GoCell( (GO_term) nodes[i])) :
                    (GoCell) cellTable.get(nodes[i]);
                cellTable.put(nodes[i], sourceCell);
                Object[] edges = subGraph.outgoingEdgesOf(nodes[i]).toArray();
                for (int j = 0; j < edges.length; j++) {
                    Object target = ( (MyEdge) edges[j]).getTarget();
                    GoCell targetCell = (cellTable.get(target) == null) ? (new GoCell( (GO_term) target)) :
                        (GoCell) cellTable.get(target);
                    GoEdge edge = new GoEdge(sourceCell, targetCell);
                    cellTable.put(target, targetCell);
                    cellTable.put(nodes[i]+""+target,edge);
                }
                subGraph.removeVertex(nodes[i]);
            }
            nodes = GoGraphModel.getRoots(subGraph);
        }
        return cellTable;
    }

    /**Connects curModelCell and its children by GoEdge.
     * The value of the curModelCell is identical with the curViewCell, but they have different usage.
     * the curViewCell and its connection to children should be presented in GUI,
     * while curModelCell is used to construct such connections.
     * @param curViewCell target GUI cell
     * @param curModelCell taget model cell, its userObject is same as curViewCell
     * @param queryTermList raw query GO terms should display in different color in GUI
         * @param commonSet the common GO terms in the pathways of raw GO query terms should display in different color in GUI
     * @return: GUI cells and edges
     */
    private static ArrayList getAllChild(GoCell curViewCell, GoCell curModelCell, ArrayList queryTermList, HashSet commonSet) {
        ArrayList list = new ArrayList();
        Enumeration children = ( (GoCell) curModelCell).children();
        while (children.hasMoreElements()) {
            Object childCell = children.nextElement();
            if (! (childCell instanceof GoCell)) {
                continue;
            }
            GoCell childModelCell = (GoCell) childCell;
            Object childObj = (GO_term) childModelCell.getUserObject();
            GoCell childViewCell = new GoCell( (GO_term) childObj);
            if (queryTermList.contains(childObj)) {
                GraphConstants.setForeground(childViewCell.getAttributes(), queryColor);
            }
            if (commonSet.contains(childObj)) {
                GraphConstants.setForeground(childViewCell.getAttributes(), commonColor);
            }
            GoEdge edge = new GoEdge(curViewCell, childViewCell);
            list.add(childViewCell);
            list.add(edge);
            list.addAll(getAllChild(childViewCell, childModelCell, queryTermList, commonSet));
        }
        return list;
    }

}