/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;

public class DefaultGraphCell
extends DefaultMutableTreeNode
implements GraphCell,
Cloneable {
    public static final Rectangle defaultBounds = new Rectangle(10, 10, 20, 20);
    protected AttributeMap attributes = null;

    public DefaultGraphCell() {
        this(null);
    }

    public DefaultGraphCell(Object object) {
        this(object, null);
    }

    public DefaultGraphCell(Object object, AttributeMap attributeMap) {
        this(object, attributeMap, null);
    }

    public DefaultGraphCell(Object object, AttributeMap attributeMap, MutableTreeNode[] mutableTreeNodeArray) {
        super(object, true);
        this.setAttributes(attributeMap);
        if (mutableTreeNodeArray != null) {
            for (int i = 0; i < mutableTreeNodeArray.length; ++i) {
                this.add(mutableTreeNodeArray[i]);
            }
        }
    }

    public List getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public Map changeAttributes(Map map) {
        AttributeMap attributeMap = this.attributes.applyMap(map);
        Rectangle2D rectangle2D = GraphConstants.getBounds(this.attributes);
        if (rectangle2D == null) {
            GraphConstants.setBounds(this.attributes, defaultBounds);
        }
        return attributeMap;
    }

    public void setAttributes(AttributeMap attributeMap) {
        if (attributeMap == null) {
            attributeMap = new AttributeMap();
        }
        this.attributes = attributeMap;
        if (GraphConstants.getBounds(attributeMap) == null) {
            GraphConstants.setBounds(attributeMap, defaultBounds);
        }
    }

    public Object clone() {
        DefaultGraphCell defaultGraphCell = (DefaultGraphCell)super.clone();
        defaultGraphCell.attributes = (AttributeMap)this.attributes.clone();
        return defaultGraphCell;
    }
}

