/*
 * Decompiled with CFR 0.152.
 */
package edu.hust.go.gui;

import edu.hust.go.gui.GoCell;
import edu.hust.go.gui.GoEdge;
import edu.hust.go.gui.GoGraphView;
import edu.hust.go.gui.GoTreeView;
import edu.hust.go.model.GoException;
import edu.hust.go.model.GoGraphModel;
import edu.hust.go.model.MyEdge;
import edu.hust.go.term.GO_term;
import java.awt.Color;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org._3pq.jgrapht.graph.SimpleDirectedGraph;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.layout.SpringEmbeddedLayoutAlgorithm;
import org.jgraph.layout.TreeLayoutAlgorithm;
import org.jgraph.util.JGraphUtilities;

public class GraphCreator {
    private static Color queryColor = Color.RED;
    private static Color commonColor = Color.BLUE;
    private static Color rootColor = Color.GREEN;
    private static Color uniqueColor = Color.BLACK;
    public static final byte JTREEGRAPHVIEW = 0;
    public static final byte JTREEVIEW = 1;
    public static final byte JGRAPHVIEW = 2;

    public static Object[] query(String[] goids, HashMap goMap, byte viewType, int childLevel) {
        GoGraphModel model = null;
        try {
            model = new GoGraphModel(goMap);
        }
        catch (GoException e) {
            System.out.println(e);
            return null;
        }
        ArrayList[] goLists = GraphCreator.transForm(goids, goMap, model.getObsoleteSet());
        StringWriter writer = new StringWriter();
        int i = 0;
        while (i < goLists.length) {
            if (i == 0) {
                writer.write("Aviable GO terms:\n");
            } else if (i == 1 && goLists[i].size() > 0) {
                writer.write("\nObsolete GO terms:\n");
            } else if (i == 2 && goLists[i].size() > 0) {
                writer.write("\nNot exist id:\n");
            }
            int j = 0;
            while (j < goLists[i].size()) {
                writer.write("\t" + goLists[i].get(j) + "\n");
                ++j;
            }
            ++i;
        }
        writer.write("\n");
        Object[] result = new Object[]{GraphCreator.createView(model, goLists[0], viewType, 0, childLevel), writer.toString()};
        return result;
    }

    public static ArrayList[] transForm(String[] goids, HashMap goMap, HashSet obsoleteSet) {
        ArrayList[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        int i = 0;
        while (i < goids.length) {
            Object term = goMap.get(goids[i]);
            if (term == null) {
                lists[2].add(goids[i]);
            } else if (obsoleteSet.contains(term)) {
                lists[1].add(term);
            } else {
                lists[0].add(term);
            }
            ++i;
        }
        return lists;
    }

    public static JComponent createView(GoGraphModel graph, ArrayList golist, byte viewType, int parentLevel, int childLevel) {
        JComponent view;
        SimpleDirectedGraph subGraph = graph.buildSubGraph(golist, parentLevel, childLevel);
        HashSet commonSet = graph.getCommonParents(golist);
        switch (viewType) {
            case 1: {
                view = GraphCreator.createTree(subGraph);
                break;
            }
            case 2: {
                view = GraphCreator.createJGraph(subGraph, golist, commonSet);
                break;
            }
            case 0: {
                view = GraphCreator.createTreeGraph(subGraph, golist, commonSet);
                break;
            }
            default: {
                view = null;
            }
        }
        return view;
    }

    private static GoGraphView createTreeGraph(SimpleDirectedGraph subGraph, ArrayList goList, HashSet commonSet) {
        Object[] goRoots = GoGraphModel.getRoots(subGraph);
        Hashtable graphtCellTable = GraphCreator.buildTreeCells(subGraph);
        ArrayList<DefaultGraphCell> jgraphCellList = new ArrayList<DefaultGraphCell>();
        GoCell topRoot = new GoCell((Object)"TOP", false);
        jgraphCellList.add(topRoot);
        int i = 0;
        while (i < goRoots.length) {
            GoCell modelCell = (GoCell)graphtCellTable.get(goRoots[i]);
            GoCell viewCell = new GoCell((GO_term)modelCell.getUserObject());
            GraphConstants.setForeground(viewCell.getAttributes(), rootColor);
            jgraphCellList.add(viewCell);
            GoEdge edge = new GoEdge(topRoot, viewCell);
            jgraphCellList.add(edge);
            jgraphCellList.addAll(GraphCreator.getAllChild(viewCell, modelCell, goList, commonSet));
            ++i;
        }
        DefaultGraphModel model = new DefaultGraphModel();
        GoGraphView jgraph = new GoGraphView(model);
        jgraph.getGraphLayoutCache().insert(jgraphCellList.toArray());
        JGraphUtilities myGraphUtilities = new JGraphUtilities();
        JGraphUtilities.applyLayout(jgraph, new TreeLayoutAlgorithm());
        return jgraph;
    }

    private static JTree createTree(SimpleDirectedGraph subGraph) {
        Object[] roots = GoGraphModel.getRoots(subGraph);
        Hashtable cellTable = GraphCreator.buildTreeCells(subGraph);
        DefaultMutableTreeNode topRoot = new DefaultMutableTreeNode("TOP");
        int i = 0;
        while (i < roots.length) {
            GoCell cell = (GoCell)cellTable.get(roots[i]);
            topRoot.add(cell);
            ++i;
        }
        DefaultTreeModel model = new DefaultTreeModel(topRoot);
        GoTreeView tree = new GoTreeView(model);
        tree.setRootVisible(false);
        return tree;
    }

    private static GoGraphView createJGraph(SimpleDirectedGraph subGraph, ArrayList queryTermList, HashSet commonSet) {
        Hashtable cellTable = GraphCreator.buildJGraphCell(subGraph);
        Object[] objs = subGraph.vertexSet().toArray();
        int i = 0;
        while (i < objs.length) {
            GoCell cell = (GoCell)cellTable.get(objs[i]);
            if (queryTermList.contains(objs[i])) {
                GraphConstants.setForeground(cell.getAttributes(), queryColor);
            } else if (commonSet.contains(objs[i])) {
                GraphConstants.setForeground(cell.getAttributes(), commonColor);
            }
            ++i;
        }
        Object[] roots = GoGraphModel.getRoots(subGraph);
        int i2 = 0;
        while (i2 < roots.length) {
            GoCell cell = (GoCell)cellTable.get(roots[i2]);
            GraphConstants.setForeground(cell.getAttributes(), rootColor);
            ++i2;
        }
        DefaultGraphModel model = new DefaultGraphModel();
        GoGraphView jgraph = new GoGraphView(model);
        jgraph.getGraphLayoutCache().insert(cellTable.values().toArray());
        JGraphUtilities myGraphUtilities = new JGraphUtilities();
        JGraphUtilities.applyLayout(jgraph, new SpringEmbeddedLayoutAlgorithm());
        return jgraph;
    }

    private static Hashtable buildTreeCells(SimpleDirectedGraph _subGraph) {
        int j;
        int i;
        Hashtable<Object, GoCell> cellTable = new Hashtable<Object, GoCell>();
        Hashtable table = new Hashtable();
        SimpleDirectedGraph subGraph = (SimpleDirectedGraph)_subGraph.clone();
        Object[] nodes = GoGraphModel.getRoots(subGraph);
        while (nodes.length > 0) {
            i = 0;
            while (i < nodes.length) {
                Vector<Object> vector = new Vector<Object>();
                Object[] outgoingEdges = subGraph.outgoingEdgesOf(nodes[i]).toArray();
                j = 0;
                while (j < outgoingEdges.length) {
                    vector.add(((MyEdge)outgoingEdges[j]).getTarget());
                    ++j;
                }
                table.put(nodes[i], vector);
                subGraph.removeVertex(nodes[i]);
                ++i;
            }
            nodes = GoGraphModel.getRoots(subGraph);
        }
        subGraph = (SimpleDirectedGraph)_subGraph.clone();
        nodes = GoGraphModel.getLeave(subGraph);
        while (nodes.length > 0) {
            i = 0;
            while (i < nodes.length) {
                GoCell cell = new GoCell((GO_term)nodes[i]);
                Vector vector = (Vector)table.get(nodes[i]);
                j = 0;
                while (j < vector.size()) {
                    GoCell childCell = (GoCell)cellTable.get(vector.get(j));
                    cell.add((GoCell)childCell.clone());
                    ++j;
                }
                cellTable.put(nodes[i], cell);
                subGraph.removeVertex(nodes[i]);
                ++i;
            }
            nodes = GoGraphModel.getLeave(subGraph);
        }
        return cellTable;
    }

    private static Hashtable buildJGraphCell(SimpleDirectedGraph _subGraph) {
        Hashtable<Object, DefaultGraphCell> cellTable = new Hashtable<Object, DefaultGraphCell>();
        SimpleDirectedGraph subGraph = (SimpleDirectedGraph)_subGraph.clone();
        Object[] nodes = GoGraphModel.getRoots(subGraph);
        while (nodes.length > 0) {
            int i = 0;
            while (i < nodes.length) {
                GoCell sourceCell = cellTable.get(nodes[i]) == null ? new GoCell((GO_term)nodes[i]) : (GoCell)cellTable.get(nodes[i]);
                cellTable.put(nodes[i], sourceCell);
                Object[] edges = subGraph.outgoingEdgesOf(nodes[i]).toArray();
                int j = 0;
                while (j < edges.length) {
                    Object target = ((MyEdge)edges[j]).getTarget();
                    GoCell targetCell = cellTable.get(target) == null ? new GoCell((GO_term)target) : (GoCell)cellTable.get(target);
                    GoEdge edge = new GoEdge(sourceCell, targetCell);
                    cellTable.put(target, targetCell);
                    cellTable.put(nodes[i] + "" + target, edge);
                    ++j;
                }
                subGraph.removeVertex(nodes[i]);
                ++i;
            }
            nodes = GoGraphModel.getRoots(subGraph);
        }
        return cellTable;
    }

    private static ArrayList getAllChild(GoCell curViewCell, GoCell curModelCell, ArrayList queryTermList, HashSet commonSet) {
        ArrayList<DefaultGraphCell> list = new ArrayList<DefaultGraphCell>();
        Enumeration<TreeNode> children = curModelCell.children();
        while (children.hasMoreElements()) {
            TreeNode childCell = children.nextElement();
            if (!(childCell instanceof GoCell)) continue;
            GoCell childModelCell = (GoCell)childCell;
            GO_term childObj = (GO_term)childModelCell.getUserObject();
            GoCell childViewCell = new GoCell(childObj);
            if (queryTermList.contains(childObj)) {
                GraphConstants.setForeground(childViewCell.getAttributes(), queryColor);
            }
            if (commonSet.contains(childObj)) {
                GraphConstants.setForeground(childViewCell.getAttributes(), commonColor);
            }
            GoEdge edge = new GoEdge(curViewCell, childViewCell);
            list.add(childViewCell);
            list.add(edge);
            list.addAll(GraphCreator.getAllChild(childViewCell, childModelCell, queryTermList, commonSet));
        }
        return list;
    }
}

