/*
 * Decompiled with CFR 0.152.
 */
package edu.hust.go.model;

import edu.hust.go.model.GoException;
import edu.hust.go.model.GoParser;
import edu.hust.go.model.GraphPath;
import edu.hust.go.model.MyEdge;
import edu.hust.go.model.OboGoParser;
import edu.hust.go.model.OboXmlGoParser;
import edu.hust.go.model.OwlGoParser;
import edu.hust.go.model.RdfXmlGoParser;
import edu.hust.go.model.Similarity;
import edu.hust.go.term.GO_term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org._3pq.jgrapht.graph.SimpleDirectedGraph;

public class GoGraphModel {
    private final String[] rootKeys = new String[]{"GO:0008150", "GO:0005575", "GO:0003674"};
    private HashMap rootVertexesMap;
    private HashSet obsoleteSet;
    private SimpleDirectedGraph graph;

    public GoGraphModel(HashMap map) throws GoException {
        this.graph = this.init(map);
        this.rootVertexesMap = new HashMap();
        int i = 0;
        while (i < this.rootKeys.length) {
            Object root = map.get(this.rootKeys[i]);
            if (root == null) {
                System.out.println(this.rootKeys[i] + "\t**\t" + map.size());
            }
            this.rootVertexesMap.put(root, new Integer(GraphPath.getNodeAllChildren(this.graph, root).size()));
            ++i;
        }
        this.obsoleteSet = this.removeObsolete();
    }

    private SimpleDirectedGraph init(HashMap goMap) throws GoException {
        SimpleDirectedGraph g = new SimpleDirectedGraph();
        GO_term targetTerm = null;
        GO_term sourceTerm = null;
        try {
            Object[] nodes = goMap.values().toArray();
            int i = 0;
            while (i < nodes.length) {
                g.addVertex(nodes[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < nodes.length) {
                int j;
                targetTerm = (GO_term)nodes[i2];
                Vector parents = targetTerm.getIs_a();
                if (parents != null) {
                    j = 0;
                    while (j < parents.size()) {
                        sourceTerm = (GO_term)goMap.get(parents.get(j));
                        g.addEdge(new MyEdge(sourceTerm, targetTerm));
                        ++j;
                    }
                }
                if ((parents = targetTerm.getPart_of()) != null) {
                    j = 0;
                    while (j < parents.size()) {
                        sourceTerm = (GO_term)goMap.get(parents.get(j));
                        g.addEdge(new MyEdge(sourceTerm, targetTerm));
                        ++j;
                    }
                }
                ++i2;
            }
        }
        catch (Exception e) {
            System.out.println("The problems exists in!" + targetTerm + "**" + sourceTerm + "\n" + e);
            GoException exc = new GoException(sourceTerm, targetTerm);
            g = null;
            throw exc;
        }
        return g;
    }

    private HashSet removeObsolete() {
        HashSet<Object> _obsoleteSet = new HashSet<Object>();
        Object[] vertexs = this.graph.vertexSet().toArray();
        boolean counter = false;
        int i = 0;
        while (i < vertexs.length) {
            if (this.graph.inDegreeOf(vertexs[i]) == 0 && this.rootVertexesMap.get(vertexs[i]) == null) {
                _obsoleteSet.add(vertexs[i]);
                this.graph.removeVertex(vertexs[i]);
            }
            ++i;
        }
        return _obsoleteSet;
    }

    public SimpleDirectedGraph buildSubGraph(ArrayList goTerms, int parentLevel, int childLevel) {
        SimpleDirectedGraph subGraph = new SimpleDirectedGraph();
        if (parentLevel == 0) {
            this.getAllSubGraph(goTerms, subGraph, true);
        } else if (parentLevel > 0) {
            this.getPartSubGraph(goTerms, subGraph, parentLevel, true);
        }
        if (childLevel == 0) {
            this.getAllSubGraph(goTerms, subGraph, true);
        } else if (childLevel > 0) {
            this.getPartSubGraph(goTerms, subGraph, childLevel, false);
        }
        return subGraph;
    }

    public HashSet getCommonParents(ArrayList goTerms) {
        HashMap map = new HashMap();
        HashSet<Object> commonSet = new HashSet<Object>();
        int i = 0;
        while (i < goTerms.size()) {
            Object[][] nodePath = GraphPath.getPath2Root(this.graph, goTerms.get(i));
            GraphPath.getCommonElements(nodePath, map);
            ++i;
        }
        Object[] commonObjs = map.keySet().toArray();
        int i2 = 0;
        while (i2 < commonObjs.length) {
            int value = (Integer)map.get(commonObjs[i2]);
            if (value > 1) {
                commonSet.add(commonObjs[i2]);
            }
            ++i2;
        }
        return commonSet;
    }

    public float evalSimilarity(GO_term node1, GO_term node2) {
        return Similarity.evaluate(this, node1, node2, (byte)0);
    }

    public float evalSimilarity(GO_term node1, GO_term node2, byte type) {
        return Similarity.evaluate(this, node1, node2, type);
    }

    public Object[][] getPathsOfNode2Root(GO_term node) {
        return GraphPath.getPath2Root(this.graph, node);
    }

    public boolean inOnePathway(GO_term node1, GO_term node2) {
        return GraphPath.related(this.graph, node1, node2);
    }

    public HashMap getPathsBetweenNodes(GO_term node1, GO_term node2) {
        return GraphPath.getPath2Node(this.graph, node1, node2);
    }

    private void getAllSubGraph(ArrayList goids, SimpleDirectedGraph subGraph, boolean toParent) {
        int i;
        HashSet nodeSet = new HashSet(goids);
        if (toParent) {
            i = 0;
            while (i < goids.size()) {
                nodeSet.addAll(GraphPath.getNodeAllParents(this.graph, goids.get(i)));
                ++i;
            }
        } else {
            i = 0;
            while (i < goids.size()) {
                nodeSet.addAll(GraphPath.getNodeAllChildren(this.graph, goids.get(i)));
                ++i;
            }
        }
        subGraph.addAllVertices(nodeSet);
        Object[] nodes = nodeSet.toArray();
        if (toParent) {
            int i2 = 0;
            while (i2 < nodes.length) {
                subGraph.addAllEdges(this.graph.incomingEdgesOf(nodes[i2]));
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < nodes.length) {
                subGraph.addAllEdges(this.graph.outgoingEdgesOf(nodes[i3]));
                ++i3;
            }
        }
    }

    private void getPartSubGraph(ArrayList goids, SimpleDirectedGraph subGraph, int level, boolean toParent) {
        HashSet<Object> nodeSet = new HashSet<Object>(goids);
        subGraph.addAllVertices(goids);
        int i = 0;
        while (i < level) {
            Object[] vectexes = nodeSet.toArray();
            nodeSet.clear();
            int m = 0;
            while (m < vectexes.length) {
                Object[] edges = toParent ? this.graph.incomingEdgesOf(vectexes[m]).toArray() : this.graph.outgoingEdgesOf(vectexes[m]).toArray();
                int n = 0;
                while (n < edges.length) {
                    Object obj = toParent ? ((MyEdge)edges[n]).getSource() : ((MyEdge)edges[n]).getTarget();
                    nodeSet.add(obj);
                    subGraph.addVertex(obj);
                    subGraph.addEdge((MyEdge)edges[n]);
                    ++n;
                }
                ++m;
            }
            ++i;
        }
    }

    public static Object[] getRoots(SimpleDirectedGraph subGraph) {
        Object[] vertexs = subGraph.vertexSet().toArray();
        Vector<Object> subRoot = new Vector<Object>();
        int i = 0;
        while (i < vertexs.length) {
            if (subGraph.incomingEdgesOf(vertexs[i]).size() == 0) {
                subRoot.add(vertexs[i]);
            }
            ++i;
        }
        return subRoot.toArray();
    }

    public static Object[] getLeave(SimpleDirectedGraph subGraph) {
        Object[] vertexs = subGraph.vertexSet().toArray();
        Vector<Object> leave = new Vector<Object>();
        int i = 0;
        while (i < vertexs.length) {
            if (subGraph.outgoingEdgesOf(vertexs[i]).size() == 0) {
                leave.add(vertexs[i]);
            }
            ++i;
        }
        return leave.toArray();
    }

    public SimpleDirectedGraph getGraph() {
        return this.graph;
    }

    public HashMap getRootVertexesMap() {
        return this.rootVertexesMap;
    }

    public HashSet getObsoleteSet() {
        return this.obsoleteSet;
    }

    public static HashMap loadGoDefinition(String definition, byte defType) throws GoException {
        GoParser parser = null;
        HashMap goMap = null;
        try {
            switch (defType) {
                case 0: {
                    parser = new OboGoParser(definition);
                    break;
                }
                case 1: {
                    parser = new OboXmlGoParser(definition);
                    break;
                }
                case 2: {
                    parser = new RdfXmlGoParser(definition);
                    break;
                }
                case 3: {
                    parser = new OwlGoParser(definition);
                    break;
                }
            }
            goMap = parser.getTermMap();
        }
        catch (Exception e) {
            goMap = null;
        }
        if (parser == null || goMap == null || goMap.size() == 0) {
            GoException exe = new GoException(definition, defType);
            throw exe;
        }
        return goMap;
    }
}

