/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.ext;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.tree.MutableTreeNode;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.ListenableGraph;
import org._3pq.jgrapht.UndirectedGraph;
import org._3pq.jgrapht.edge.DefaultEdge;
import org._3pq.jgrapht.edge.DirectedEdge;
import org._3pq.jgrapht.edge.UndirectedEdge;
import org._3pq.jgrapht.event.GraphEdgeChangeEvent;
import org._3pq.jgrapht.event.GraphListener;
import org._3pq.jgrapht.event.GraphVertexChangeEvent;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;

public class JGraphModelAdapter
extends DefaultGraphModel {
    final Set m_jEdgesBeingAdded = new HashSet();
    final Set m_jEdgesBeingRemoved = new HashSet();
    final Set m_jVerticesBeingAdded = new HashSet();
    final Set m_jVerticesBeingRemoved = new HashSet();
    final Set m_jtEdgesBeingAdded = new HashSet();
    final Set m_jtEdgesBeingRemoved = new HashSet();
    final Set m_jtVerticesBeingAdded = new HashSet();
    final Set m_jtVerticesBeingRemoved = new HashSet();
    private final AttributeMap m_defaultEdgeAttributes;
    private final AttributeMap m_defaultVertexAttributes;
    private CellFactory m_cellFactory;
    private Graph m_jtGraph;
    private GraphListener m_jtGraphListener;
    private Map m_cellToEdge = new HashMap();
    private Map m_cellToVertex = new HashMap();
    private Map m_edgeToCell = new HashMap();
    private Map m_vertexToCell = new HashMap();

    public JGraphModelAdapter(Graph graph) {
        this(graph, null, null);
    }

    public JGraphModelAdapter(Graph graph, Map map, Map map2) {
        this(graph, map, map2, null);
    }

    public JGraphModelAdapter(Graph graph, AttributeMap attributeMap, AttributeMap attributeMap2, CellFactory cellFactory) {
        this(graph, (Map)attributeMap, (Map)attributeMap2, cellFactory);
    }

    public JGraphModelAdapter(Graph graph, Map map, Map map2, CellFactory cellFactory) {
        Object object;
        this.m_jtGraph = graph;
        if (map == null) {
            this.m_defaultVertexAttributes = JGraphModelAdapter.createDefaultVertexAttributes();
        } else {
            object = new AttributeMap(map);
            this.m_defaultVertexAttributes = (AttributeMap)object.clone();
        }
        if (map2 == null) {
            this.m_defaultEdgeAttributes = JGraphModelAdapter.createDefaultEdgeAttributes(graph);
        } else {
            object = new AttributeMap(map2);
            this.m_defaultEdgeAttributes = (AttributeMap)object.clone();
        }
        this.m_cellFactory = cellFactory == null ? new DefaultCellFactory() : cellFactory;
        if (graph instanceof ListenableGraph) {
            this.m_jtGraphListener = new JGraphTListener();
            ((ListenableGraph)graph).addGraphListener(this.m_jtGraphListener);
        }
        this.addGraphModelListener(new JGraphListener());
        object = graph.vertexSet().iterator();
        while (object.hasNext()) {
            this.addJGraphTVertex(object.next());
        }
        Iterator iterator = graph.edgeSet().iterator();
        while (iterator.hasNext()) {
            this.addJGraphTEdge((Edge)iterator.next());
        }
    }

    public org.jgraph.graph.DefaultEdge getEdgeCell(Edge edge) {
        return (org.jgraph.graph.DefaultEdge)this.m_edgeToCell.get(edge);
    }

    public DefaultGraphCell getVertexCell(Object object) {
        return (DefaultGraphCell)this.m_vertexToCell.get(object);
    }

    public DefaultPort getVertexPort(Object object) {
        DefaultGraphCell defaultGraphCell = this.getVertexCell(object);
        if (defaultGraphCell == null) {
            return null;
        }
        return (DefaultPort)defaultGraphCell.getChildAt(0);
    }

    public static AttributeMap createDefaultEdgeAttributes(Graph graph) {
        AttributeMap attributeMap = new AttributeMap();
        if (graph instanceof DirectedGraph) {
            GraphConstants.setLineEnd((Map)attributeMap, (int)2);
            GraphConstants.setEndFill((Map)attributeMap, (boolean)true);
            GraphConstants.setEndSize((Map)attributeMap, (int)10);
        }
        GraphConstants.setForeground((Map)attributeMap, (Color)Color.decode("#25507C"));
        GraphConstants.setFont((Map)attributeMap, (Font)GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        GraphConstants.setLineColor((Map)attributeMap, (Color)Color.decode("#7AA1E6"));
        return attributeMap;
    }

    public static AttributeMap createDefaultVertexAttributes() {
        AttributeMap attributeMap = new AttributeMap();
        Color color = Color.decode("#FF9900");
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)new Rectangle2D.Double(50.0, 50.0, 90.0, 30.0));
        GraphConstants.setBorder((Map)attributeMap, (Border)BorderFactory.createRaisedBevelBorder());
        GraphConstants.setBackground((Map)attributeMap, (Color)color);
        GraphConstants.setForeground((Map)attributeMap, (Color)Color.white);
        GraphConstants.setFont((Map)attributeMap, (Font)GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        GraphConstants.setOpaque((Map)attributeMap, (boolean)true);
        return attributeMap;
    }

    public void edit(Map map) {
        super.edit(map, null, null, null);
    }

    protected boolean addJGraphEdge(org.jgraph.graph.Edge edge) {
        Object object = DefaultGraphModel.getSourceVertex((GraphModel)this, (Object)edge);
        Object object2 = DefaultGraphModel.getTargetVertex((GraphModel)this, (Object)edge);
        if (!this.m_cellToVertex.containsKey(object) || !this.m_cellToVertex.containsKey(object2)) {
            Object[] objectArray = new Object[]{edge};
            this.m_jEdgesBeingRemoved.add(edge);
            super.remove(objectArray);
            return false;
        }
        Object v = this.m_cellToVertex.get(object);
        Object v2 = this.m_cellToVertex.get(object2);
        DefaultEdge defaultEdge = this.m_jtGraph instanceof UndirectedGraph ? new UndirectedEdge(v, v2) : (this.m_jtGraph instanceof DirectedGraph ? new DirectedEdge(v, v2) : new DefaultEdge(v, v2));
        this.m_jtEdgesBeingAdded.add(defaultEdge);
        boolean bl = this.m_jtGraph.addEdge(defaultEdge);
        if (bl) {
            this.m_cellToEdge.put(edge, defaultEdge);
            this.m_edgeToCell.put(defaultEdge, edge);
            return true;
        }
        super.remove(new Object[]{edge});
        return false;
    }

    protected void addJGraphTEdge(Edge edge) {
        org.jgraph.graph.DefaultEdge defaultEdge = this.m_cellFactory.createEdgeCell(edge);
        this.m_edgeToCell.put(edge, defaultEdge);
        this.m_cellToEdge.put(defaultEdge, edge);
        ConnectionSet connectionSet = new ConnectionSet();
        connectionSet.connect((Object)defaultEdge, (Object)this.getVertexPort(edge.getSource()), (Object)this.getVertexPort(edge.getTarget()));
        Object[] objectArray = new Object[]{defaultEdge};
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.put((Object)defaultEdge, this.m_defaultEdgeAttributes.clone());
        this.m_jEdgesBeingAdded.add(defaultEdge);
        super.insert(objectArray, (Map)attributeMap, connectionSet, null, null);
    }

    protected void addJGraphTVertex(Object object) {
        DefaultGraphCell defaultGraphCell = this.m_cellFactory.createVertexCell(object);
        defaultGraphCell.add((MutableTreeNode)new DefaultPort());
        this.m_vertexToCell.put(object, defaultGraphCell);
        this.m_cellToVertex.put(defaultGraphCell, object);
        Object[] objectArray = new Object[]{defaultGraphCell};
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.put((Object)defaultGraphCell, this.m_defaultVertexAttributes.clone());
        this.m_jVerticesBeingAdded.add(defaultGraphCell);
        super.insert(objectArray, (Map)attributeMap, null, null, null);
    }

    protected boolean addJGraphVertex(GraphCell graphCell) {
        Object object = graphCell instanceof DefaultGraphCell ? ((DefaultGraphCell)graphCell).getUserObject() : graphCell.toString();
        if (this.m_vertexToCell.containsKey(object)) {
            Object[] objectArray = new Object[]{graphCell};
            super.remove(objectArray);
            return false;
        }
        this.m_jtVerticesBeingAdded.add(object);
        boolean bl = this.m_jtGraph.addVertex(object);
        this.m_cellToVertex.put(graphCell, object);
        this.m_vertexToCell.put(object, graphCell);
        return bl;
    }

    protected boolean removeJGraphEdge(org.jgraph.graph.Edge edge) {
        if (!this.m_cellToEdge.containsKey(edge)) {
            return false;
        }
        Edge edge2 = (Edge)this.m_cellToEdge.get(edge);
        this.m_jtEdgesBeingRemoved.add(edge2);
        boolean bl = this.m_jtGraph.removeEdge(edge2);
        this.m_cellToEdge.remove(edge);
        this.m_edgeToCell.remove(edge2);
        return bl;
    }

    protected void removeJGraphTEdge(Edge edge) {
        org.jgraph.graph.DefaultEdge defaultEdge = (org.jgraph.graph.DefaultEdge)this.m_edgeToCell.remove(edge);
        this.m_cellToEdge.remove(defaultEdge);
        Object[] objectArray = new Object[]{defaultEdge};
        this.m_jEdgesBeingRemoved.add(defaultEdge);
        super.remove(objectArray);
    }

    protected void removeJGraphTVertex(Object object) {
        DefaultGraphCell defaultGraphCell = (DefaultGraphCell)this.m_vertexToCell.remove(object);
        this.m_cellToVertex.remove(defaultGraphCell);
        Object[] objectArray = new Object[]{defaultGraphCell, defaultGraphCell.getChildAt(0)};
        this.m_jVerticesBeingRemoved.add(defaultGraphCell);
        super.remove(objectArray);
    }

    protected boolean removeJGraphVertex(GraphCell graphCell) {
        if (!this.m_cellToVertex.containsKey(graphCell)) {
            return false;
        }
        Object v = this.m_cellToVertex.get(graphCell);
        ArrayList arrayList = this.m_jtGraph.edgesOf(v);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            arrayList = new ArrayList(arrayList.size());
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            this.m_jtGraph.removeAllEdges(arrayList);
        }
        this.m_jtVerticesBeingRemoved.add(v);
        boolean bl = this.m_jtGraph.removeVertex(v);
        this.m_cellToVertex.remove(graphCell);
        this.m_vertexToCell.remove(v);
        return bl;
    }

    private class JGraphTListener
    implements GraphListener,
    Serializable {
        private JGraphTListener() {
        }

        public void edgeAdded(GraphEdgeChangeEvent graphEdgeChangeEvent) {
            Edge edge = graphEdgeChangeEvent.getEdge();
            if (JGraphModelAdapter.this.m_jtEdgesBeingAdded.contains(edge)) {
                JGraphModelAdapter.this.m_jtEdgesBeingAdded.remove(edge);
            } else {
                JGraphModelAdapter.this.addJGraphTEdge(edge);
            }
        }

        public void edgeRemoved(GraphEdgeChangeEvent graphEdgeChangeEvent) {
            Edge edge = graphEdgeChangeEvent.getEdge();
            if (JGraphModelAdapter.this.m_jtEdgesBeingRemoved.contains(edge)) {
                JGraphModelAdapter.this.m_jtEdgesBeingRemoved.remove(edge);
            } else {
                JGraphModelAdapter.this.removeJGraphTEdge(edge);
            }
        }

        public void vertexAdded(GraphVertexChangeEvent graphVertexChangeEvent) {
            Object object = graphVertexChangeEvent.getVertex();
            if (JGraphModelAdapter.this.m_jtVerticesBeingAdded.contains(object)) {
                JGraphModelAdapter.this.m_jtVerticesBeingAdded.remove(object);
            } else {
                JGraphModelAdapter.this.addJGraphTVertex(object);
            }
        }

        public void vertexRemoved(GraphVertexChangeEvent graphVertexChangeEvent) {
            Object object = graphVertexChangeEvent.getVertex();
            if (JGraphModelAdapter.this.m_jtVerticesBeingRemoved.contains(object)) {
                JGraphModelAdapter.this.m_jtVerticesBeingRemoved.remove(object);
            } else {
                JGraphModelAdapter.this.removeJGraphTVertex(object);
            }
        }
    }

    private class JGraphListener
    implements GraphModelListener,
    Serializable {
        private JGraphListener() {
        }

        public void graphChanged(GraphModelEvent graphModelEvent) {
            GraphCell graphCell;
            Object object;
            Iterator iterator;
            GraphModelEvent.GraphModelChange graphModelChange = graphModelEvent.getChange();
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            Object[] objectArray = graphModelChange.getRemoved();
            if (objectArray != null) {
                this.filterEdgesAndVertices(objectArray, hashSet, hashSet2);
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    object = (org.jgraph.graph.Edge)iterator.next();
                    if (JGraphModelAdapter.this.m_jEdgesBeingRemoved.contains(object)) {
                        JGraphModelAdapter.this.m_jEdgesBeingRemoved.remove(object);
                        continue;
                    }
                    JGraphModelAdapter.this.removeJGraphEdge((org.jgraph.graph.Edge)object);
                }
                object = hashSet2.iterator();
                while (object.hasNext()) {
                    graphCell = (GraphCell)object.next();
                    if (JGraphModelAdapter.this.m_jVerticesBeingRemoved.contains(graphCell)) {
                        JGraphModelAdapter.this.m_jVerticesBeingRemoved.remove(graphCell);
                        continue;
                    }
                    JGraphModelAdapter.this.removeJGraphVertex(graphCell);
                }
                hashSet.clear();
                hashSet2.clear();
            }
            if ((objectArray = graphModelChange.getInserted()) != null) {
                this.filterEdgesAndVertices(objectArray, hashSet, hashSet2);
                iterator = hashSet2.iterator();
                while (iterator.hasNext()) {
                    object = (GraphCell)iterator.next();
                    if (JGraphModelAdapter.this.m_jVerticesBeingAdded.contains(object)) {
                        JGraphModelAdapter.this.m_jVerticesBeingAdded.remove(object);
                        continue;
                    }
                    JGraphModelAdapter.this.addJGraphVertex((GraphCell)object);
                }
                object = hashSet.iterator();
                while (object.hasNext()) {
                    graphCell = (org.jgraph.graph.Edge)object.next();
                    if (JGraphModelAdapter.this.m_jEdgesBeingAdded.contains(graphCell)) {
                        JGraphModelAdapter.this.m_jEdgesBeingAdded.remove(graphCell);
                        continue;
                    }
                    JGraphModelAdapter.this.addJGraphEdge((org.jgraph.graph.Edge)graphCell);
                }
            }
        }

        private void filterEdgesAndVertices(Object[] objectArray, Set set, Set set2) {
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof org.jgraph.graph.Edge) {
                    set.add(object);
                } else if (!(object instanceof Port)) {
                    if (object instanceof DefaultGraphCell) {
                        DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object;
                        if (defaultGraphCell.isLeaf() || defaultGraphCell.getFirstChild() instanceof Port) {
                            set2.add(object);
                        }
                    } else if (object instanceof GraphCell) {
                        set2.add(object);
                    }
                }
                ++n;
            }
        }
    }

    public class DefaultCellFactory
    implements CellFactory,
    Serializable {
        public org.jgraph.graph.DefaultEdge createEdgeCell(Edge edge) {
            return new org.jgraph.graph.DefaultEdge((Object)edge);
        }

        public DefaultGraphCell createVertexCell(Object object) {
            return new DefaultGraphCell(object);
        }
    }

    public static interface CellFactory {
        public org.jgraph.graph.DefaultEdge createEdgeCell(Edge var1);

        public DefaultGraphCell createVertexCell(Object var1);
    }
}

