package edu.hust.go.model;

/**
 * <p>Title: GO4J</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * @author GQ Zhang
 * @version 1.0
 */
import edu.hust.go.term.GO_term;
import edu.hust.go.model.GoParser;

public class GoException
    extends Exception {

    String msg = "";
    public GoException(String defFile, byte parseType) {
        msg = "Failed to parse the GO definition file: " + defFile + "\n";
        msg += "It may be caused by the following: \n";
        msg +=
            "\tIt is not downloaded from the GO official site: http://www.geneontology.org or ftp://ftp.geneontology.org\n";
        msg += "This defintion file is not in the format of ";
        switch (parseType) {
            case GoParser.OBO:
                msg += "OBO!";
                break;
            case GoParser.OBOXML:
                msg += "OBOXML!";
                break;
            case GoParser.RDFXML:
                msg += "RDFXML!";
                break;
            case GoParser.OWL:
                msg += "OWL!";
                break;
            default:
                msg = "Failed to parse the GO definition file: " + defFile + "\n";
                msg += "Unknown format, the format should be OBO, OBOXML, RDFXML or OWL";
        }
        msg = msg + ". There are some problems in GO definition file";
    }

    public GoException(GO_term source, GO_term target) {
        msg = "Invalid GO definition, ";
        if (source == null) {
            if (target != null) {
                msg += "and it may be have relation to " + target.getId();
            }
        }
        else {
            if (source == null) {
                msg += "and it may be have relation to " + source.getId();
            }
            else {
                msg += "and it may be have relation to " + source.getId() + " " + target.getId();
            }
        }
    }

    public String toString() {
        msg = msg +
            "\n Please make sure the GO definition file came from http://www.godatabase.org/dev/database/archive/";
        return msg;
    }
}