package edu.hust.go.model;

/**
 * <p>Title: GO4J</p>
 * <p>Description: Go api in Java</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Life Science and Technology, HUST, China</p>
 * @author GQ Zhang
 * @version 1.0
 */
import java.util.List;
import java.util.Vector;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Arrays;

import org._3pq.jgrapht.graph.SimpleDirectedGraph;
import org._3pq.jgrapht.edge.DirectedEdge;

public class GraphPath {
    public static HashSet getNodeAllParents(SimpleDirectedGraph graph, Object node) {
        return getAviableNodes(graph, node, true);
    }

    public static HashSet getNodeAllChildren(SimpleDirectedGraph graph, Object node) {
        return getAviableNodes(graph, node, false);
    }

    public static Vector getNodeParents(SimpleDirectedGraph graph, Object node) {
        return getDirectNodes(graph, node, true);
    }

    public static Vector getNodeChildren(SimpleDirectedGraph graph, Object node) {
        return getDirectNodes(graph, node, false);
    }

    private static Vector getDirectNodes(SimpleDirectedGraph graph, Object node, boolean parent) {
        Vector list = new Vector();
        List edgeList;
        if (parent) {
            edgeList = graph.incomingEdgesOf(node);
            for (int i = 0; i < edgeList.size(); i++) {
                Object obj = ( (DirectedEdge) edgeList.get(i)).getSource();
                list.add(obj);
            }
        }
        else {
            edgeList = graph.outgoingEdgesOf(node);
            for (int i = 0; i < edgeList.size(); i++) {
                Object obj = ( (DirectedEdge) edgeList.get(i)).getTarget();
                list.add(obj);
            }
        }
        return list;
    }

    private static HashSet getAviableNodes(SimpleDirectedGraph graph, Object node, boolean parent) {
        HashSet set = new HashSet();
        List edgeList;
        if (parent) {
            edgeList = graph.incomingEdgesOf(node);
            for (int i = 0; i < edgeList.size(); i++) {
                Object obj = ( (DirectedEdge) edgeList.get(i)).getSource();
                set.add(obj);
                set.addAll(getAviableNodes(graph, obj, parent));
            }
        }
        else {
            edgeList = graph.outgoingEdgesOf(node);
            for (int i = 0; i < edgeList.size(); i++) {
                Object obj = ( (DirectedEdge) edgeList.get(i)).getTarget();
                set.add(obj);
                set.addAll(getAviableNodes(graph, obj, parent));
            }
        }
        return set;
    }

    public static HashMap getPath2Node(SimpleDirectedGraph graph, Object obj1, Object obj2) {
        Vector pathVector=new Vector();
        HashSet p1Set = getNodeAllParents(graph, obj1);
        HashSet p2Set = getNodeAllParents(graph, obj2);
        HashSet commonSet = getCommonElements(p1Set.toArray(), p2Set.toArray());
        Object[][] path = getPath2Root(graph, obj1);
        for (int i = 0; i < path.length; i++) {
            for(int j=0;j<path[i].length;j++){
                if(commonSet.contains(path[i][j])){
                    pathVector.add(path[i]);
                    break;
                }
            }
        }
        path = getPath2Root(graph, obj2);
        for (int i = 0; i < path.length; i++) {
            for(int j=0;j<path[i].length;j++){
                if(commonSet.contains(path[i][j])){
                    pathVector.add(path[i]);
                    break;
                }
            }
        }
        HashMap pathMap=new HashMap();
        pathMap.put(commonSet,pathVector.toArray());
        return pathMap;
    }

    public static boolean related(SimpleDirectedGraph graph, Object obj1, Object obj2) {
        boolean related;
        if (obj1.equals(obj2)) {
            related = true;
        }
        else {
            HashSet children = getNodeAllChildren(graph, obj1);
            HashSet parents = getNodeAllParents(graph, obj1);
            related = children.contains(obj2) || parents.contains(obj2);
        }
        return false;
    }

    public static Object[][] getPath2Root(SimpleDirectedGraph graph, Object node) {
        Vector path = getPathVector(graph, node);
        return convertPahtVector2Array(path);
    }

    private static Vector getPathVector(SimpleDirectedGraph graph, Object obj) {
        Vector pathVector = new Vector();
        pathVector.add(obj);

        int pNumber = graph.inDegreeOf(obj);
        boolean finish = false;

        Object curObj = obj;
        while (pNumber < 2) {
            if (pNumber == 0) {
                finish = true;
                break;
            }
            curObj = ( (DirectedEdge) graph.incomingEdgesOf(curObj).get(0)).getSource();
            pathVector.add(curObj);
            pNumber = graph.inDegreeOf(curObj);
        }
        if (!finish) {
            Object[] edges = graph.incomingEdgesOf(curObj).toArray();
            Vector _path = new Vector(pNumber);
            for (int i = 0; i < edges.length; i++) {
                Object source = ( (DirectedEdge) edges[i]).getSource();
                _path.add(getPathVector(graph, source));
            }
            pathVector.add(_path);
        }
        return pathVector;
    }

    private static Object[][] convertPahtVector2Array(Vector fullPath) {
        int size = fullPath.size();
        Object obj = fullPath.get(size - 1);
        Object[][] pathArray;
        if (obj instanceof Vector) {
            Object[] prefixPath = new Object[size - 1];
            for (int i = 0; i < size - 1; i++) {
                prefixPath[i] = fullPath.get(i);
            }
            Vector curPath = (Vector) obj;
            HashMap map = new HashMap();
            Vector temp = new Vector();
            for (int i = 0; i < curPath.size(); i++) {
                Object[][] tempPath = convertPahtVector2Array( (Vector) curPath.get(i));
                for (int j = 0; j < tempPath.length; j++) {
                    Object[] swapPath = new Object[size - 1 + tempPath[j].length];
                    System.arraycopy(prefixPath, 0, swapPath, 0, size - 1);
                    System.arraycopy(tempPath[j], 0, swapPath, size - 1, tempPath[j].length);
                    temp.add(swapPath);

                    Integer pathLength = new Integer(swapPath.length);
                    String indexStr = (map.get(pathLength) == null) ? String.valueOf(temp.size() - 1) :
                        (map.get(pathLength) + " " + (temp.size() - 1));
                    map.put(pathLength, indexStr);
                }
            }

            pathArray = new Object[temp.size()][];
            Integer[] pathSize = new Integer[map.size()];
            map.keySet().toArray(pathSize);
            Arrays.sort(pathSize);
            int flag = 0;
            for (int i = 0; i < pathSize.length; i++) {
                String[] str = ( (String) map.get(pathSize[pathSize.length - 1 - i])).split(" ");
                for (int j = 0; j < str.length; j++) {
                    pathArray[flag++] = (Object[]) temp.get(Integer.parseInt(str[j]));
                }
            }
        }
        else {
            pathArray = new Object[1][size];
            fullPath.toArray(pathArray[0]);
        }
        return pathArray;
    }

    public static void getCommonElements(Object[][] path, HashMap map) {
        HashSet nodeSet = new HashSet();
        for (int i = 0; i < path.length; i++) {
            for (int j = 0; j < path[i].length; j++) {
                nodeSet.add(path[i][j]);
            }
        }
        Object[] nodes = nodeSet.toArray();
        for (int i = 0; i < nodes.length; i++) {
            int value = (map.get(nodes[i]) == null) ? 0 : ( (Integer) map.get(nodes[i])).intValue();
                map.put(nodes[i], new Integer(++value));
        }
    }

    public static HashSet getCommonElements(Object[] apath, Object[] bpath) {
        HashSet set = new HashSet();
        HashSet commonSet = new HashSet();
        for (int i = 0; i < apath.length; i++) {
            set.add(apath[i]);
        }
        for (int i = 0; i < bpath.length; i++) {
            if (set.contains(bpath[i])) {
                commonSet.add(bpath[i]);
            }
        }
        return commonSet;
    }

    /*public static HashSet getCommonElements(Object[][][] paths) {
        HashSet commonSet = new HashSet();
        int pathNumber = paths.length;
        HashSet[] commonSets = new HashSet[pathNumber];
        for (int i = 0; i < pathNumber; i++) {
            commonSets[i] = getCommonElements(paths[i]);
        }
        if (pathNumber > 0) {
            commonSet = commonSets[0];
            for (int i = 1; i < pathNumber; i++) {
                commonSet = getCommonElements(commonSet.toArray(), commonSets[i].toArray());
            }
        }
        return commonSet;
         }
         public static HashSet getCommonElements(Object[][] path) {
        HashSet commonSet = new HashSet();
        if (path.length == 0) {
            return commonSet;
        }
        for (int i = 0; i < path[0].length; i++) {
            commonSet.add(path[0]);
        }
        for (int i = 1; i < path.length; i++) {
            commonSet = getCommonElements(commonSet.toArray(), path[i]);
        }
        return commonSet;
         }*/
}